$(".bmenu-altmenu-button").on("click", function() {
    var selector = $(this);
    var menu = selector.parent().find(".bmenu-altmenu");
    if (menu.hasClass("active")) {
        selector.parent().find(".bmenu-altmenu").removeClass("active").hide("slow", function(mainitem) {
            selector.find("i").addClass("ri-arrow-down-s-line").removeClass("ri-arrow-up-s-line");
        });
    } else {
        selector.parent().find(".bmenu-altmenu").addClass("active").show("slow", function() {
            selector.find("i").removeClass("ri-arrow-down-s-line").addClass("ri-arrow-up-s-line");
        });
    }
    return false;
});
$("#beNavOpen").on("click", function() {
    $(".beMobileNav").show("slow", function() {
        $(".beMobileNav").addClass("active");
    });
});
$("#beNavClose").on("click", function() {
    $(".beMobileNav").hide("slow", function() {
        $(".beMobileNav").removeClass("active");
    });
});
$(".beMobileNav").click(function(e) {
    e.stopPropagation();
});
$("body").click(function() {
    if ($(".beMobileNav").hasClass("active")) {
        $(".beMobileNav").hide("slow", function() {
            $(".beMobileNav").removeClass("active");
        });
    }
});
$(".beCloseCookie").on("click", function() {
    var date = new Date();
    date.setTime(date.getTime() + (364 * 24 * 60 * 60 * 1000));
    document.cookie = "be_cookie_allow=allowed;expires=" + date.toUTCString() + ";path=/";
    $(".beCookie").remove();
    return false;
});

const triggers = document.querySelectorAll(".headerNavList > li.beHasDropdown");
const background = document.querySelector(".beDropdownBackground");
const nav = document.querySelector(".headerNav");

function handleEnter() {
    this.classList.add("trigger-enter");
    setTimeout(() => this.classList.contains("trigger-enter") && this.classList.add("trigger-enter-active"), 150);
    background.classList.add("open");
    const dropdown = this.querySelector(".beDropdown");
    const dropdownCoords = dropdown.getBoundingClientRect();
    const navCoords = nav.getBoundingClientRect();
    const coords = {
        height: dropdownCoords.height,
        width: dropdownCoords.width,
        top: dropdownCoords.top - navCoords.top,
        left: dropdownCoords.left - navCoords.left
    };
    background.style.setProperty("width", `${coords.width}px`);
    background.style.setProperty("height", `${coords.height}px`);
    background.style.setProperty("transform", `translate(${coords.left}px, ${coords.top}px)`);
}
function handleLeave() {
    this.classList.remove("trigger-enter", "trigger-enter-active");
    background.classList.remove("open");
}
triggers.forEach(trigger => trigger.addEventListener("mouseenter", handleEnter));
triggers.forEach(trigger => trigger.addEventListener("mouseleave", handleLeave));
var chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@";
var charsl = chars.length;
var result = "";
$(".beCreatePassword").on("click", function() {
    var area = $(this).data("area");
    result = "";
    for (var i = 0; i < 14; i++) {
        result += chars.charAt(Math.floor(Math.random() * (charsl + 1)));
    }
    $(area).val(result);
    return false;
});
$(".beCopyText").on("click", function() {
    navigator.clipboard.writeText($(this).data("content"));
    return false;
});
var wait = false;
$(".beCallRequest").on("click", function() {
    if (!wait) {
        wait = true;
        var item = $(this);
        var content = item.html();
        item.html('<span class="btn-spinner mx-2"></span> Lütfen Bekleyiniz!');
        var url = item.data("url");
        if (!url) {
            url = window.location.href;
        }
        var method = item.data("method");
        if (!method) {
            method = "post";
        }
        var form = item.data("form");
        var data = item.data("data");
        var datacontent = "";
        if (form) {
            datacontent = $("#" + form + "Form").serialize();
            if(data){
                datacontent += data;
            }
        } else {
            datacontent = data;
        }
        $.ajax({
            url: url,
            type: method,
            data: datacontent,
            dataType: "json",
            crossDomain: true,
            success: function(response) {
                wait = false;
                item.html(content);
                if (response.status) {
                    $.Toast("Başarılı", response.message, "success");
                    if (response.refresh) {
                        setTimeout(function() {
                            location.reload();
                        }, 1000);
                    }
                    if (response.url) {
                        setTimeout(function() {
                            window.location.href = response.url;
                        }, 1000);
                    }
                } else {
                    $.Toast("Bir Sorun Oluştu", response.message, "error");
                }
            }
        });
        return false;
    } else {
        $.Toast("Bir Sorun Oluştu", "İşlem devam ediyor lütfen bekleyiniz", "error");
    }
});

function beClassRequest(url,data,responsefunction = null) {
    if (!wait) {
        wait = true;
        $.ajax({
            url: url,
            type: "post",
            data: data,
            dataType: "json",
            crossDomain: true,
            success: function(response) {
                wait = false;
                if(responsefunction == null){
                    if (response.status) {
                        $.Toast("Başarılı", response.message, "success");
                        if (response.refresh) {
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        }
                        if (response.url) {
                            setTimeout(function() {
                                window.location.href = response.url;
                            }, 1000);
                        }
                    } else {
                        $.Toast("Bir Sorun Oluştu", response.message, "error");
                    }   
                }
                else{
                    responsefunction.call(this,response);
                }
            }
        });
    } else {
        $.Toast("Bir Sorun Oluştu", "İşlem devam ediyor lütfen bekleyiniz", "error");
    }
}

function beClassRequestItem(item,url,data,responsefunction = null) {
    if (!wait) {
        var content = item.html();
        item.html('<span class="btn-spinner mx-2"></span> Lütfen Bekleyiniz!');
        wait = true;
        $.ajax({
            url: url,
            type: "post",
            data: data,
            dataType: "json",
            crossDomain: true,
            success: function(response) {
                wait = false;
                item.html(content);
                if(responsefunction == null){
                    if (response.status) {
                        $.Toast("Başarılı", response.message, "success");
                        if (response.refresh) {
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        }
                        if (response.url) {
                            setTimeout(function() {
                                window.location.href = response.url;
                            }, 1000);
                        }
                    } else {
                        $.Toast("Bir Sorun Oluştu", response.message, "error");
                    }
                }
                else{
                    responsefunction.call(this,response);
                }
            }
        });
    } else {
        $.Toast("Bir Sorun Oluştu", "İşlem devam ediyor lütfen bekleyiniz", "error");
    }
}