<?php

    namespace App\System\Vendor;

    class beUpload {
        public const beDefaultExtensions = [
            "jpg" => "image/jpeg","jpeg" => "image/jpeg","png" => "image/png","gif" => "image/gif","svg" => "image/svg+xml","webp" => "image/webp",
            "html" => "text/html","json" => "application/json",
            "txt" => "text/plain","ini" => "text/plain","cfg" => "text/plain",
            "pdf" => "application/pdf",
            "rar" => "application/vnd.rar","zip" => "application/zip","gz" => "application/gzip","7z" => "application/x-7z-compressed"
        ];
        public static function beUploadCDN($filepath){
            echo "CDN yükleniyor!";
        }
        public static function beDownloadFile($url = "",$filename = "",$path = ""){
            $file = file_get_contents($url);
            if(!$file){
                return ["status" => false,"type" => 1,"message" => "Belirtilen dosya bulunamadı!"];
            }
            $filepath = $path.$filename;
            if(!file_put_contents($filepath,$file)){
                return ["status" => false,"type" => 2,"message" => "Dosya taşınırken bir sorun oluştu lütfen izinleri kontrol edin!"];
            }
            return ["status" => true,"message" => "Başarılı bir şekilde dosya taşındı!","filepath" => $filepath];
        }
        public static function beUploadFile($file = [],$filename = "",$path = "",$max_mb = 0,$extensions = null,$addextension = true){
            if($file["error"]){
                return ["status" => false,"type" => 1,"message" => $file["error"]];
            }
            $extension =  self::beGetExtension($file["name"]);
            if(!$extensions){
                if(!in_array($extension,array_keys(self::beDefaultExtensions))){
                    return ["status" => false,"type" => 2,"message" => "Belirtilen dosya uzantısına izin verilmiyor!"];
                }
            }
            else{
                if(!in_array($extension,$extensions)){
                    return ["status" => false,"type" => 2,"message" => "Belirtilen dosya uzantısına izin verilmiyor!"];
                }
            }
            $size = $file["size"];
            if($max_mb){
                $sizemb = round($size/1024,2);
                if($sizemb > $max_mb){
                    return ["status" => false,"type" => 3,"message" => "Dosya boyutu çok büyük","size" => $sizemb,"maximum" => $max_mb];
                }
            }
            if(empty($filename)){
                $filename = $file["name"];
            }
            else{
                if($addextension){
                    $filename .= ".".$extension;
                }
            }
            $filepath = $path."/".$filename;
            if(!move_uploaded_file($file["tmp_name"],$filepath)){
                return ["status" => false,"type" => 4,"message" => "Dosya taşınırken bir sorun oluştu lütfen izinleri kontrol edin!"];
            }
            return ["status" => true,"message" => "Başarılı bir şekilde dosya taşındı!","filepath" => $filepath,"filename" => $filename,"size" => $size];
        }
        public static function beSetSpecialFile($filename,$data,$path){
            $extension = ".diyo";
            $realname = $filename.$extension;
            $filepath = $path."/".$realname;
            if(!file_put_contents($filepath,$data)){
                return ["status" => false,"message" => "Dosya oluşturulurken bir sorun oluştu lütfen izinleri kontrol edin!"];
            }
            $size = filesize($filepath);
            return ["status" => true,"message" => "Başarılı bir şekilde dosya taşındı!","filepath" => $filepath,"filename" => $filename,"realname" => $realname,"size" => $size];
        }
        public static function beGetExtension($name = ""){
            return strtolower(substr(strrchr($name,"."),1));
        }
    }
?>
