<?php

    namespace App\System\Vendor;
    use App\System\Model\TicketDepertmentModel;
    use App\System\Model\TicketModel;
    use App\System\Model\TicketPostModel;

    class beTicket {
        public static function beInsertTicket($data){
            $tid = TicketModel::beInsert([
                "uid" => $data["uid"],
                "upid" => $data["upid"],
                "tsubject" => $data["subject"],
                "tstatus" => $data["status"],
                "tlastreply" => $data["lastreply"],
                "tlastreplydateline" => $data["dateline"],
                "tdepertment" => $data["depertment"],
                "tipaddress" => $data["ipaddress"],
                "tdateline" => $data["dateline"]
            ]);
            return ["status" => true,"tid" => $tid];
        }
        public static function beGetTicket($tid,$select = "*"){
            $ticket = TicketModel::beSelect($select)->beWhere("tid",$tid)->beGet();
            if(!$ticket){
                return ["status" => false,"message" => "Belirtilen talep sistemde bulunamadı!"];
            }
            return array_merge(["status" => true],$ticket);
        }
        public static function beTicketPost($data = []){
            $tpid = TicketPostModel::beInsert([
                "tid" => $data["tid"],
                "uid" => $data["uid"],
                "tpmessage" => $data["message"],
                "tpfiles" => $data["files"],
                "tpipaddress" => $data["ipaddress"],
                "tpdateline" => $data["dateline"],
            ]);
            return ["status" => true,"tpid" => $tpid];
        }
        public static function beUpdateTicket($tid,$data){
            TicketModel::beUpdate($data)->beWhere("tid",$tid)->beExecute();
            return ["status" => true];
        }
        public static function beUpdateTicketStatus($tid,$status){
            $statustext = [-1 => "closed",0 => "active",1 => "inprocess"];
            if(!$statustext[$status]){
                return ["status" => false,"message" => "Belirtilen talep durumu bulunamadı!"];
            }
            TicketModel::beUpdate([
                "tstatus" => $statustext[$status]
            ])->beWhere("tid",$tid)->beExecute();
            return ["status" => true];
        }
        public static function beUpdateTicketAdmin($tid,$uid){
            TicketModel::beUpdate([
                "tadmin" => $uid
            ])->beWhere("tid",$tid)->beExecute();
            return ["status" => true];
        }
        public static function beUpdateTicketDepartment($tid,$tdid){
            $depertment = TicketDepertmentModel::beSelect("tdid")->beWhere("tdid",$tdid)->beGet();
            if(!$depertment){
                return ["status" => false,"message" => "Belirtilen depertman sistemde bulunamadı!"];
            }
            TicketModel::beUpdate([
                "tdepertment" => $depertment["tdid"]
            ])->beWhere("tid",$tid)->beExecute();
            return ["status" => true];
        }
    }
?>
