<?php

    namespace App\System\Vendor;
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use App\System\Basic\beModel;
    use App\System\Basic\beViewer;
    use App\System\Model\AuthModel;
    use App\System\Model\SettingModel;
    use PHPMailer\PHPMailer\SMTP;

    class beMail {
        public static function beCreateMail($subject,$text,$priorty,$template = 0,$uid = 0){
            if($uid == 0){
                $user = Auth::beGetUser();
                $uid = $user["uid"];
            }
            $mid = beModel::beInsert([
                "uid" => $uid,
                "msubject" => $subject,
                "mmessage" => $text,
                "mtemplate" => strval($template),
                "mpriorty" => strval($priorty),
                "mstatus" => $priorty == 1 ? "1":"0",
                "mdateline" => BE_TIME
            ],"be_mail");
            if($priorty == 1){
                $user = AuthModel::beSelect("email")->beWhere("uid",$uid)->beGet();
                return self::beSendMail($user["email"],$subject,$template == 1 ? self::bePrepareMail($text):$text);
            }
            return ["success" => true,"mid" => $mid];
        }
        public static function bePrepareMail($message){
            $template = file_get_contents(BE_APPPATH."vendor/mail/email_template.html");
            $template = str_replace("{message}",$message,$template);
            $template = beViewer::beGetViewRaw($template);
            return $template;
        }
        public static function beSendMail($adress,$subject,$message){
            require_once BE_APPPATH."vendor/mail/Exception.php";
            require_once BE_APPPATH."vendor/mail/PHPMailer.php";
            require_once BE_APPPATH."vendor/mail/SMTP.php";
            $settings = SettingModel::beGetSettings("mail_host,mail_username,mail_password,mail_securitytype,mail_port,mail_sender");
            $mail = new PHPMailer(true);
            try {
                $mail->CharSet = "UTF-8";
                $mail->SMTPDebug = 0;
                $mail->isSMTP(); 
                $mail->Host = $settings["mail_host"];
                $mail->SMTPAuth = true;
                $mail->Username = $settings["mail_username"];
                $mail->Password = $settings["mail_password"];
                $mail->SMTPSecure = $settings["mail_securitytype"];
                $mail->Port = $settings["mail_port"];
                $mail->setfrom($settings["mail_username"],$settings["mail_sender"]);
                $mail->addAddress($adress);
                $mail->addReplyTo($settings["mail_username"],$settings["mail_sender"]);
                $mail->isHTML(true);
                $mail->Subject = $subject;
                $mail->Body = $message;
                $mail->send();
                return ["status" => true];
            } 
            catch(Exception $error) {
                beModel::beInsert([
                    "uid" => 0,
                    "sltitle" => "Mail Gönderim Hatası",
                    "slcontent" => "Mail gönderillirken bir sorun oluştu: ".$mail->ErrorInfo,
                    "sldata" => json_encode(["mail" => $adress],JSON_UNESCAPED_UNICODE),
                    "sldateline" => BE_TIME
                ],"be_system_logs");
                return ["status" => false,"error" => $mail->ErrorInfo];
            }
        }
    }
?>