<?php

namespace App\System\Task;

use App\System\Model\AttachmentModel;
use App\System\Model\InvoiceModel;
use App\System\Model\MessageTemplateModel;
use App\System\Model\SettingModel;
use App\System\Model\UserInfoModel;
use App\System\Vendor\beAlert;
use App\System\Vendor\beMail;
use App\System\Vendor\beModule;
use App\System\Vendor\beSms;
use App\System\Vendor\beUpload;
use \Exception;

class SendInvoiceMailTask {
    //@ioncube.dk beEncrypt("be_diyocp","run_task") -> "a903b9989410f22c7cf61ad14daefea3" RANDOM
    public function run_task($task){
        $setting = SettingModel::beSelect("scode,svalue")->beWhere("scode","system_invoice_module")->beGet();
        if($setting["svalue"] == ""){ 
            throw new Exception("Resmi fatura modülü bulunamadı!");
        }
        $invoicemodule = $setting["svalue"];
        $messages = MessageTemplateModel::beGetMessages("invoice_official_created",1)["invoice_official_created"];
        beModule::beLoadModule("invoice.{$invoicemodule}");
        if(!beModule::beCheckModuleFunction($invoicemodule,"login")){
            throw new Exception("Resmi fatura sisteminde giriş modülü bulunamadı!");
        }
        $timenow = BE_TIME;
        $sitename = beGetConfig("sitename");
        $invoices = InvoiceModel::beSelect("iid,be_invoices.uid,iname,ibilldata,u.name,u.surname")->beWhere("ibill","1")->beWhere("ibilldata","","!=")->beWhere("ibilldate",$timenow-259200,"<")->beJoin("INNER JOIN be_users as u ON u.uid = be_invoices.uid")->beGetAll();
        if($invoices){
            $logindata = beModule::beRunModuleFunction($invoicemodule,"login");
            if(!$logindata["status"]){
                if(!$logindata["message"]){
                    $logindata["message"] = "Resmi fatura sisteminde kullandığınız modülde giriş kısmında bir sorun yaşandı!";
                }
                throw new Exception($logindata["message"]);
            }
        }
        foreach($invoices as $invoice){
            $ibilldata = json_decode($invoice["ibilldata"],true);
            $attachment = AttachmentModel::beSelect("aid,aslug")->beWhere("aid",$ibilldata["aid"])->beGet();
            if(!$attachment){
                continue;
            }
            InvoiceModel::beUpdate(["ibill" => "2"])->beWhere("iid",$invoice["iid"])->beExecute();
            $userinfo = UserInfoModel::beSelect("uid,uisettings")->beWhere("uid",$invoice["uid"])->beGet();
            $uisettings = json_decode($userinfo["uisettings"],true);
            $officalinvoicelink = beGetRoute("file.show",["slug" => $attachment["aslug"],"aid" => $attachment["aid"]]);
            if($messages["alert"] && $uisettings["notification_alert"]){
                $message = str_replace(["{sitename}","{invoicename}","{namesurname}","{officalinvoicelink}"],[$sitename,$invoice["iname"],$invoice["name"]." ".$invoice["surname"],$officalinvoicelink],$messages["alert"]["mttmessage"]);
                beAlert::beCreateAlert(json_encode(["message" => $message],JSON_UNESCAPED_UNICODE),$officalinvoicelink,$userinfo["uid"]);
            }
            if($messages["sms"] && $uisettings["sms_alert"]){
                $message = str_replace(["{sitename}","{invoicename}","{namesurname}","{officalinvoicelink}"],[$sitename,$invoice["iname"],$invoice["name"]." ".$invoice["surname"],$officalinvoicelink],$messages["sms"]["mttmessage"]);
                beSms::beCreateSms($message,1,$userinfo["uid"]);
            }
            if($messages["mail"] && $uisettings["mail_alert"]){
                $message = str_replace(["{sitename}","{invoicename}","{namesurname}","{officalinvoicelink}"],[$sitename,$invoice["iname"],$invoice["name"]." ".$invoice["surname"],$officalinvoicelink],$messages["mail"]["mttmessage"]);
                beMail::beCreateMail($messages["mail"]["mttsubject"],$message,2,1,$userinfo["uid"]);
            }
        }
        if(beModule::beCheckModuleFunction($invoicemodule,"logout")){
            beModule::beRunModuleFunction($invoicemodule,"logout",$logindata);
        }
    }
}
?>