<?php

namespace App\System\Task;

use App\System\Model\CurrencyModel;
use App\System\Model\ProductAddonTranslationsModel;
use App\System\Model\ServerModel;
use App\System\Model\SettingModel;
use App\System\Vendor\beModule;
use App\System\Vendor\bePlugin;
use \Exception;

class HetznerCloudTask {
    public function run_task($task){
        $server = ServerModel::beGetServer("hetznercloud");
        if(!$server){
            throw new Exception("Hetzner Cloud eklentileri için Hetzner Cloud modülünün sunucu bilgileri girilmemiş.");
        }
        $settings = SettingModel::beGetSettings("hetznercloud_auto_price,hetznercloud_profit_rate");
        if(!$settings["hetznercloud_auto_price"]){
            throw new Exception("Hetzner Cloud ürünleri için otomatik fiyatlandırma sistemi aktif değil!");
        }
        beModule::beLoadModule("product.hetznercloud");
        $module = beModule::beGetModule("hetznercloud");
        $response = $module->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "servertypes",
            "data" => [
                "login_token" => $server["stoken"]
            ]
        ]);
        if(!$response["status"]){
            throw new Exception($response["message"]);
        }
        $servertypes = $response["servertype"];
        $response = $module->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "datacenters",
            "data" => [
                "login_token" => $server["stoken"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        $datacenters = $response["datacenters"];
        foreach($servertypes as $skey => $servertype){
            $productaddontranslation = ProductAddonTranslationsModel::beSelect("patid,paoptions")->beWhere("pacode","hetznercloud_{$servertype['name']}")->beGet();
            if(!$productaddontranslation){
                continue;
            }
            $paoptions = json_decode($productaddontranslation["paoptions"],true);
            foreach($servertype["prices"] as $pkey => $price){
                $location = $price["location"];
                $found = false;
                $datacenter = [];
                foreach($datacenters as $dkey => $datacenter){
                    if($datacenter["location"]["name"] != $location){
                        continue;
                    }
                    $found = true;
                    break;
                }
                if(!$found){
                    continue;
                }
                $itemprice = round($price["price_monthly"]["net"],4);
                $itemprice = round(($itemprice*(100+$settings["hetznercloud_profit_rate"]))/100,4);
                foreach($paoptions as $key => $value){
                    if($value["oname"] == $datacenter["location"]["city"]){
                        $paoptions[$key]["oprice"] = $itemprice;
                        break;
                    }
                }
            }
            ProductAddonTranslationsModel::beUpdate(["paoptions" => json_encode($paoptions,JSON_UNESCAPED_UNICODE)])->beWhere("patid",$productaddontranslation["patid"])->beExecute();
        }
    }
}

?>