<?php

namespace App\System\Task;

use App\System\Model\CurrencyModel;
use App\System\Vendor\bePlugin;
use \Exception;

class CurrencyTask {
    //@ioncube.dk beEncrypt("be_diyocp","run_task") -> "a903b9989410f22c7cf61ad14daefea3" RANDOM
    public function run_task($task){
        bePlugin::beRunHook("task_currency_pre");
        $defaultcode = "TRY";
        $currencylist = file_get_contents("https://www.tcmb.gov.tr/kurlar/today.xml");
        if(!$currencylist){
            throw new Exception("TCMB üzerinden bilgiler çekilemedi!");
        }
        $currencylist = json_decode(json_encode(simplexml_load_string($currencylist)),true);
        $currecies = CurrencyModel::beSelect("cid,ccode")->beWhere("ccode",$defaultcode,"!=")->beGetAll();
        foreach($currencylist["Currency"] as $currencydata){
            foreach($currecies as $currency){
                if($currencydata["@attributes"]["CurrencyCode"] == $currency["ccode"]){
                    CurrencyModel::beUpdate(["crate" => $currencydata["ForexSelling"]])->beWhere("cid",$currency["cid"])->beExecute();
                }
            }
        }
        bePlugin::beRunHook("task_currency_post");
    }
}

?>