<?php
    if(~BE_SYSTEMMODE & BE_DEVELOPMENT){
        $mainfile = BE_APPPATH."resources/cache/system.json";
        $system = json_decode(file_get_contents($mainfile),true);
        $update = false;
        $appslash = substr(BE_APPPATH,0,-1);
        foreach($system["mainfiles"] as $key => $file){
            if(!$file){
                continue;
            }
            $altfile = $file;
            if(!file_exists($altfile)){
                $system["mainfiles"][$key] = "";
                $update = true;
            }
            require $altfile;
        }
        if($update){
            file_put_contents($mainfile,json_encode($system,JSON_UNESCAPED_UNICODE));
        }
    }
    else{
        $mainfile = BE_APPPATH."resources/cache/system.json";
        $system = json_decode(file_get_contents($mainfile),true);
        $system["mainfiles"] = [];

        $controllers = BE_APPPATH."controllers";
        $checkdir = "{$controllers}/*";
        foreach(glob($checkdir) as $file){
            $name = str_replace($controllers."/","",$file);
            if(is_dir($file)){
                foreach(glob($file."/*") as $altfile){
                    require $altfile;
                    $system["mainfiles"][] = $altfile;
                }
            }
            else{
                require $file;
                $system["mainfiles"][] = $file;
            }
        }
        $controllers = BE_APPPATH."middleware";
        $checkdir = "{$controllers}/*";
        foreach(glob($checkdir) as $file){
            $name = str_replace($controllers."/","",$file);
            if(is_dir($file)){
                foreach(glob($file."/*") as $altfile){
                    require $altfile;
                    $system["mainfiles"][] = $altfile;
                }
            }
            else{
                require $file;
                $system["mainfiles"][] = $file;
            }
        }
        $controllers = BE_APPPATH."models";
        $checkdir = "{$controllers}/*";
        foreach(glob($checkdir) as $file){
            $name = str_replace($controllers."/","",$file);
            if(is_dir($file)){
                foreach(glob($file."/*") as $altfile){
                    require $altfile;
                    $system["mainfiles"][] = $altfile;
                }
            }
            else{
                require $file;
                $system["mainfiles"][] = $file;
            }
        }
        $controllers = BE_APPPATH."vendor/basic";
        $checkdir = "{$controllers}/*";
        foreach(glob($checkdir) as $file){
            $name = str_replace($controllers."/","",$file);
            if(is_dir($file)){
                foreach(glob($file."/*") as $altfile){
                    require $altfile;
                    $system["mainfiles"][] = $altfile;
                }
            }
            else{
                require $file;
                $system["mainfiles"][] = $file;
            }
        }
        $controllers = BE_APPPATH."vendor/";
        $packages = $be->packages;
        foreach($packages as $package){
            $file = $controllers.$package;
            if(is_dir($file)){
                foreach(glob($file."/*.php") as $altfile){
                    require $altfile;
                    $system["mainfiles"][] = $altfile;
                }
            }
            else{
                require $file.".php";
                $system["mainfiles"][] = $file;
            }
        }
        file_put_contents($mainfile,json_encode($system,JSON_UNESCAPED_UNICODE));
    }
?>