<?php

use App\System\Basic\beRouter;
use App\System\Basic\beViewer;
use App\System\Basic\beCache;
use App\System\Basic\beConfigurator;
use App\System\Model\SettingModel;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;

//@ioncube.dk beEncrypt("be_diyocp","beGetConfigs") -> "a7f13a705d87beec4ea06c6b9b5e9eff" RANDOM
function beGetConfigs($config = ""){
    if(empty($config)){
        $files = BE_APPPATH."config/*.php";
        foreach(glob($files,"*") as $file){
            require_once $file;
        }
    }
    else{
        $file = BE_APPPATH."config/{$config}.php";
        if(file_exists($file)){
            require_once $file;
        }
        else{
            echo "no";
        }
    }
}
//@ioncube.dk beEncrypt("be_diyocp","beFileExits") -> "522c275e10fea3803b77782281a25686" RANDOM
function beFileExits($file = ""){
    if(file_exists(BE_ROOT.$file)){
        return true;
    }
    return false;
}
//@ioncube.dk beEncrypt("be_diyocp","bePrintPage") -> "52bf7078dfa9c20010dbb35310ee35d4" RANDOM
function bePrintPage($view){
    echo $view;
    exit;
}
//@ioncube.dk beEncrypt("be_diyocp","beLoadModule") -> "a6398ef528425bdf9ce3cb7e3bb9b267" RANDOM
function beLoadModule($name = ""){
    $controllers = BE_APPPATH."vendor/";
    $file = $controllers.$name;
    if(is_dir($file)){
        foreach(glob($file."/*.php") as $altfile){
            require_once $altfile;
        }
    }
    else{
        require_once $file.".php";
    }
}
//@ioncube.dk beEncrypt("be_diyocp","beGetRoute") -> "15cc0b2744043a1f36555f92f059daf7" RANDOM
function beGetRoute($name = "",$params = []){
    return beGetConfig("siteurl").beRouter::beGetRoute($name,$params);
}
//@ioncube.dk beEncrypt("be_diyocp","beGetConfig") -> "d8d4885d6ecd57f3ba3a0e689c1941ac" RANDOM
function beGetConfig($name = ""){
    $config = beConfigurator::beGetConfig($name);
    if($config === false){
        global $be;
        if($be->settings[$name]){
            return $be->settings[$name];
        }
        $setting = SettingModel::beGetSettings($name);
        if($setting){
            $config = $setting[$name];
        }
    }
    return $config;
}
//@ioncube.dk beEncrypt("be_diyocp","beRunHook") -> "8ec7c92bfc5d24bd068f6328622231f2" RANDOM
function beRunHook($name = "",$data = null){
    if($data){
        return bePlugin::beRunHook($name,$data);
    }
    else{
        bePlugin::beRunHook($name);
        return true;
    }
}
//@ioncube.dk beEncrypt("be_diyocp","beGetView") -> "54627337dfe9d6cb640acfc85f110025" RANDOM
function beGetView($name = "",$params = []){
    return beViewer::beGetView($name,$params);
}
//@ioncube.dk beEncrypt("be_diyocp","beGetCache") -> "a19a50e43230728c52b083e664be3acf" RANDOM
function beGetCache($name = ""){
    return beCache::beGetCache($name);
}
//@ioncube.dk beEncrypt("be_diyocp","beSetCache") -> "8a8265691f0d2b18e7a56a5922863b21" RANDOM
function beSetCache($name = "",$value){
    return beCache::beSetCache($name,$value);
}
//@ioncube.dk beEncrypt("be_diyocp","beCacheExits") -> "f15c8586f8880e26f2d7f5a3530a6777" RANDOM
function beCacheExits($name = ""){
    return beCache::beCacheExist($name);
}
//@ioncube.dk beEncrypt("be_diyocp","beGetLang") -> "308fc3d846c42c3799f08ce176579b9b" RANDOM
function beGetLang($name,$words = []){
    $lang = beLanguage::beLang($name);
    if($words){
        foreach($words as $word => $value){
            $lang = str_replace("{".$word."}",$value,$lang);
        }
    }
    return $lang;
}
function __($name,$words = []){
    $lang = beLanguage::beLang($name);
    if($words){
        foreach($words as $word => $value){
            $lang = str_replace("{".$word."}",$value,$lang);
        }
    }
    return $lang;
}
//@ioncube.dk beEncrypt("be_diyocp","beCacheSpecial") -> "532624b52f8bf9ff989051b8d7ce949c" RANDOM
function beCacheSpecial($cachename,$viewname,$time,$type = "view"){
    if(!beCache::beCacheExist($cachename."_info")){
        beCache::beSetCache($cachename."_info",json_encode([
            "cachetime" => BE_TIME+$time
        ]));
        if($type == "view"){
            $content = beGetView($viewname);
        }
        else{
            $content = $viewname;
        }
        beCache::beSetCache($cachename."_content",$content);
    }
    else{
        $page = json_decode(beCache::beGetCache($cachename."_info"),JSON_UNESCAPED_UNICODE);
        $content = beCache::beGetCache($cachename."_content");
        if($page["cachetime"] && BE_TIME > $page["cachetime"]){
            beCache::beDeleteCache([$cachename."_info",$cachename."_content"]);
        }
    }
    return $content;
}
//@ioncube.dk beEncrypt("be_diyocp","beError") -> "f6bbbde6f436eebde2b3306fc388cdb2" RANDOM
function beError($subject,$message,$extra = []){
    http_response_code(404);
    beSetHeaderContent();
    $data = [
        "subject" => $subject,
        "message" => $message
    ];
    if($extra){
        $data = array_merge($data,$extra);
    }
    echo beGetView("error",["data" => $data]);
    exit;
}
//@ioncube.dk beEncrypt("be_diyocp","beConvertNumber") -> "5f654245d12b05ad4be8cdd298c5027a" RANDOM
function beConvertNumber($numbers){
   $readable = ["","B","M","T"];
   $index = 0;
   while($numbers > 1000){
      $numbers /= 1000;
      $index += 1;
   }
   return(round($numbers, 2)." ".$readable[$index]);
}
//@ioncube.dk beEncrypt("be_diyocp","beConvertSize") -> "018c73646f442955b402a3acde9642f0" RANDOM
function beConvertSize($size){
    $units = ["B","KB","MB","GB","TB"];
    $power = $size > 0 ? floor(log($size,1024)):0;
    return number_format($size/pow(1024, $power),2,".",",")." ".$units[$power];
}
//@ioncube.dk beEncrypt("be_diyocp","bePaganation") -> "f8f706237a88d8b0f4c006585a8fb433" RANDOM
function bePaganation($activepage,$itemcount,$itemlink = "",$maxlimit = 0,$type = "admin"){
    $itemlimit = ($maxlimit > 0) ? $maxlimit:15;
    $pagecount = round($itemcount/$itemlimit);
    if(!$pagecount){
        $pagecount = 1;
    }
    if($itemcount-($pagecount*$itemlimit) > 0){
        $pagecount += 1;
    }
    if($activepage > $pagecount || $activepage < 1){
        $activepage = 1;
    }
    if($pagecount > 6){
        $golastpage = true;
    }
    if($pagecount > 5 && $activepage > 5){
        $gofirstpage = true;
        $startcount = $activepage-3;
        $endcount = $activepage+3;
        if($endcount > $pagecount){
            $endcount = $pagecount;
        }
    }
    if(!$startcount){
        $startcount = 1;
        $endcount = $pagecount > 6 ? 6:$pagecount;
    }
    $paganation = "";
    if($pagecount > 1){
        if($type == "admin"){
            $type = "";
        }
        else{
            $type = "-user";
        }
        $paganation = beGetView("paganation".$type,["itemlink" => $itemlink,"pagecount" => $pagecount,"activepage" => $activepage,"startcount" => $startcount,"endcount" => $endcount,"golastpage" => $golastpage,"gofirstpage" => $gofirstpage]);
    }
    return [
        "itemlimit" => $itemlimit,
        "pagecount" => $pagecount,
        "activepage" => $activepage,
        "itemstart" => $itemlimit*($activepage-1),
        "paganation" => $paganation
    ];
}
//@ioncube.dk beEncrypt("be_diyocp","beAjaxError") -> "12f74ae75b9d0b8a4a563797405fa5fe" RANDOM
function beAjaxError($data){
    return json_encode(array_merge(["status" => false],$data),JSON_UNESCAPED_UNICODE);
}
//@ioncube.dk beEncrypt("be_diyocp","beAjaxSuccess") -> "fcbdf4d9d467acc5b012b82b30b0747d" RANDOM
function beAjaxSuccess($data){
    return json_encode(array_merge(["status" => true],$data),JSON_UNESCAPED_UNICODE);
}
//@ioncube.dk beEncrypt("be_diyocp","beEncryptData") -> "8909085a6007a20ca2c660c16e783230" RANDOM
function beEncryptData($text = "",$key = "beSystems"){
    return openssl_encrypt($text,"AES-128-CBC",$key);
}
//@ioncube.dk beEncrypt("be_diyocp","beDecryptData") -> "0088de46f71eb164fc7db81f1cde4fdb" RANDOM
function beDecryptData($text = "",$key = "beSystems"){
    return openssl_decrypt($text,"AES-128-CBC",$key);
}
//@ioncube.dk beEncrypt("be_diyocp","__") -> "ca6205d65e20cbddf43b0de20d2606ba" RANDOM
?>