<div class="card" id="product{{ $upid }}">
    <div class="card-content">
        <div class="basket">
            <div class="logo">
                <a href="{{ $producturl }}" target="_blank">
                    <img src="{{ $item['product']['pimage'] }}" width="64" height="64" alt="{{ $item['product']['pname'] }}">
                </a>
            </div>
            <div class="item">
                <div class="mb-2">
                    <a href="{{ $producturl }}" target="_blank" class="text-hard">{{ $item['product']['pname'] }}</a>
                </div>
                <div class="item-details mb-4 font-300">
                    <span>{{ $item['product']['pdescription'] }}</span>
                </div>
                <div class="item-details mb-1">
                    <span>Periyot</span>
                    <i class="ri-checkbox-blank-circle-fill"></i>
                    <span class="options">{{ ($item['periodoptions'][1] > 1 ? $item['periodoptions'][1].' '.$item['periodoptions'][1]:$item['periodoptions'][2]).' - '.$item['periodoptions'][3].$item['icon'] }}</span>
                </div>
                @foreach($item['addonoptions'] as $addon)
                <div class="item-details mb-1">
                    <span>{{ $addon[0] }}</span>
                    <i class="ri-checkbox-blank-circle-fill"></i>
                    <span class="options">{{ $addon[1] }}</span>
                </div>
                @endforeach
                <div class="buttons">
                    <div class="counter">
                        <div class="minus beUpdateCount" data-upid="{{ $upid }}" data-counter="-">
                            -
                        </div>
                        <div class="count">
                            {{ $count }}
                        </div>
                        <div class="plus beUpdateCount" data-upid="{{ $upid }}" data-counter="+">
                            +
                        </div>
                    </div>
                    <div class="trash removeProduct" data-upid="{{ $upid }}" role="button">
                        <i class="ri-delete-bin-line text-danger"></i>
                    </div>
                </div>
            </div>
            <div class="price">
                {{ ($item['havediscount'] == true ? '<del>'.beMoneyFormat($item['productmainprice']).'</del> ':'').beMoneyFormat($item['productprice']).$item['icon'] }}
            </div>
        </div>
    </div>
</div>