@extend('clientarea.layout')
@section('title'){{ $table_name }} - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-line"></i> {{ $table_name }}</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Fatura No</th>
                    <th>Fatura</th>
                    <th>Tutar</th>
                    <th>Son Ödeme Tarihi</th>
                    <th>Durum</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($invoices)
                @foreach($invoices as $invoice)
                <tr>
                    <td>
                        <input class="form-check-input beInvoiceCheckbox" type="checkbox" data-iid="{{ $invoice['iid'] }}">
                        <span># dPi-{{ $invoice['iid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $invoice['iname'] }}</span>
                            <span class="second-row">{{ $invoice['idescription'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beMoneyFormat($invoice['iprice']).' '.$currencies[$invoice['cid']]['cicon'] }}</span>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($invoice['iexpiredate']) }}</span>
                    </td>
                    <td>
                        <span class="btn btn-special">
                            {{ $invoicestatus[$invoice['istatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <div class="buttons">
                            @if($invoice['istatus'] == 0)
                            <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}?action=pay" class="btn btn-primary btn-sm mr-2">
                                <i class="ri-secure-payment-line"></i>
                                Öde
                            </a>
                            @endif
                            <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}" class="btn btn-transparent btn-sm">
                                <i class="ri-eye-line"></i>
                                Görüntüle
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="card-info mb-3">
            <div>
                <span>Ödenmemiş <b>{{ $invoice_count }}</b> adet faturanız bulunuyor!</span>
            </div>
        </div>
        <div class="card-body">
            <div>
                <a class="btn btn-transparent beInvoiceMerge" href="#">Seçilileri Toplu Öde</a>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
$(".beInvoiceMerge").on("click",function(){
    var iids = [];
    $(".beInvoiceCheckbox").each(function(index){
        if($(this).is(":checked")){
            iids.push($(this).data("iid"))
        }
    });
    beClassRequestItem($(this),"{{ beGetRoute('client.invoice.process.post') }}",{action:"collective",iids:iids});
    return false;
});
</script>
@endsection