@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Paylaşımlı Sunucu Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="serverForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sunucu Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sunucu Url</label>
                            <input type="text" class="form-control" name="url">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kullanıcı Adı</label>
                            <input type="text" class="form-control" name="username">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Şifre</label>
                            <input type="text" class="form-control" name="password">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Modül</label>
                            <select class="form-control form-control-select" name="module">
                                @foreach($modulelist as $key => $module)
                                <option value="{{ $key }}">{{ $module }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Token</label>
                            <textarea class="form-control" name="token" rows="3"></textarea>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">NameServer1</label>
                            <input type="text" class="form-control" name="nameserver1">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">NameServer2</label>
                            <input type="text" class="form-control" name="nameserver2">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">NameServer3</label>
                            <input type="text" class="form-control" name="nameserver3">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">NameServer4</label>
                            <input type="text" class="form-control" name="nameserver4">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Durum</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Paylaşımlı sunucunun aktif olup olmayacağını belirler</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="status" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="status" value="1">
                            </div>
                        </div>
                        <div class="col-6 mb-9">
                            <button class="btn btn-success d-block m-auto checkServerConnection">Bağlantı Testi</button>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editServer">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editServer").on("click",function(){
        if(!wait){
            $(".editServer").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.settings.server.add.post') }}",
                type: "post",
                async: true,
                data: $("#serverForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".editServer").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000)
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".checkServerConnection").on("click",function(){
        if(!wait){
            $(".checkServerConnection").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.settings.server.check.post') }}",
                type: "post",
                async: true,
                data: $("#serverForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".checkServerConnection").html("Bağlantı Testi");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection