@foreach($configs as $key => $config)
    @if($config['type'] == 'select')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <select class="form-control form-control-select" name="{{ $key }}">
            @foreach($config['values'] as $altkey => $value)
            <option value="{{ $altkey }}"{{ $updata[$key] == $altkey ? ' selected':'' }}>{{ $value }}</option>
            @endforeach
        </select>
    </div>
    @elseif($config['type'] == 'multpileselect')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <select class="form-control form-control-select" name="{{ $key }}[]" multiple>
            @foreach($config['values'] as $altkey => $value)
            <option value="{{ $altkey }}"{{ $updata[$key] == $altkey ? ' selected':'' }}>{{ $value }}</option>
            @endforeach
        </select>
    </div>
    @elseif($config['type'] == 'string')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <input type="text" class="form-control" name="{{ $key }}" value="{{ $updata[$key] }}">
    </div>
    @elseif($config['type'] == 'integer')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <input type="number" class="form-control" name="{{ $key }}" value="{{ $updata[$key] }}">
    </div>
    @elseif($config['type'] == 'float')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <input type="string" class="form-control" name="{{ $key }}" value="{{ $updata[$key] }}">
    </div>
    @elseif($config['type'] == 'date')
    <div class="col-6 mb-9">
        <label class="fs-6 fw-semibold mb-2">{{ $config['name'] }}</label>
        <input type="datetime-local" class="form-control" name="{{ $key }}" value="{{ date('Y-m-d-\T-H:i',$updata[$key]) }}">
    </div>
    @endif
@endforeach