@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Menü Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="menuForm">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Tip</label>
                            <select class="form-control form-control-select" name="type">
                                @foreach($menutypes as $key => $menutype)
                                <option value="{{ $key }}">{{ $menutype }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="fs-6 fw-semibold mb-2">Konum</label>
                            <select class="form-control form-control-select" name="position">
                                @foreach($menupositions as $key => $menuposition)
                                <option value="{{ $key }}">{{ $menuposition }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}"{{ $systemlid == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Alt Adı</label>
                            <input type="text" class="form-control" name="altname">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Sıralaması</label>
                            <input type="text" class="form-control" name="queque">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Açıklama</label>
                            <textarea class="form-control" name="description" rows="3"></textarea>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Icon Yada URL</label>
                            <input type="text" class="form-control" name="icon">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Rota Yada URL</label>
                            <input type="text" class="form-control" name="route">
                        </div>
                        @php $madversiment = json_decode($menu['madversiment'],true) @endphp
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kampanya Başlığı</label>
                            <input type="text" class="form-control" name="adversiment[name]">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kampanya Arka Planı</label>
                            <input type="text" class="form-control" name="adversiment[background]" placeholder="betag-red betag-blinker">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Durum</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Menünün aktif olup olmayacağını belirler</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="status" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="status" value="1">
                            </div>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ana Kategori</label>
                            <select class="form-control form-control-select" name="mainmenu">
                                @foreach($uppermenus as $uppermenu)
                                    <option value="{{ $uppermenu['mid'] }}"{{ $uppermenu['mid'] == $menu['pid'] ? ' selected':'' }}>{{ $uppermenu['mname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editMenu">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editMenu").on("click",function(){
        if(!wait){
            $(".editMenu").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.menu.add.post') }}",
                type: "post",
                async: true,
                data: $("#menuForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".editMenu").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000)
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection