@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Para Birimi Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="currencyForm">
                    <input type="hidden" name="cid" value="{{ $currency['cid'] }}">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Birim Adı</label>
                            <input type="text" class="form-control" name="cname" value="{{ $currency['cname'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Birim Kodu</label>
                            <input type="text" class="form-control" name="ccode" value="{{ $currency['ccode'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Birim İkonu</label>
                            <input type="text" class="form-control" name="cicon" value="{{ $currency['cicon'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Temel Çevirim Oranı</label>
                            <input type="text" class="form-control" name="crate" value="{{ $currency['crate'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Birim Vergi Oranı</label>
                            <input type="text" class="form-control" name="ctaxrate" value="{{ $currency['ctaxrate'] }}">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editCurrency">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editCurrency").on("click",function(){
        if(!wait){
            $(".editCurrency").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.currency.edit.post') }}",
                type: "post",
                async: true,
                data: $("#currencyForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".editCurrency").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection