@extend('laylout')
@section('title')
Sepet
@endsection
@section('headerinclude')
<link type="text/css" rel="stylesheet" href="assets/premium/css/products.css?ver=1849"></link>
<link type="text/css" rel="stylesheet" href="assets/premium/css/portlerts.css?ver=1849"></link>
<style>
    .cart-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
        border-radius: 5px;
        background: #fff;
        box-shadow: 0 .125rem .25rem rgba(0,0,0,.075);				
    }
    .cart-item:not(:last-child) {
        margin-bottom: 20px;
    }
    .cart-item .item-info {
        display: flex;
    }
    .item-info .item-image a {
        display: flex;
        padding: 10px;
        border: 1px solid #e5e5e5;
        border-radius: 5px;			
    }
    .item-info .item-content {
        margin-left: 15px;
    } 
    .item-content .item-name {
        text-decoration: none;
        color: #4b555a;
        font-size: 18px;
    }
    .item-content .item-details {
        display: flex;
        align-items: center;
        color: #646464;				
    }
    .item-content .item-details span {
        font-size: 14px;
        color: #646464;
    }
    .item-content .item-details .options {
        color: var(--bs-orange);
    }
    .item-content .item-details i {
        font-size: 8px;
        margin: 0 8px;
        opacity: .2;				
    }
    .item-content .item-price {
        margin: 10px 0px;
    }
    .item-price .total {
        color: #4b555a;
        font-size: 18px;				
    }
    .item-price .currency {
        font-size: 13px;
        margin-left: 3px;				
    }
    .cart-item .item-buttons a {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-decoration: none;				
    }
    .cart-item .item-buttons a i {
        opacity: .8;
        font-size: 23px;
    }
    .cart-item .item-buttons a span {
        color: #4b555a;
        font-size: 13px;
    }
    .cart-empty {
        padding: 40px;
        display: flex;
        justify-content: center;
    }
    .cart-empty-area {
        width: 500px;
        display: flex;
        align-items: center;
        flex-direction: column;
    }
    .cart-empty-area i {
        color: #f5a503;
        font-size: 45px;
    }
    .cart-empty-area .empty-cart{
        color: #3a3a3a;
        font-weight: bold;
        font-size: 25px;
        margin: 10px;
    }
    .cart-empty-area .empty-cart-info{
        text-align: center;
        color: #3a3a3a;
    }
    .table-summary {
        height: fit-content;
        padding: 15px;
        border-radius: 5px;
        background: #19527e;
    }
    .table-summary ul {
        list-style: none;
    }
    .table-summary ul li i {
        margin-right: 5px;
        color: #fff;
    }
    .table-summary .separator {
        height: 1px;
        margin: 15px 0;
        background-color: #fff;
        opacity: .5;
    }
    .table-summary .coupon {
        display: flex;
        flex-direction:column;
        justify-content:center;
        text-align:center;
        margin-bottom: 10px;
    }
    .table-summary .coupon input {
        padding: 5px;
        border: none;
        border-radius: 5px;
    }
    .table-data {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .table-summary span {
        color: #fff;
    }
    .table-summary .buttons {
        display: flex;
        justify-content: center;
    }
    .cart-info {
        padding: 20px;
        border-radius: 5px;
        background: #fff;
        box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);
    }
    .cart-info .info-row {
        display: flex;	
    }
    .info-row .info-name {
        width: 150px;
        display: block;
        color: #4b555a;		
    }
    .info-row .info-value {
        color: #4b555a;		
    }
    .info-row .agreement {
        display: flex;
        align-items: center;
        color: #4b555a;		
    }
    @media screen and (max-width:543px) { 
        .cart-item {
            flex-direction: column;
        }	
        .item-image {
            margin-bottom: 10px;
        }
        .item-info {
            flex-direction: column;
            align-items: center;
        }
        .item-price {
            text-align: center;
        }
        .item-content .item-details {
            flex-direction: column;
        }
    }
</style>
@endsection
@section('content')
@if(!$cart)
<div class="container my-3">
	<div class="col-md-12 mx-3">
		<div class="cart-empty">
			<div class="cart-empty-area">
				<i class="ri-shopping-cart-line"></i>
				<span class="empty-cart">Sepetiniz Boş</span>
				<span class="empty-cart-info">Sepetini WebAilesi’nin fırsatlarla dolu dünyasından doldurmak için
				aşağıdaki ürünleri incelemeye başlayabilirsin.</span>        
			</div>
		</div>
	</div>
</div>
@else
<div class="container" id="productBack">
</div>
<div class="container my-3" id="productContent" style="margin-bottom:350px!important;">
	<div class="scontent">
		<div class="scontent-9" id="productRows">
		</div>
		<div class="scontent-3">
			<div class="table-summary" id="infoTable">
				<ul>
					<li><i class="ri-shopping-cart-2-line"></i><span>Sipariş Özeti</span></li>
					<li class="separator"></li>
					<li>
						<div class="table-data">
							<span>Ara Toplam</span>
							<span id="productPrice"></span>
						</div>
					</li>
					<li id="discountArea" style="display:none">
						<div class="table-data">
							<span>İndirim</span>
							<span id="discountPrice"></span>
						</div>
					</li>
					<li>
						<div class="table-data">
							<span>KDV(%<span id="fee"></span>)</span>
							<span id="ratePrice"></span>
						</div>
					</li>
					<li class="separator"></li>
					<li class="coupon d-none" id="couponArea">
						<span class="mb-2">Kupon Kullan</span>
						<input id="coupon" class="form-input" type="select" name="coupon" placeholder="Kupon kodu giriniz">
					</li>
					<li>
						<input type="checkbox" id="usecoupon">
						<label for="usecoupon"><span>Kupon Kullanmak İstiyorum</span></label>
					</li>
					<li class="separator"></li>
					<li class="mb-2">
						<div class="table-data">
							<span>Toplam</span>
							<span id="totalPrice"></span>
						</div>
					</li>
					<li class="buttons">
						<a href="#" class="btn btn-transparent cartAgreement">Alışverişi Tamamla</a>
					</li>
				</ul>				
			</div>
			<div clasS="table-summary" id="infoLoading" style="display:flex;justify-content:center;align-items:center">
				<img src="assets/premium/img/loadingnew.gif" style="width:100px;height:100px">
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function(){
		calculateCart();
	});
	var timer = 0;
	$("#usecoupon").change(function() {
		if(this.checked) {
			$("#couponArea").removeClass("d-none");
		}
		else{
			$("#couponArea").addClass("d-none");
		}
	});
	var coupon = "";
	$("#coupon").keyup(function(){
		var text = $(this).val();
		var length = text.length;
		if(length > 2){
			clearInterval(timer);
			timer = setTimeout(function(){
				var lasttext = $("#coupon").val();
				if(lasttext.length == length){
					$.ajax({
						url: "{{ beGetRoute('cart.checkcoupon.post') }}",
						type: "post",
						data: {coupon:lasttext},
						dataType: "json",
						crossDomain: true,
						success: function(response){
							if(response.status){
								coupon = lasttext;
								calculateCart();		
							}
							else{
								toast("Bir Hata Oluştu",response.message,"error");								
							}
						}
					});	
				}
				clearTimeout(timer);
			},500);
		}
	});
	$("#productRows").on("click",".removeProduct",function(){
		var upid = $(this).data("upid");
		$.ajax({
			url: "{{ beGetRoute('cart.remove.post') }}",
			type: "post",
			data: {upid:upid},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					if(response.isempty){
						location.reload();
					}
					else{
						$("#productBack").empty().append(response.oldproduct);
						calculateCart();
					}
					toast("Başarılı",response.message,"success");
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});			
		return false;
	});
	$("#productBack").on("click",".cartAddRetry",function(){
		$.ajax({
			url: "{{ beGetRoute('cart.addretry.post') }}",
			type: "post",
			data: {},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					$("#productBack").empty();
					toast("Başarılı",response.message,"success");
					calculateCart();
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});	
		return false;
	});
	$(".cartAgreement").on("click",function(){
		$.ajax({
			url: "{{ beGetRoute('cart.agree.post') }}",
			type: "post",
			data: {action:"cart_agreement",coupon:coupon},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					setTimeout(function(){
						window.location.href = response.url;
					},1000);
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");					
				}
			}
		});	
		return false;
	});
	function calculateCart(){
		$("#infoTable").hide();
        $("#infoLoading").css("display","flex");
		$.ajax({
			url: "{{ beGetRoute('cart.get.post') }}",
			type: "post",
			data: {coupon:coupon},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					$("#productRows").empty().append(response.html);
					$("#productPrice").html(response.productsprice+response.icon);
					if(parseInt(response.productsdiscount) > 0){
						$("#discountArea").show();
						$("#discountPrice").html("-"+response.productsdiscount+response.icon);
					}
					$("#ratePrice").html(response.productsrate+response.icon);
					$("#totalPrice").html(response.totalprice+response.icon);
					$("#fee").html(response.fee);
					$("#infoTable").show();
                	$("#infoLoading").hide();
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});
	}
</script>
@endif
@endsection