@extend('client.laylout')
@section('content')
<style>
.payment-options {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    border: 1px solid rgb(230 230 230);
    background: white;
    cursor: pointer;
    border-radius: 6px;
    margin-bottom: 15px;
}
.payment-options.active {
    border: 1px solid rgb(43 215 104)!important;
}
.payment-options .info {
    display: flex;
    margin-right: 20px;
}
.payment-options .info .logo {
    margin-right: 20px;
    padding-right: 20px;
    border-right: 1px solid rgb(230 230 230);
}
.payment-options .info .text span:first-child {
    font-weight: 600;
    margin-bottom: 6px;
    font-size: 16px;
}
.payment-options .info .text span:last-child {
    opacity: 0.5;
    font-size: 12px;
}
.payment-options .info .text span {
    display: block;
}
.payment-options .info img {
    width: 85px;
    height: 50px;
}
.payment-options .price {
    width: 8%;
    font-weight: 500;
    font-size: 18px;
}
.packets {
    background: rgba(102,112,147,.07);
    border-radius: 8px;
    display: inline-flex;
    padding: 7px 15px;
    width: 310px;
    margin: 15px 0;
    justify-content: space-between;
}
.packets > a {
    display: flex;
    padding: 4px;
    align-items: center;
    transition: .3s;
    width: 47%;
    font-size: 14px;
    color: #667093;
    background: #e3e3e3;
    border-radius: 8px;
    justify-content: center;
    padding: 10px;
}
.packets i {
    font-size: 18px;
    margin-right: 10px;
}
.packets > a.active {
    background: #fff;
    font-weight: 700;
    color: black;
}
.form-group:not(:first-child) {
    margin: 20px 0px;
}
.form-group label {
    color: #6c757d;
}
.input-select {
    display: flex;
    justify-content: space-between;
}
.input-select input {
    width: 70%!important;
}
.input-select select {
    width: 20%!important;
}
.sinfo-description {
    padding: 15px 20px;
    border-radius: 5px;
    background: var(--header-right);
    color: #fff;
    box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);
}
</style>
<div class="scontent-12">
    <div class="sportlet">
        <div class="sportlet-header-special">
            <h3>
                Son Bir Adım Kaldı
            </h3>
        </div>
        <div class="smain">
            <div class="row">
                <div class="col-md-12">
                    <div class="d-flex justify-content-center">
                        <div class="packets">
                            <a rel="nofollow noreferrer" title="Türkiye" alt="Türkiye" href="#" class="packets-item active" data-tab="individual">
                                <i class="ri-add-line"></i>
                                <span>Bireysel</span>
                            </a>
                            <a rel="nofollow noreferrer" title="Almanya" alt="Almanya" href="#" class="packets-item" data-tab="institutional">
                                <i class="ri-building-fill"></i>
                                <span>Kurumsal</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <form id="individualForm" method="post">
                <div class="row tab mb-3" id="individual" style="display: flex;">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="pb-1">Adınız</label>
                            <input name="name" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="pb-1">Soyadınız</label>
                            <input name="surname" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">TC Kimlik Numaranız</label>
                            <input name="tcno" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Doğum Tarihiniz</label>
                            <input name="birthdate" type="date" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Ülke</label>
                            <select class="form-control" name="country">
                                @foreach($countries as $country)
                                <option value="{{ $country['acid'] }}"{{ $country['acid'] == $defcountry ? ' selected':'' }}>{{ $country['acname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">İl</label>
                            <select class="form-control" name="district" id="individualDistricte">
                                <option value="0">Seçiniz</option>
                                @foreach($districs as $distric)
                                <option value="{{ $distric['adid'] }}">{{ $distric['adname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">İlçe</label>
                            <select class="form-control" name="province" id="individualProvince">

                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Adresiniz</label>
                            <textarea type="text" class="form-control" name="address"></textarea>
                        </div>
                    </div>
                </div>
            </form>
            <form id="institutionalForm" method="post">
                <div class="row tab mb-3" id="institutional" style="display: none;">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="pb-1">Firma Ünvanı</label>
                            <input name="name" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Vergi Numarası</label>
                            <input name="taxno" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Vergi Dairesi</label>
                            <input name="taxadmin" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Ülke</label>
                            <select class="form-control" name="country">
                                @foreach($countries as $country)
                                <option value="{{ $country['acid'] }}"{{ $country['acid'] == $defcountry ? ' selected':'' }}>{{ $country['acname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">İl</label>
                            <select class="form-control" name="district" id="institutionalDistrict">
                                <option value="0">Seçiniz</option>
                                @foreach($districs as $distric)
                                <option value="{{ $distric['adid'] }}">{{ $distric['adname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 mt-3">
                        <div class="form-group">
                            <label class="pb-1">İlçe</label>
                            <select class="form-control" name="province" id="institutionalProvince">
    
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Adresiniz</label>
                            <textarea type="text" class="form-control" name="address"></textarea>
                        </div>
                    </div>
                </div>
            </form>
            <div class="row mt-3 d-flex justify-content-center">
                <div style="width:auto">
                    <a href="#" class="btn btn-special btn-icon saveUserIdentity">Kaydet</a>
                </div>
            </div>
        </div>
    </div>
    <div class="sinfo-description mt-3">
        <span>
            Bu bilgiler sizden isteme sebebimiz yasal nedenler ve fatura için kullanılmaktadır.
        </span>
    </div>
</div>
<script>
    var type = "individual";
    $(".packets-item").on("click",function(){
        var tab = $(this).data("tab");
        $(".row.tab").hide();
        $(".packets-item.active").removeClass("active");
        $(this).addClass("active");
        $("#"+tab).css("display","flex");
        type = tab;
        return false;
    });
    $("select[name='country']").on("change",function(){
        var country = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('usertype.get.district.post') }}",
            type: "post",
            data: {country:country},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var html = "";
                    $.each(response.districs, function( index, value ) {
                        html += '<option value="'+value.acid+'">'+value.acname+'</option>';
                    });
                    $("#"+type+"District").empty().append(html);
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
    $("select[name='district']").on("change",function(){
        var district = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('usertype.get.province.post') }}",
            type: "post",
            data: {district:district},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var html = "";
                    $.each(response.provinces, function( index, value ) {
                        html += '<option value="'+value.apid+'">'+value.apname+'</option>';
                    });
                    $("#"+type+"Province").empty().append(html);
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
    var wait = false;
    $(".saveUserIdentity").on("click",function(){
        if(!wait){
            wait = true;
            $(".saveUserIdentity").html('<i class="spinner ri-refresh-line"></i> Lütfen Bekleyin!');
            $.ajax({
                url: "{{ beGetRoute('usertype.insert.post') }}",
                type: "post",
                data: $("#"+type+"Form").serialize()+"&usertype="+type,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".saveUserIdentity").html('Kaydet');
                    if(response.status){
                        toast("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000);
                    }
                    else{
                        toast("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin!","error");
        }
        return false;
    });
</script>
@endsection