@extend('panel.virtualserver.laylout')
@section('headerinclude')
<style>
	.bank-accounts {
		list-style: none;
	}
	.bank-accounts li {
		display: flex;
		align-items: center;
		padding: 30px;
		border-radius: 3px;
		box-shadow: 0 0.5rem 1rem rgb(0 0 0 / 15%);
		background: #fff;		
	}
	.bank-accounts li:not(:last-child) {
		margin-bottom: 15px;
	}
	.bank-image {
		margin-right: 30px;
	}
	.bank-key {
		width: 90px;
		display: inline-block;
		color: #4b555a;
	}
	.bank-val {
		color: #4b555a;
	}
	.bank-val:before {
		content: ":";
		margin-right: 20px;
	}
	@media screen and (max-width:543px) {  
		.bank-accounts li {
			flex-direction: column;
		}
		.bank-image {
			margin: 10px 0px;
		}
	}
</style>
@endsection
@section('content')
<div class="sportlet">
    <div class="sportlet-header-special">
        <h3>
            Sanal Sunucu Kurulumu
        </h3>
    </div>
    <div class="smain">
        <form id="addClientForm">
            <div class="row">
                <div class="col">
                    <input name="domain" placeholder="Sunucunuzun alan adınızı giriniz" required="required" type="text" value="" class="form-control">
                </div>
            </div>
            <div class="row my-3">
                <div class="col">
                    <input name="ipaddress" placeholder="Sunucunuzun ip adresini giriniz" required="required" type="text" value="" class="form-control">
                </div>
            </div>
            <div class="row text-center">
                <div class="col">
                    <a href="#" class="btn btn-special createUser">Oluştur</a>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
	$(".createUser").on("click",function(){
		$.ajax({
			url: "{{ beGetRoute('panel.virtual.addclient.post') }}",
			type: "post",
			data: $("#addClientForm").serialize(),
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.status){
					toast("Başarılı",response.message,"success");
					if(response.url){
						setTimeout(function(){
							window.location.href = response.url;
						},1000);						
					}
				}
				else{
					toast("Bir Hata Oluştu",response.message,"error");
				}
			}
		});						
		return false;
	});
</script>
@endsection