@extend('panel.virtualserver.laylout')
@section('content')
<div id="infoContent">
</div>
<div class="sportlet">
	<div class="sportlet-header">
		<span>Lisans Bilgisi</span>
	</div>
	<div class="stable">
		<table class="table">
			<thead>
				<tr>
					<th>Lisanslı Domain</th>
					<th>Lisanslı IP Adresi</th>
					<th>Lisans Kodu</th>
				</tr>
			</thead>
			<tbody>
				<tr class="copy">
					<td><span><a href="https://{{ $updata['domain'] }}" target="_blank">{{ $updata['domain'] }}</a></span></td>
					<td><span>{{ $updata['ipaddress'] }}</span></td>
					<td><b><span>{{ $updata['said'].':'.$updata['sacode'] }}</span></b></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<div class="my-3">
   <ul class="nav nav-tabs" id="myTab" role="tablist">
      <li class="nav-item" role="presentation">
         <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false"><i class="ri-price-tag-3-fill"></i>Kurulum Dosyaları</button>
      </li>
	  <li class="nav-item" role="presentation">
         <button class="nav-link" id="templates-tab" data-bs-toggle="tab" data-bs-target="#templates" type="button" role="tab" aria-controls="templates" aria-selected="false"><i class="ri-price-tag-3-fill"></i>İşletim Sistemleri</button>
      </li>
	  <li class="nav-item" role="presentation">
         <button class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true"><i class="ri-question-fill"></i><span class="desktop">Sıkça Sorulan Sorular</span><span class="mobile">S.S.S.</span></button>
      </li>
   </ul>
   <div class="tab-content" id="myTabContent">
      <div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="home-tab">
         <div class="accordion" id="accordionExample">
            <div class="accordion-item">
               <h5 class="accordion-header" id="head0">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="false" aria-controls="collapse0">
                  VDS Sanal sunucu nedir?
                  </button>
               </h5>
               <div id="collapse0" class="accordion-collapse collapse" aria-labelledby="head0" data-bs-parent="#accordionExample" style="">
                  <div class="accordion-body">
                     VDS, Virtual Dedicated Server kelimelerinin kısaltılmış halidir. Sanal Adanmış Sunucu olarak Türkçe haline gelmiştir. VDS sanal sunucu, fiziki olarak yer alan birçok sunucunun bölünerek tüm kaynakların en düzgün şekilde çalışmasını ve kullanılmasını sağlayan bir yapı olarak tanımlanabilir. VPS’lerin her biri birbirinden bağımsız çalışır. VPS sanal sunucu; disk alanı, IP adresi ve hafıza gibi argümanların hepsi için sadece kendine ait dosyalama şekli vardır.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
                  VDS Sanal sunucu ne işe yarar?
                  </button>
               </h5>
               <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="head1" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     VDS sanal sunucu, işletim sistemlerinin maksimum performansla çalışmasını sağlar. Sistemlerin performansının korunaklı olmasını daha iyi yapmaktadır. Donanımsal olarak sanılan pek çok argümanın sanal ortamda saklanmasına yardımcı olur. Geleneksel yöntemler yerine sanal alanda depolama ve bulundurma imkanı sunar. VDS sana sunucu, IP adres, hafıza, birtakım uygulama ile konfigürasyon gibi öğelerin tutulmasına da yarar.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head2">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
                  Neden VDS Sanal Sunucuyu Seçmeliyim?
                  </button>
               </h5>
               <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="head2" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     VDS seçmenin altında birçok neden olabilmektedir. Yaptığınız iş ile ilgili sana sunucu tercihinde bulunabilirsiniz. Küçük ya da orta ölçekli bir firmaya sahip iseniz, VDS sizin kullanımınıza uygun olacaktır. Script (web yazılımı), kontrol paneli ve web sitenin saklama gibi işlemlerde de VDS sunucu seçilebilmektedir. VDS sunucu üzerinden yapmak istediğiniz hemen hemen her işlemi yapabilirsiniz. Kısıtlamanın olmaması sizlere daha özgür bir kullanım imkanı sunmaktadır.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head3">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                  Linux Sanal Sunucu desteğiniz bulunmakta mıdır?
                  </button>
               </h5>
               <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="head3" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Linux Sanal Sunucu desteğimiz elbette bulunmaktadır. Size sunulan Linux paketlerinden istediğinizi seçebilirsiniz. Başlangıç olarak başlayan paketler ihtiyaca göre farklı paketlerde seçilebilmektedir. Linux sanal sunucular ihtiyacın birçoğunu karşılar. Yapılan işin niteliği ve niceliğine göre sanal sunucular tercih edilmelidir. Ayrıca Linux Sanal Sunucu seçtiğinizde ek destek de alabilirsiniz. Aklınızdaki soru ve sorunları ekibimizle paylaşarak çözüme kavuşturabilirsiniz.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head4">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
                  Windows Sanal Sunucu desteğiniz bulunmakta mıdır?
                  </button>
               </h5>
               <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="head4" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Sanal sunucu almak isteyenler sitemizi tercih edebilir. Windows Sanal Sunucu için verdiğimiz destek sayesinde de sürekli hizmet alabilirsiniz. Bu sayede sorunsuz bir alışveriş gerçekleştirebilirsiniz. Windows, Linux sanal sunucu ile hemen aynı işlevi görmektedir. Bir web sitesi üzerinde aynı görevleri yapmaktadır. Ancak .PHP ya da farklı kodlamalarda ayrışmaktadır. Windows Sanal Sunucu, 3 farklı paket de hizmet vermektedir.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head5">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
                  İstediğim işletim sistemini aktif edebilir miyim?
                  </button>
               </h5>
               <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="head5" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     İşletim sistemi için hangisini seçerseniz seçin hemen aktif edebilirsiniz. Özgür bir şekilde işletim sistemi satın alabilirsiniz. Ancak yeteri kadar fikriniz yoksa profesyonel destek ekibinden yardım almanızı tavsiye ederim. Paket tercihinde bulunduktan sonra sistemi aktif etmek oldukça kolay. Ayrıca aktif etme işlemlerinde problem yaşarsanız destek ekibinden yardım alabilirsiniz. Windows ve linux sunucularında uygun paketlerle işletim sistemini istediğiniz şekilde faal hale getirebilirsiniz.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head6">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
                  Kiralanan Sunucu ne kadar sürede hazır olur?
                  </button>
               </h5>
               <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="head6" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Sunucu siparişiniz bizlere ulaştıktan sonra, sunucunuz bir kaç dakika içersinde otomatik olarak teslim edilmektedir. Teslimar sürecini kontrol etmek için müşteri paneli üzerindeki ürünlerim sayfasını takip etmeniz gerekmektedir.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head7">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse7" aria-expanded="false" aria-controls="collapse7">
                  DDos Koruması Nedir?
                  </button>
               </h5>
               <div id="collapse7" class="accordion-collapse collapse" aria-labelledby="head7" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     DDos koruması, size zarar vermeye çalışan kişiler tarafından gerçekleştirilen sahte trafik anlamına gelmektedir. Yoğun boyutta zararlı trafiğı sunucunuza yönlendirilmesi sonucu sanal sunucu hizmetinizi zorlayarak size zarar vermeyi hedefleyen bir saldırı tipidir. Webailesi tüm hizmetlerinde yüksek boyutlarda ddos koruması sağlamaktadır. Saldırganlar webailesi güvenlik duvarı üzerinden geçerek asla size zarar veremeyecektir.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head8">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse8" aria-expanded="false" aria-controls="collapse8">
                  VDS ile ne yapılır?
                  </button>
               </h5>
               <div id="collapse8" class="accordion-collapse collapse" aria-labelledby="head8" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Virtual Dedicated Server ile bir çok projenizi hayata geçirebilirsiniz. Örneğin internet sitenizi yüksek performansla barındırabilir, oyun sunucusu olarak kullanabilir, özel dosyalarınızı yedeklemek amacıyla kullanabilir, ses sunucuları gibi bir çok sektörde dilediğiniz şekilde kullanabilirsiniz.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head9">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse9" aria-expanded="false" aria-controls="collapse9">
                  VDS hosting nedir?
                  </button>
               </h5>
               <div id="collapse9" class="accordion-collapse collapse" aria-labelledby="head9" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Virtual Dedicated Server(VDS) hosting ile yüksek performanslı olarak internet sitelerinizi veyatta tek bir internet sitesini kolayca yönetebilirsiniz. Webailesi sanal sunucu kontrol paneli üzerinden tek tıkla web kontrol paneli kurabilir ve anında internet sitenizi paylaşımsız olarak barındırmaya başlayabilirsiniz.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head10">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse10" aria-expanded="false" aria-controls="collapse10">
                  VDS açılımı nedir?
                  </button>
               </h5>
               <div id="collapse10" class="accordion-collapse collapse" aria-labelledby="head10" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Vds açılım olarak 'Virtual Dedicated Server' cümlesinin baş harflerinden oluşmaktadır.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head11">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse11" aria-expanded="false" aria-controls="collapse11">
                  VDS ile VPS arasındaki fark nedir?
                  </button>
               </h5>
               <div id="collapse11" class="accordion-collapse collapse" aria-labelledby="head11" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     VDS(Virtual Dedicated Server) ile VPS(Virtual Private Server) arasındaki tek ve en önemli fark VDS paylaşımsız olarak kullanılabilmektedir ancak VPS bir çok kişinin aynı donanımı aynı anda kullanmasına yaramaktadır. Kısaca özetlemek gerekirse VDS paylaşımsız VPS ise paylaşımlı bir hizmettir.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head12">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse12" aria-expanded="false" aria-controls="collapse12">
                  VDS nasıl girilir?
                  </button>
               </h5>
               <div id="collapse12" class="accordion-collapse collapse" aria-labelledby="head12" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Webailesi üzerinden satın aldığınız VDS(Virtual Dedicated Server) sunucusuna giriş yapabilmek için ilk olarak webailesi sanal sunucu kontrol paneli üzerindeki 'Sunucu Bilgilerim' kısmından IP adresinizi, SSH portunuzu ve SSH şifrenizi tedarik etmeniz gerekmektedir. Tedarik ettiğiniz bilgiler ile putty, bitvise veyatta benzer programlar aracılığı sayesinde satın aldığınız sanal sunucunuza giriş sağlayabilirsiniz.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head13">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse13" aria-expanded="false" aria-controls="collapse13">
                  VDS bileşenleri nelerdir?
                  </button>
               </h5>
               <div id="collapse13" class="accordion-collapse collapse" aria-labelledby="head13" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Sanal sunucu paketlerinde dünya çapında şu donanımlar kullanılmaktadır. İşlemci, Ram, Disk, Ana Kart, Power Supply, Soğutma Aparatları ve network yönetim araçlarıdır.
                  </div>
               </div>
            </div>
            <div class="accordion-item">
               <h5 class="accordion-header" id="head14">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse14" aria-expanded="false" aria-controls="collapse14">
                  Sanal Sunucu nedir? Nasıl kurulur?
                  </button>
               </h5>
               <div id="collapse14" class="accordion-collapse collapse" aria-labelledby="head14" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                     Webailesi sanal sunucu hizmetlerinden satın almanız durumunda satın aldığınız sunucu sizin belirlediğiniz işletim sisteminde otomatik olarak bir kaç dakika içersinde kurulup size teslim edilmektedir. Kurulum sonrasında dünya çapında tek olan webailesi sanal sunucu kontrol paneli ile ürününüz ile ilgili her şeyi tek tıkla yönetebilirsiniz.
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="tab-pane fade active show" id="profile" role="tabpanel" aria-labelledby="profile-tab">
         <div class="d-flex justify-content-center">
            <div class="col-md-12">
				<div class="sportlet">
					<div class="stable">
						<table class="table">
							<tbody>
								<tr>
									<td>WHMCS Modülü</td>
									<td>v1.1</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVM_Whmcsv1.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
								<tr>
									<td>WiseCP Modülü</td>
									<td>v1.1</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVM_WiseCPv1.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
								<tr>
									<td>DiyoVM Sistemi</td>
									<td>v2.11</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVMv20.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
							</tbody>
						</table>		
					</div>
				</div>
            </div>
         </div>
      </div>
	  <div class="tab-pane fade" id="templates" role="tabpanel" aria-labelledby="templates-tab">
         <div class="d-flex justify-content-center">
            <div class="col-md-12">
				<div class="sportlet">
					<div class="stable">
						<table class="table">
							<tbody>
								<tr>
									<td>WHMCS Modülü</td>
									<td>v1.1</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVM_Whmcsv1.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
								<tr>
									<td>WiseCP Modülü</td>
									<td>v1.1</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVM_WiseCPv1.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
								<tr>
									<td>DiyoVM Sistemi</td>
									<td>v2.11</td>
									<td>
										<a href="https://repo.teamdiyo.com/diyovm/DiyoVMv20.1.zip" class="btn btn-special btn-sm">İndir</a>
									</td>
								</tr>
							</tbody>
						</table>		
					</div>
				</div>
            </div>
         </div>
      </div>
   </div>
</div>
<script>
   $(document).ready(function(){
   	$.ajax({
   		url: "{{ beGetRoute('panel.virtual.getclient.post') }}",
   		type: "post",
   		dataType: "json",
   		crossDomain: true,
   		success: function(response){
   			request_status = false;
   			if(response.status){
   				$("#infoContent").append(response.html);
   			}
   			else{
   				toast("Bir Hata Oluştu",response.message,"error");
   			}
   		}
   	});	
   });
</script>
@endsection