<div class="card">
    <div class="card-header">
        <div class="card-title">
            DiyoVM Ürünleri
        </div>
    </div>
    <div class="card-body">
        <form id="machineForm">
            <div class="row">
                <div class="col-12 mb-9">
                    <label class="fs-6 fw-semibold mb-2">DiyoVM Ürünleri</label>
                    <select class="form-control form-control-select" id="scripts" multiple>
                        @foreach($products as $key => $product)
                        <option value="{{ $key }}"{{ in_array($key,$updata['applications']) ? ' selected':'' }}>{{ $product['name'] }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12">
                    <button class="btn btn-success d-block m-auto diyovmDownSaveForm">Kaydet</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    var wait_diyovm2 = false;
    $(".diyovmDownSaveForm").on("click",function(){
        if(!wait_diyovm2){
            wait_diyovm2 = true;
            $(".diyovmDownSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            var status = $(this).data("status");
            $.ajax({
                url: "{{ beGetRoute('admin.order.automation.module.post') }}",
                type: "post",
                async: true,
                data: {
                    upid:{{ $userproduct['upid'] }},
                    function:"change_applications",
                    module_vars:{
                        scripts: $("#scripts").val()
                    }
                },
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait_diyovm2 = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>