<style>
	.form-group:not(:first-child) {
		margin: 20px 0px;
	}
	.form-group label {
		color: #6c757d;
	}
	.input-select {
		display: flex;
		justify-content: space-between;
	}
	.input-select input {
		width: 70%!important;
	}
	.input-select select {
		width: 20%!important;
	}
	.sinfo-description {
		padding: 15px 20px;
		border-radius: 5px;
		background: var(--header-right);
		color: #fff;
		box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);		
	}
	.sinfo-description a {
		color: #fff;
		opacity: .8;
		font-size: 16px;
	}
	.sinfo-description a:hover {
		opacity: 1;
	}
    .input-group {
        position: relative;
    }
    .input-group input {
        text-indent: 35px;
        height: calc(3.4rem + 2px);
    }
    .input-group input[type="tel"]{
        width: 100%;
        text-indent: 15px;
    }
    .input-icon {
        width: 40px;
        height: calc(3.4rem + 2px);
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .icon-info {
        right: 0;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
</style>
<div class="sportlet">
	<div class="sportlet-header-special mb-3">
		<h3>
			Kart Bilgileriniz
		</h3>
	</div>
	<div class="smain">
        <form id="cardForm">
            <div class="row">
                <div class="row col-md-6">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="pb-1">Kredi Kartı Numarası</label>
                            <div class="input-group">
                                <div class="input-icon"> 
                                    <i class="ri-bank-card-2-line"></i>
                                </div>
                                <input type="text" class="form-control" value="" id="cardNumer" name="cardNumer">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Kart Sahibinin Adı Soyadı</label>
                            <div class="input-group">
                                <div class="input-icon"> 
                                    <i class="ri-user-line"></i>
                                </div>
                                <input type="text" class="form-control" value="{{ $user['name'].' '.$user['surname'] }}" id="cardUser" name="cardUser">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">Son Kullanım Tarihi</label>
                            <div class="input-group">
                                <div class="input-icon"> 
                                    <i class="ri-calendar-line"></i>
                                </div>
                                <input type="text" class="form-control" value="" placeholder="MM / YY" id="cardValidate" name="cardValidate">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mt-3">
                        <div class="form-group">
                            <label class="pb-1">CVC</label>
                            <div class="input-group">
                                <div class="input-icon"> 
                                    <i class="ri-lock-line"></i>
                                </div>
                                <input type="text" class="form-control" value="" placeholder="CVC" id="cardCvc" name="cardCvc">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row col-md-6">
                    <div class="stable">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Hizmet Adı</th>
                                    <th>Adet</th>
                                    <th>Toplam</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php 
                                $counter = 1;
                                @endphp
                                @foreach($invoice['ibasket'] as $basket)
                                <tr>
                                    <td>{{ $counter }}</td>
                                    <td>{{ $basket[0] }}</td>
                                    <td>{{ $basket[2] }} Adet</td>
                                    <td>+{{ $basket[1] }} {{ $currencies[$basket[4]]['cicon'] }}</td>
                                </tr>
                                @php $counter += 1 @endphp
                                @endforeach
                                @if($invoice['itaxprice'] > 0)
                                <tr>
                                    <td>{{ $counter }}</td>
                                    <td>Katma Değer Vergisi</td>
                                    <td>1 Adet</td>
                                    <td>+{{ beMoneyFormat($invoice['itaxprice']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</td>
                                </tr>
                                @php $counter += 1 @endphp
                                @endif
                                @if($invoice['idiscount'] > 0)
                                <tr>
                                    <td>{{ $counter }}</td>
                                    <td>İndirim</td>
                                    <td>1 Adet</td>
                                    <td>-{{ beMoneyFormat($invoice['idiscount']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>			
                    </div>
                    <div style="display:flex;justify-content:flex-end">
                        <span class="font-weight-bold text-muted text-uppercase text-right mx-3">Toplam</span>
                        <span class="text-primary font-size-h3 font-weight-boldest text-right">{{ beMoneyFormat($invoice['itotal']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</span>
                    </div>
                </div>
            </div>
        </form>
        <div class="row mt-3 text-center">
			<div class="col">
				<a href="#" class="btn btn-special btnPay">Ödemeyi Başlat</a>
			</div>
		</div>
	</div>	
</div>
<div id="dataContent">

</div>
<script>
$("#cardNumer").on("keypress",function(event) {
  if (event.charCode >= 48 && event.charCode <= 57) {
    let length = $(this).val().length;
    if (length === 3 || length === 9 || length === 15) {
      $(this).val($(this).val() + event.key + "  ");
    }
    else if(length < 22){
        return event.charCode;
    }
  }
  return false;
});
$("#cardValidate").on("keypress",function(event) {
  if (event.charCode >= 48 && event.charCode <= 57) {
    if ($(this).val().length === 1) {
      $(this).val($(this).val() + event.key + " / ");
    } else if ($(this).val().length === 0) {
      if (event.key == 1 || event.key == 0) {
        month = event.key;
        return event.charCode;
      } else {
        $(this).val(0 + event.key + "/");
      }
    } else if ($(this).val().length > 4 && $(this).val().length < 7) {
      return event.charCode;
    }
  }
  return false;
}).on("keyup",function(event) {
  if (event.keyCode == 8 && $("#cardValidate").val().length == 2) {
    $(this).val(month);
  }
});
$("#cardCvc").on("keypress",function(event) {
  if (event.charCode >= 48 && event.charCode <= 57) {
    if ($(this).val().length >= 0 && $(this).val().length < 3) {
      month = event.key;
      return event.charCode;
    }
  }
  return false;
});
var wait = false;
$(".btnPay").on("click",function(){
    if(!wait){
        $(".btnPay").html('<i class="spinner ri-refresh-line"></i> Lütfen Bekleyin!');
        wait = true;
        $.ajax({
            url: "{{ beGetRoute('client.invoice.invoice.post') }}",
            type: "post",
            async: true,
            data: $("#cardForm").serialize()+"&iid={{ $invoice['iid'] }}&method=iyzi&onprocess=1",
            dataType: "json",
            crossDomain: true,
            success: function(response){
                $(".btnPay").html("Ödemeyi Başlat");
                if(response.status){
                    $.Toast("Başarılı",response.message,"success");
                    $("#dataContent").append(response.data);
                    setTimeout(function(){
                        $('form[name="returnform"]').submit();
                    },1000);
                }
                else{
                    $.Toast("Bir Hata Oluştu",response.message,"error");
                    wait = false;
                }
            }
        });	
    }
    else{
        $.Toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
    }	
    return false;
});
</script>