@extend('client.laylout')
@section('headerinclude')
<style>
	.form-group:not(:first-child) {
		margin: 20px 0px;
	}
	.form-group label {
		color: #6c757d;
	}
	.input-select {
		display: flex;
		justify-content: space-between;
	}
	.input-select input {
		width: 70%!important;
	}
	.input-select select {
		width: 20%!important;
	}
	.sinfo-description {
		padding: 15px 20px;
		border-radius: 5px;
		background: var(--header-right);
		color: #fff;
		box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);		
	}
	.sinfo-description a {
		color: #fff;
		opacity: .8;
		font-size: 16px;
	}
	.sinfo-description a:hover {
		opacity: 1;
	}
</style>
@endsection
@section('content')
<div class="sportlet">
	<div class="sportlet-header-special mb-3">
		<h3>
			Adres Bilgileriniz
		</h3>
	</div>
	<div class="smain">
		<div class="row">
			<div class="col-md-12">
				<div class="form-group">
					<label class="pb-1">Adres Detayı</label>
					<textarea type="text" class="form-control" id="uiadressInfo">{{ $userinfo['uiaddress'] }}</textarea>
				</div>
			</div>
		</div>
		<div class="row mt-3 text-center">
			<div class="col">
				<a href="#" class="btn btn-special saveAdress">Kaydet</a>
			</div>
		</div>
	</div>	
</div>
<script>
    $(".saveAdress").on("click",function(){
        $.ajax({
            url: "{{ beGetRoute('client.address.post') }}",
            type: "post",
            data: {address:$("#uiadressInfo").val()},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    toast("Başarılı",response.message,"success");
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });		
        return false;
    });
</script>
@endsection