@extend('client.laylout')
@section('content')
<style type="text/css">
	.btn-primary {
		background:#009EF7;
		border-color:#009EF7;
	}
	.btn-primary:hover {
		background: #0692e1;
		border-color: transparent;
	}
	.user-settings-item:first-child {
		border: none;
	}
	.user-settings-item {
		display: flex;
		border-top: 1px dashed rgb(230 230 230);
		padding:20px  15px;
		margin: 0 15px;
		align-items: center;
		justify-content: space-between;
	}
	.user-settings-left {
		display: flex;
		align-items: center;
	}
	.user-settings-content {
		margin: 0 15px;
	}
	.user-settings-content strong {
		display: block;
		margin-bottom: 1px;
		font-size: 16px;
	}
	.user-settings-content span {
		color: rgb(0 0 0 / 60%);
		font-size: 13px;
	}
	.checkbox-switch {
		appearance: none;
		position: relative;
		background: #eff2f5;
		width: 45px;
		border: 1px solid #d3d0d0;
		height: 27px;
		transition: .3s;
		border-radius: 50px;
		cursor: pointer;
	}
	.checkbox-switch:after {
		content: "";
		background: #fff;
		width: 15px;
		height: 15px;
		position: absolute;
		top: 0;
		bottom: 0;
		transition: .3s;
		margin: auto;
		left: 5px;
		border-radius: 100%;
	}
	.user-settings-footer {
		display: flex;
		padding: 15px;
		justify-content: flex-end;
	}
	.checkbox-switch:checked {
		background: var(--header-left);
	}
	.checkbox-switch:checked:after {
		left: 23px;
	}
	.referral-top {
		display:flex;
		flex-wrap:Wrap;
		justify-content:space-between;
	}
	.referral {
		padding:30px;
	}
	.referral-top {
		margin-bottom:30px;
	}
	.referral-top .referral-item {
		width:47%;
		font-size:14px
	}
	.referral-top .referral-item strong {
		font-size:16px;
		margin-bottom:8px;
		display:block;
	}
	.referral-top .referral-item p {
		margin-bottom:15px;
		font-weight:600;
		color:rgb(0 0 0 / 50%);
	}
	.referral-top .referral-item .btn-getstart,.referral-top .referral-input button  {
		background:#F5F8FA;
		color:#7E8299;
		font-size:15px;
		padding:8px 18px;
		font-weight:600;
	}
	.referral-top .referral-input {
		display:flex;
	}
	.referral-top .referral-input input {
		width:60%;
		background:#f5f8fa;
		flex:auto;
		border:none;
		outline:0;
		color:#5E6278;
		padding:10px 14px;
		border-radius:5px;
		font-weight:500;
		margin-right:7px;
	}


	.referral-body {
		display:flex;
		flex-wrap:wrap;
		margin-bottom:15px;
	}
	.referral-body .referral-item {
		width: 14%;
		flex:
		auto;
		font-weight:500;
		border-radius: 5px;
		border:1px dashed #E4E6EF;
		text-align:
		center;
		padding:2rem;
		margin-right: 15px;
	}
	.referral-body .referral-item:last-child {
		margin-right:0;
	}
	.referral-body .referral-item span {
		font-size: 16px;
		display:
		block;
		margin-bottom: 11px;
	}
	.referral-body .referral-item strong {
		font-size: 28px;
	}
	.referral-info {
		color:Rgb(0 0 0 / 60%);
		font-weight:500;
		margin-bottom:30px;
	}
	.referral-alert {
		background:#F1FAFF;
		border:1px dashed #009EF7;
		padding:11px 20px;
		display:flex;
		justify-content:space-between;
		border-radius:0.475rem;
		align-items:center;
	}
	.referral-alert .referral-left {
		display:flex;
		width:40%;
		margin-right:30px;
		flex:auto;
		align-items:center;
	}
	.referral-alert .referral-left .referral-icon svg {
		width:35px;
		color:#009EF7;
		height:auto;
	}
	.referral-alert .referral-left .referral-icon {
		margin-right:15px;
	}
	.referral-alert .referral-left .referral-desc {
		font-size:14px;
		color:rgb(0 0 0 / 80%);
		margin-top:3px;
	}
	.referral-alert .referral-left .referral-title {
		font-weight:600;
	}
</style>
<div class="sportlet mb-3">
	<div class="sportlet-header-special">
		<h3>
			Bildirim Ayarları
		</h3>
	</div>
	<div class="user-settings">
		<form>
			<div class="user-settings-item">
				<div class="user-settings-left">
					<div class="user-settings-icon">
						<img alt="SMS" title="SMS" width="38px" height="38px" src="https://webailesi-demo.com/api/assets/images/sms.svg">
					</div>
					<label for="sms" class="user-settings-content">
						<strong>SMS</strong>
						<span>
							Bu seçenek <span class="t-red">deaktiv</span> olması durumunda servislerimiz ve ürünleriniz hakkında önemli ve acil durumdaki sms bildirimlerini almayacaksınız.
						</span>
					</label>
				</div>
				<div>
					<input id="sms" type="checkbox" class="checkbox-switch" name="">
				</div>
			</div>
			<div class="user-settings-item">
				<div class="user-settings-left">
					<div class="user-settings-icon">
						<img alt="SMS" title="SMS" width="38px" height="38px" src="https://webailesi-demo.com/api/assets/images/sms.svg">
					</div>
					<label for="sms" class="user-settings-content">
						<strong>SMS</strong>
						<span>
							Bu seçenek <span class="t-red">deaktiv</span> olması durumunda servislerimiz ve ürünleriniz hakkında önemli ve acil durumdaki sms bildirimlerini almayacaksınız.
						</span>
					</label>
				</div>
				<div>
					<input id="sms" type="checkbox" class="checkbox-switch" name="">
				</div>
			</div>
			<div class="user-settings-footer">
				<button class="btn btn-primary" type="submit">Kaydet</button>
			</div>
		</form>
	</div>
</div>

<div class="sportlet mb-3">
	<div class="sportlet-header-special">
		<h3>
			Referral Program
		</h3>
	</div>
	<div class="referral">
		<div class="referral-top">
			<div class="referral-item">
				<strong>How to use Referral Program</strong>
				<p>
					Use images to enhance your post, improve its flow, add humor
					<br>
					and explain complex topics
				</p>
				<button class="btn btn-getstart">
					Get Started
				</button>
			</div>
			<div class="referral-item">
				<strong>Your Referral Link</strong>
				<p>
					Plan your blog post by choosing a topic, creating an outline conduct
					<br>
					research, and checking facts
				</p>
				<div class="referral-input">
					<input type="text" value="https://keenthemes.com/reffer/?refid=345re66787k8" name="">
					<button class="btn btn-copy">Copy Link</button>
				</div>
			</div>
		</div>
		<div class="referral-body">
			<div class="referral-item">
				<span class="text-purple">Net Earnings</span>
				<strong>$63,240</strong>
			</div>
			<div class="referral-item">
				<span class="text-success">Net Earnings</span>
				<strong>$63,240</strong>
			</div>
			<div class="referral-item">
				<span class="text-danger">Net Earnings</span>
				<strong>$63,240</strong>
			</div>
			<div class="referral-item">
				<span class="text-primary">Net Earnings</span>
				<strong>$63,240</strong>
			</div>
		</div>
		<div class="referral-info">
			Writing headlines for blog posts is as much an art as it is a science, and probably warrants its own post, but for now, all I’d advise is experimenting with what works for your audience, especially if it’s not resonating with your audience
		</div>
		<div class="referral-alert">
			<div class="referral-left">
				<div class="referral-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
						<path d="M20 19.725V18.725C20 18.125 19.6 17.725 19 17.725H5C4.4 17.725 4 18.125 4 18.725V19.725H3C2.4 19.725 2 20.125 2 20.725V21.725H22V20.725C22 20.125 21.6 19.725 21 19.725H20Z" fill="currentColor"></path>
						<path opacity="0.3" d="M22 6.725V7.725C22 8.325 21.6 8.725 21 8.725H18C18.6 8.725 19 9.125 19 9.725C19 10.325 18.6 10.725 18 10.725V15.725C18.6 15.725 19 16.125 19 16.725V17.725H15V16.725C15 16.125 15.4 15.725 16 15.725V10.725C15.4 10.725 15 10.325 15 9.725C15 9.125 15.4 8.725 16 8.725H13C13.6 8.725 14 9.125 14 9.725C14 10.325 13.6 10.725 13 10.725V15.725C13.6 15.725 14 16.125 14 16.725V17.725H10V16.725C10 16.125 10.4 15.725 11 15.725V10.725C10.4 10.725 10 10.325 10 9.725C10 9.125 10.4 8.725 11 8.725H8C8.6 8.725 9 9.125 9 9.725C9 10.325 8.6 10.725 8 10.725V15.725C8.6 15.725 9 16.125 9 16.725V17.725H5V16.725C5 16.125 5.4 15.725 6 15.725V10.725C5.4 10.725 5 10.325 5 9.725C5 9.125 5.4 8.725 6 8.725H3C2.4 8.725 2 8.325 2 7.725V6.725L11 2.225C11.6 1.925 12.4 1.925 13.1 2.225L22 6.725ZM12 3.725C11.2 3.725 10.5 4.425 10.5 5.225C10.5 6.025 11.2 6.725 12 6.725C12.8 6.725 13.5 6.025 13.5 5.225C13.5 4.425 12.8 3.725 12 3.725Z" fill="currentColor"></path>
					</svg>
				</div>
				<div class="referral-content">
					<div class="referral-title">
						Withdraw Your Money to a Bank Account
					</div>
					<div class="referral-desc">
						Withdraw money securily to your bank account. Commision is $25 per transaction under $50,000
					</div>
				</div>
			</div>
			<div class="referral-right">
				<a href="#" class="btn btn-primary">Withdraw Money</a>
			</div>
		</div>
	</div>
</div>

<div class="sportlet">
	<div class="sportlet-header-special sportlet-headerb mb-3">
		<div>
			<h3>Ödenmiş Makbuzlarım</h3>
		</div>
		<div>
			<a href="https://satis.webailesi.xyz/musteri/musteri-paneli/yeni-destek-talebi" class="btn btn-transparent btn-icon btn-flex btn-sm">
				<i class="ri-add-line"></i>
				Yeni Destek Talebi
			</a>
		</div>
	</div>
    	<div class="stable">
        <table class="table">
            <thead>
                <tr>
                    <th>Makbuz-NO</th> 
                    <th>Açıklama</th> 
                    <th>Toplam</th> 
                    <th>Son Ödeme Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                                <tr>
                    <td>#31</td>
                    <td>Ürün satın alımı</td>
                    <td>58.88 TL</td>
                    <td>29.06.2022</td>
                    <td>
                        <a href="https://satis.webailesi.xyz/musteri/musteri-paneli/makbuz/31" class="btn btn-special btn-sm">Görüntüle</a>
                    </td>
                </tr>
                            </tbody>
        </table>	
    </div>
    </div>
<script>
	var status = 0;
	$(".settingSwitch").on("change",function(){
		var tab = $(this).data("tab");
		if(this.checked){
			status = 1;
		}
		else{
			status = 0;
		}
		$.ajax({
			url: "{$mybb->settings['homeurl']}user/client/ajax/alertsettings.php",
			type: "post",
			data: {action:tab,status:status},
			dataType: "json",
			crossDomain: true,
			success: function(response){
				if(response.success){
					$(".toast").removeClass("errorToast").addClass("succesToast").toast("show");
					$("#toastIcon").toggleClass("ri-check-line");
					$("#toastText").html(response.success);
				}
				else{
					$(".toast").removeClass("succesToast").addClass("errorToast").toast("show");
					$("#toastIcon").toggleClass("ri-close-line");
					$("#toastText").html(response.error);
				}
			}
		});	
	});
</script>
@endsection