@extend('client.laylout')
@section('content')
@if($logs)
<div class="sportlet">
	<div class="sportlet-header-special mb-3">
		<h3>
			Bildirim Kayıtları
		</h3>
	</div>
	<div class="stable">
		<table class="table">
			<thead>
				<tr>
                    <th>#</th> 
					<th>Bildirim</th> 
					<th>Gönderen</th>
					<th>Durum</th>
					<th>Tarih</th>
				</tr>
			</thead>
			<tbody>
				@foreach($logs as $log)
                @php $data = json_decode($log['ainfo'],true); @endphp
                <tr>
                    <td>{{ $log['aid'] }}</td>
                    <td><a href="{{ $log['alink'] }}">{{ $data['message'] }}</a></td>
                    <td>{{ $log['name']." ".$log['surname'] }}</td>
                    <td>{{ $log['astatus'] == 0 ? ("<span class=\"text-success\">Okundu(".date('d.m.Y',$log['areadtime']).")</span>"):("<span class=\"text-danger\">Okunmadı</span>") }}</td>
                    <td>{{ date('d.m.Y',$log['adateline']) }}</td>
                </tr>
                @endforeach
			</tbody>
		</table>		
	</div>
</div>
@else
<div class="sportlet">
	<div class="sportlet-header-special mb-3">
		<h3>Bildirim Kayıtları</h3>
	</div>
	<div class="card-body text-center">
		<i class="ri-lifebuoy-line font-weight-bold display-4"></i> 
		<h5 class="my-2">Hiç bir kaydınız bulunmamaktadır.</h5> 
	</div>
</div>
@endif
@endsection