@extend('client.laylout')
@section('content')
<div class="sportlet">
	<div class="smain">
		<div class="invoice-header">
			<div>
				<span class="invoice-name">
					Makbuz Detayları
				</span>
			</div>
			<div class="invoice-company">
				<img src="https://www.webailesi.com/upload/cdn/headerlogo/logo_v1.svg" alt="WEBAilesi.COM" width="60" height="60">
			</div>
		</div>
		<hr>
		<div class="invoice-info">
			<div>
				<span class="invoice-key">Makbuz No</span>
				<span class="invoice-val">#{{ $invoice['iid'] }}</span>
			</div>		
			<div>
				<span class="invoice-key">İsim</span>
				<span class="invoice-val">{{ $invoice['iname'] }}</span>
			</div>	
			<div>
				<span class="invoice-key">Açıklama</span>
				<span class="invoice-val">{{ $invoice['idescription'] }}</span>
			</div>
		</div>		
		<div class="invoice-info">
			<div>
				<span class="invoice-key">Ödeme Durumu</span>
				<span class="invoice-val">{{ $istatus[$invoice['istatus']] }}</span>
			</div>
			<div>
				<span class="invoice-key">Oluşturulma Tarihi</span>
				<span class="invoice-val">{{ date('d.m.Y',$invoice['idateline']) }}</span>
			</div>
			<div>
				<span class="invoice-key">Son Ödeme Tarihi</span>
				<span class="invoice-val">{{ date('d.m.Y H:i',$invoice['iexpiredate']) }}</span>
			</div>
		</div>	
		<div class="stable mt-3">
			<table class="table">
				<thead>
					<tr>
						<th>#</th>
						<th>Hizmet Adı</th>
						<th>Adet</th>
						<th>Toplam</th>
					</tr>
				</thead>
				<tbody>
					@php 
                    $ibasket = json_decode($invoice['ibasket'],true); 
                    $counter = 1;
                    @endphp
                    @foreach($ibasket as $basket)
                    <tr>
                        <td>{{ $counter }}</td>
                        <td>{{ $basket[0] }}</td>
                        <td>{{ $basket[2] }} Adet</td>
                        <td>+{{ $basket[1] }} {{ $currencies[$basket[4]]['cicon'] }}</td>
                    </tr>
                    @php $counter += 1 @endphp
                    @endforeach
                    @if($invoice['itaxprice'] > 0)
                    <tr>
                        <td>{{ $counter }}</td>
                        <td>Katma Değer Vergisi</td>
                        <td>1 Adet</td>
                        <td>+{{ beMoneyFormat($invoice['itaxprice']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</td>
                    </tr>
                    @php $counter += 1 @endphp
                    @endif
                    @if($invoice['idiscount'] > 0)
                    <tr>
                        <td>{{ $counter }}</td>
                        <td>İndirim</td>
                        <td>1 Adet</td>
                        <td>-{{ beMoneyFormat($invoice['idiscount']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</td>
                    </tr>
                    @endif
				</tbody>
			</table>			
		</div>
	</div>
	<div class="invoice-footer smain">
		<div>
			<span class="font-weight-bold text-muted text-uppercase text-right">Toplam</span>
			<span class="text-primary font-size-h3 font-weight-boldest text-right">{{ beMoneyFormat($invoice['itotal']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</span>
		</div>
		@if($invoice['istatus'] == '0')
            <div style="display:flex;justify-content:center;align-items:center;margin-left:20px;"><a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}?action=pay" class="btn btn-transparent">Öde</a></div>
        @endif
	</div>
</div>
@endsection