@extend('client.laylout')
@section('headerinclude')
<style>
	.bank-accounts {
		list-style: none;
	}
	.bank-accounts li {
		display: flex;
		align-items: center;
		padding: 30px;
		border-radius: 3px;
		box-shadow: 0 0.5rem 1rem rgb(0 0 0 / 15%);
		background: #fff;		
	}
	.bank-accounts li:not(:last-child) {
		margin-bottom: 15px;
	}
	.bank-image {
		margin-right: 30px;
	}
	.bank-key {
		width: 90px;
		display: inline-block;
		color: #4b555a;
	}
	.bank-val {
		color: #4b555a;
	}
	.bank-val:before {
		content: ":";
		margin-right: 20px;
	}
	@media screen and (max-width:543px) {  
		.bank-accounts li {
			flex-direction: column;
		}
		.bank-image {
			margin: 10px 0px;
		}
	}
</style>
@endsection
@section('content')
<ul class="bank-accounts">
	@foreach($banks as $bank)
	<li>
		<div class="bank-image">
			<img src="{{ $bank['bimage'] }}" width="200" height="60">
		</div>
		<div>
			<div>
				<span class="bank-key">Banka</span>
				<span class="bank-val">{{ $bank['bname'] }}</span>
			</div>
			<div>
				<span class="bank-key">IBAN</span>
				<span class="bank-val">{{ $bank['biban'] }}</span>
			</div>
			<div>
				<span class="bank-key">Ad Soyad</span>
				<span class="bank-val">{{ $bank['buser'] }}</span>
			</div>
		</div>
	</li>
	@endforeach
</ul>
@endsection