@extend('laylout')
@section('headerinclude')
<meta name="description" content="Webailesi.com satış sistemi" />
<script type="text/javascript" src="assets/premium/jscripts/plugins/intltellinput.min.js?ver=1827"></script>
<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
<link type="text/css" rel="stylesheet" href="assets/premium/css/intltelinput.min.css?ver=1828">
<style>
    .card-head {
        font-size:26px;
        font-weight:400;
        color:#4b555a
    }
    .form-center {
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .form-group {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    .form-group label {
        color: #6c757d;
    }
    .input-group {
        position: relative;
    }
    .input-group input {
        text-indent: 35px;
        height: calc(3.4rem + 2px);
    }
    .input-group input[type="tel"]{
        width: 100%;
        text-indent: 15px;
    }
    .input-icon {
        width: 40px;
        height: calc(3.4rem + 2px);
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .icon-info {
        right: 0;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
    .form-control.error {
        border: 1px solid var(--bs-red);
    }
    .form-control:focus {
        box-shadow: none;
    }
    input[type="date"] {
        position: relative;
    }
    input[type="date"]::-webkit-calendar-picker-indicator {
        background: transparent;
        bottom: 0;
        color: transparent;
        cursor: pointer;
        height: auto;
        left: 0;
        position: absolute;
        right: 0;
        top: 0;
        width: auto;
    }
    .info-text {
        color: #4b555a;
    }
    .steps {
        margin-top: 15px;
    }
    .steps ul {
        display: flex;
        list-style: none;
    }
    .steps ul li {
        width: 33%;
        display: flex;
        padding: 10px;
        justify-content: center;
        align-items: center;
        border-bottom: 1px solid #b1b1b1;
        cursor: pointer;
    }
    .steps ul li .step-num {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
        border: 1px solid #1640;
        box-shadow: 1px 1px 3px rgb(200 197 197);
        color: #b1b1b1;
    }
    .steps ul li .step-name {
        margin-left: 10px;
        font-size: 16px;
        font-weight: 400;
        color: #b1b1b1;
    }
    .steps ul li.active .step-num {
        border: 1px solid #1d7bc4;
        color: #1d7bc4;
    }
    .steps ul li.active .step-name {
        color: #1d7bc4;
    }
    .steps ul li.active {
        border-bottom: 1px solid #1d7bc4;
    }
    .step-content {
        display: none;
    }
    .step-content.active {
        display: block;
    }
    .text-error {
        width: 100%;
        color: var(--bs-red);
        font-size: 14px;
        margin-top: 10px;
        margin-bottom: 5px;
    }
    @media screen and (max-width:543px) {
        .steps ul {
            display: block;
        }
        .steps ul li { 
            width: 100%;	
        }
        .form-group {
            width: 90%;
        }
    }
</style>
@endsection
@section('content')
<div class="container pb-3">
    <div class="row justify-content-center pt-5 pt-sm-5 pt-md-5 pt-lg-0"> 
        <div class="col-md-12">
            <div class="card login-signup-card mb-0">
                <form id="registerForm" autocomplete="off">
                    <div class="card-body row px-md-5 py-5"> 
                        <div class="col-md-12 col-lg-12 border-right cart-flex-login"> 
                            <div class="mb-0 text-center"> 
                                <h5 class="h3 card-head">Kayıt Formu</h5>
                            </div>
                            <div class="steps-content">
                                <div class="step-content active" id="step1">
                                    <div class="form-center mt-3">
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">İsim</label> 
                                            <div class="input-group input-group-merge">
                                                <div class="input-icon"> 
                                                    <i class="ri-user-line"></i>
                                                </div> 
                                                <input type="text" class="form-control" name="name" autocomplete="false" placeholder="İsim"> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">Soy İsim</label> 
                                            <div class="input-group input-group-merge">
                                                <div class="input-icon"> 
                                                    <i class="ri-user-line"></i>
                                                </div> 
                                                <input type="text" class="form-control" name="surname" autocomplete="false" placeholder="Soyisim"> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">E-Posta Adresi</label> 
                                            <div class="input-group input-group-merge">
                                                <div class="input-icon"> 
                                                    <i class="ri-at-line"></i>
                                                </div> 
                                                <input type="email" class="form-control" name="email" autocomplete="false" placeholder="isim@alan-adi.com"> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">Şifre</label> 
                                            <div class="input-group input-group-merge">
                                                <div class="input-icon"> 
                                                    <i class="ri-user-line"></i>
                                                </div> 
                                                <input type="password" class="form-control" name="password1" autocomplete="false" placeholder="Şifre"> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">Tekrar Şifre</label> 
                                            <div class="input-group input-group-merge">
                                                <div class="input-icon"> 
                                                    <i class="ri-user-line"></i>
                                                </div> 
                                                <input type="password" class="form-control" name="password2" autocomplete="false" placeholder="Tekrar Şifre"> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <label class="pb-1">Adres</label> 
                                            <div class="input-group input-group-merge">
                                                <textarea class="form-control" name="address" autocomplete="false" rows="4" cols="10"></textarea> 
                                            </div> 
                                        </div>
                                        <div class="form-group col-md-6"> 
                                            <div class="input-group">
                                                <input type="tel" name="phone" id="phone" class="form-control">
                                            </div>
                                        </div>	
                                        <div class="col-md-6">
                                            <div class="col-sm-12">
                                                <label class="checkbox text-left">
                                                    <input type="checkbox" name="invoiceinfo" class="accepttos" value="Evet">
                                                    <span class="label-text small-text info-text">Fatura hatırlatmaları vs bilgileri sms ile almak istiyorum</span>
                                                </label>
                                            </div>
                                            <div class="col-sm-12">
                                                <label class="checkbox text-left">
                                                    <input type="checkbox" name="productinfo" class="accepttos" value="0">
                                                    <span class="label-text small-text info-text">Yeni ürün ve kampanyalardan haberdar olmak istiyorum.</span>
                                                </label>
                                            </div>
                                            <div class="col-sm-12">
                                                <label class="checkbox text-left">
                                                    <input type="checkbox" name="agreement" class="accepttos" value="0">
                                                    <span class="label-text small-text info-text">Belirtilen <a class="text-decoration-none" href="https://www.teamdiyo.com/sozlesmeler/kvkk-sozlesmesi">KVKK metnini</a>,<a class="text-decoration-none" href="https://www.teamdiyo.com/sozlesmeler/gizlilik-sozlesmesi">Gizlilik Sözleşmesini</a> ve <a class="text-decoration-none" href="https://www.teamdiyo.com/sozlesmeler/hizmet-sozlesmesi">diğer sözleşmeleri</a> okudum onaylıyorum.</span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="w-100">
                                            <button class="btn btn-special border-radius mt-4 mb-4 float-end userRegister">Kayıt Ol</button> 
                                        </div>	
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $("#phone").intlTelInput({
        utilsScript: "assets/premium/jscripts/plugins/telephone.utils.min.js?ver=1824",
        separateDialCode:true,
        preferredCountries: ["tr","us"]
    });
    $("#phone").keyup(function(e){
        var x = e.target.value.replace(/\D/g,'').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
        if(e.target.value.length < 6 && e.which == '8'){
            e.target.value = x[1]+x[2];
        }
        else{
            e.target.value = '('+x[1]+') '+x[2]+(x[3]?' '+x[3]:'');
        }
    });
    var wait = false;
    $(".userRegister").on("click",function(){
        if(!wait){
            $(".userRegister").html('<img src="assets/premium/img/loadingnew.svg" style="width:20px;height:20px"> Yükleniyor');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('auth.register.post') }}",
                type: "post",
                async: true,
                data: $("#registerForm").serialize()+"&phone_dial="+$("#phone").intlTelInput("getSelectedCountryData").dialCode,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".userRegister").html("Kayıt Ol");
                    if(response.status){
                        toast("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        toast("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            toast("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection