@extend('laylout')
@section('headerinclude')
<meta name="description" content="Webailesi.com satış sistemi" />
<script type="text/javascript" src="assets/premium/jscripts/bootstrap.bundle.min.js?ver=1850"></script>
<style>
    .form-center {
        display: flex;
        flex-direction: column;
        align-items: center;
    }
    .form-group {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    .form-group label {
        color: #6c757d;
    }
    .input-group {
        position: relative;
        height: calc(3.4rem + 2px);
    }
    .input-group input {
        text-indent: 35px;
    }
    .input-group input[type="tel"]{
        width: 100%;
        height: calc(3.4rem + 2px);
        text-indent: 0px;
    }
    .input-icon {
        width: 40px;
        height: calc(3.4rem + 2px);
        position: absolute;
        z-index: 4;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .input-icon i {
        color: #b1b1b1;
        font-size: 18px;
    }
    .form-control:focus {
        box-shadow: none;
    }
</style>
@endsection
@section('content')
<div class="container my-3">
    <div class="row justify-content-center pt-5 pt-sm-5 pt-md-5 pt-lg-0"> 
        <div class="col-md-8">
            <div class="card login-signup-card mb-0">
                <div id="loginCart" class="card-body row px-md-5 py-5"> 
                    <div class="col-md-12 col-lg-12 border-right cart-flex-login"> 
                        <div class="mb-0 text-center"> 
                            <h5 class="h3" style="font-size:23px;font-weight:400">Şifremi Unuttum</h5>
                        </div>
                        <div class="form-center mt-3">
                            <div id="mailArea" class="form-group col-md-6"> 
                                <label class="pb-1">Yeni Şifrenizi Giriniz</label> 
                                <div class="input-group input-group-merge">
                                    <div class="input-icon"> 
                                        <i class="ri-user-line"></i>
                                    </div> 
                                    <input type="password" class="form-control" name="password1" id="password1" autocomplete="false" autofocus="" placeholder="Yeni Şifrenizi Giriniz"> 
                                </div> 
                            </div>
                            <div id="phoneArea" class="form-group col-md-6"> 
                                <label class="pb-1">Yeni Şifrenizi Tekrar Giriniz</label> 
                                <div class="input-group input-group-merge">
                                    <div class="input-icon"> 
                                        <i class="ri-user-line"></i>
                                    </div> 
                                    <input type="password" class="form-control" name="password2" id="password2" autocomplete="false" autofocus="" placeholder="Yeni Şifrenizi Tekrar Giriniz"> 
                                </div> 
                            </div>
                            <div class="w-100 d-flex justify-content-end mt-4 mb-4">
                                <button class="btn btn-special border-radius resetPassword">Sıfırla</button> 
                            </div>	
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".resetPassword").on("click",function(){
        $.ajax({
            url: "{{ beGetRoute('auth.changepassword.post') }}",
            type: "post",
            data: {code:"{{ $verification['vcode'] }}",password1:$("#password1").val(),password2:$("#password2").val()},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    toast("Başarılı",response.message,"success");
                    setTimeout(function(){
                        window.location.href = response.url;
                    },1000);								
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });										
        return false;
    });
</script>
@endsection