@extend('admin.laylout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            Kullanıcı
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Kullanıcı ID</td>
                                            <td class="text-gray-800"># {{ $user['uid'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Kullanıcı Bilgileri</td>
                                            <td class="text-gray-800">
                                                {{ $user['username'] }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Kullanıcı Mail</td>
                                            <td class="text-gray-800">{{ $user['email'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Kullanıcı Grubu</td>
                                            <td class="text-gray-800">{{ $usergroup['ugname'] }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Kayıt Tarihi:</td>
                                            <td class="text-gray-800">{{ date('d.m.Y',$user['regdate']) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Bakiye</td>
                                            <td class="text-gray-800">{{ $user['money'].' '.$currencie['cicon'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Para Birimi</td>
                                            <td class="text-gray-800">{{ $currencie['cname'] }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <div class="d-flex flex-wrap py-5">
                                    <div class="flex-equal me-5">
                                        <form id="statusForm">
                                            <div class="row">
                                                <div class="col-12 mb-9">
                                                    <select class="form-control form-control-select" name="status" id="statusSelect">
                                                        @foreach($status as $key => $name)
                                                        <option value="{{ $key }}"{{ $key == $user['status'] ? ' selected':'' }}>{{ $name[0] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-12 mb-9" id="statusFormExtend" style="display: none;">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-4">
                                                            <button class="btn btn-success d-block m-auto statusSaveForm">Kaydet</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="flex-equal me-5">
                                    </div>
                                </div>
                            </div>
                            <div class="flex-equal me-5" id="contentUp">
                                
                            </div>
                        </div>
                        <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5 active" href="#" data-tab="Global">Genel</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Info">Bilgiler</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Settings">Seçenekler</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Orders">Hizmetler</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Invoices">Faturalar</a>
                            </li>
                            @foreach($tabs as $key => $value)
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="{{ $key }}">{{ $value['name'] }}</a>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="tabs">
        <div class="tab active" id="tabGlobal">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="alert alert-warning d-flex align-items-center p-5">
                            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-warning">Toplam Siarpiş Adedi</h4>
                                <span id="orderCount"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12">
                        <div class="alert alert-warning d-flex align-items-center p-5">
                            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-warning">Toplam Fatura Adedi</h4>
                                <span id="invoiceCount"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
       
                    </div>
                    <div class="col-xl-6">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">
                                            Notlar
                                        </div>
                                    </div>
                                    <form id="noteForm" class="card-body">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <textarea class="form-control" name="note" rows="7">{{ $userinfo['uinote'] }}</textarea>
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-success d-block m-auto noteSaveForm">Kaydet</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabInfo">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Kullancı Bilgileri
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="nameForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Adı</label>
                                            <input type="text" class="form-control" name="name" value="{{ $user['name'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Soy Adı</label>
                                            <input type="text" class="form-control" name="surname" value="{{ $user['surname'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Email</label>
                                            <input type="text" class="form-control" name="email" value="{{ $user['email'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Şifre</label>
                                            <input type="text" class="form-control" name="password" value="" placeholder="Şifreyi değiştirmek isterseniz bu alanı doldurun">
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto nameSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="row">
                            <div class="col-xl-12 mb-5">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-title">
                                            Telefon Numarası
                                        </div>
                                    </div>
                                    <form id="phoneForm" class="card-body">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2">Telefon Numarası</label>
                                                <input type="text" class="form-control" name="phone" value="{{ $userinfo['uiphone'] }}">
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-success d-block m-auto phoneSaveForm">Kaydet</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabSettings">
                <div class="row g-5 g-xl-8">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Seçenekler
                                </div>
                            </div>
                            <form id="settingForm" class="card-body">
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">SMS Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda sms yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="sms_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="sms_alert" value="1"{{ $uisettings['sms_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Mail Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda mail yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="mail_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="mail_alert" value="1"{{ $uisettings['mail_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Bildirim Bilgilendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcılara satın alım vs gibi durumlarda bildirim yollar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="notification_alert" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="notification_alert" value="1"{{ $uisettings['notification_alert'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Otomatik Ödeme İzni</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcının otomatik ödemeyi açıp açamayacağını belirler!</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="order_auto_pay" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="order_auto_pay" value="1"{{ $uisettings['order_auto_pay'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Vergi Muafiyeti</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcıdan faturalar için katma değer vergisi ödememesini sağlar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="invoice_tax_exemption" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="invoice_tax_exemption" value="1"{{ $uisettings['invoice_tax_exemption'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Fatura Gecikme Ücreti</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Fatura ödemesi geçtiğinde faturayı zamlandır</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="invoice_latefee" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="invoice_latefee" value="1"{{ $uisettings['invoice_latefee'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12">
                                        <hr>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Destek Talebi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcı destek talebi açabilir.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_create" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_create" value="1"{{ $uisettings['ticket_create'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Tek Destek Talebi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu kullanıcının aynı anda tek bir destek talebi olabilir</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_onlyone" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_onlyone" value="1"{{ $uisettings['ticket_onlyone'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Destek Dosyası</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Kullanıcı taleplere dosya yükleyebilir</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="ticket_files" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="ticket_files" value="1"{{ $uisettings['ticket_files'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto settingSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabOrders">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card mb-4">
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Ürün</th>
                                            <th class="text-center align-middle">Sahip</th>
                                            <th class="text-center align-middle">Durum</th>
                                            <th class="text-center align-middle">Yenlieme Fiyatı</th>
                                            <th class="text-center align-middle">Tarihler</th>
                                            <th class="text-center align-middle">Düzenle</th>
                                        </tr>
                                    </thead>
                                    <tbody id="orderList">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabInvoices">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="d-flex justify-content-end">
                            <a href="{{ beGetRoute('admin.invoice.add') }}?user={{ $user['uid'] }}" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3">
                                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect>
                                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                Yeni Fatura Oluştur
                            </a>
                        </div>
                        <div class="card mb-4">
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Sahip</th>
                                            <th class="text-center align-middle">Açıklama</th>
                                            <th class="text-center align-middle">Durum</th>
                                            <th class="text-center align-middle">Fatura Tipi</th>
                                            <th class="text-center align-middle">Fatura Durumu</th>
                                            <th class="text-center align-middle">Tutar</th>
                                            <th class="text-center align-middle">KDV</th>
                                            <th class="text-center align-middle">İndirim</th>
                                            <th class="text-center align-middle">Toplam</th>
                                            <th class="text-center align-middle">Ödenme Methodu</th>
                                            <th class="text-center align-middle">Bitiş Tarihi</th>
                                            <th class="text-center align-middle">Oluşturulma Tarihi</th>
                                            <th class="text-center align-middle">Düzenle</th>
                                        </tr>
                                    </thead>
                                    <tbody id="invoiceList">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @foreach($tabs as $key => $value)
            <div class="tab" id="tab{{ $key }}">
                {{ $value['template'] }}
            </div>
            @endforeach
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var module = "{{ $order['upmodule'] }}";
    $(".nav-link").on("click",function(){
        var tab = $(this).data("tab");
        $(".nav-link.active").removeClass("active");
        $(this).addClass("active");
        $(".tab.active").removeClass("active");
        $("#tab"+tab).addClass("active");
        return false;
    });
    $("#statusSelect").change(function(){
        $("#statusFormExtend").show("slow");
    });
    var wait1 = false;
    $(".statusSaveForm").on("click",function(){
        if(!wait1){
            wait1 = true;
            $(".statusSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.status.save.post') }}",
                type: "post",
                async: true,
                data: $("#statusForm").serialize()+"&upid={{ $order['upid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".statusSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait2 = false;
    $(".nameSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".nameSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.name.save.post') }}",
                type: "post",
                async: true,
                data: $("#nameForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".nameSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".phoneSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".phoneSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.phone.save.post') }}",
                type: "post",
                async: true,
                data: $("#phoneForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".phoneSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".noteSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".noteSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.note.save.post') }}",
                type: "post",
                async: true,
                data: $("#noteForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".noteSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait3 = false;
    $(".settingSaveForm").on("click",function(){
        if(!wait3){
            wait3 = true;
            $(".settingSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.user.setting.save.post') }}",
                type: "post",
                async: true,
                data: $("#settingForm").serialize()+"&uid={{ $user['uid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait3 = false;
                    $(".settingSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    setTimeout(function(){
        $.ajax({
            url: "{{ beGetRoute('admin.order.search.post') }}",
            type: "post",
            data: {status:-2,product:0,user:"",uid:{{ $user['uid'] }},data:"",options:"",sort:0,page:0,pageitems:999},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#orderList").empty().append(response.html);
                    $("#orderCount").empty().append(response.ordercount+" Adet");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.search.post') }}",
            type: "post",
            data: {name:"",status:-2,type:-1,bill:-1,user:"",uid:{{ $user['uid'] }},sort:0,page:0,pageitems:999},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#invoiceList").empty().append(response.html);
                    $("#invoiceCount").empty().append(response.invoicecount+" Adet");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    },1000);
    $("#invoiceList").on("click",".btnDelete",function(){
        var iid = $(this).data("iid");
        Swal.fire({
            html: "Bu faturayı silmek istediğinize emin misiniz ?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.invoice.delete.post') }}",
                    type: "post",
                    data: {iid:iid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+iid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>
@endsection