@extend('admin.laylout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.accounting.periodic.list') }}" class="d-inline-flex align-items-center btn btn-primary mb-5">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Ürün Ekle
            </a>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Ad</th>
                            <th class="text-center align-middle">Stok</th>
                            <th class="text-center align-middle">Aktif/Satılan</th>
                            <th class="text-center align-middle">Modül</th>
                            <th class="text-center align-middle">Tarih</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($products as $product)
                        <tr id="{{ $product['pid'] }}Row">
                            <td class="text-center align-middle">{{ $product['pid'] }}</td>
                            <td class="text-center align-middle">{{ $product['pname'] }}</td>
                            <td class="text-center align-middle">{{ $product['pstock'] }}</td>
                            <td class="text-center align-middle">{{ $product['pactive'].'/'.$product['psold'] }}</td>
                            <td class="text-center align-middle">{{ $product['pmodule'] ? $modules[$product['pmodule']]['info']['name']:'Bulunmuyor' }}</td>
                            <td class="text-center align-middle">{{ beSpecialTime($product['pdateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Görüntüle" href="{{ beGetRoute('admin.product.show',['pid' => $product['pid']]) }}" class="btn btn-warning"><i class="far fa-eye"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection