@extend('admin.layout')
@section('headerinclude')
<title>Hetzner Cloud - Modülü</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
            <div class="container" id="kt_docs_content_container">
                <div class="card card-docs flex-row-fluid mb-2">
                    <div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">
                        <div>
                            <h1 class="anchor fw-bold mb-2" id="gulp-quick-start" data-kt-scroll-offset="50">Hetzner Cloud Modülü</h1>
                            <div>Hetzner Cloud modülüne hoşgeldiniz, bu modül ile Hetzner üzerindeki Cloud ürünlerinin satışını yapabilirsiniz.</div>
                            <div class="mb-3">Sistemin çalışması için gerekli olan bilgileri içerir. Ayarları yapmak için "Ayarları Yap" butonuna basınız.</div>
                            <div>
                                <a data-bs-toggle="tooltip" title="Eklenti Ayarları" class="btn btn-primary" href="{{ $settingsurl }}">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="2" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="2" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                        </svg>
                                    </span>
                                    Ayarları Yapın
                                </a>
                            </div>
                            <div class="separator separator-dashed my-5"></div>
                            <div class="mb-3">Sistemin sizler için ürün eklentileri otomatik olarak yapılandırması için aşağıdaki butonlara tıklayınız. Bu işlemi bir seferlik olarak yapacak olup ürün eklentileri kısmına gerekli eklentileri otomatik oluşturacaktır.</div>
                            <div>
                                <a data-bs-toggle="tooltip" title="İşletim Sistemi Eklentisini Oluştur" class="btn btn-primary beCreateAddon" data-addontype="image" href="#">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="2" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="2" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                        </svg>
                                    </span>
                                    İşletim Sistemi Eklentisini Oluştur
                                </a>
                                <a data-bs-toggle="tooltip" title="Ürünler İçin Lokasyon Eklentilerini Oluştur" class="btn btn-primary beCreateAddon" data-addontype="location" href="#">
                                    <span class="svg-icon svg-icon-2 mx-0">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="2" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="2" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="13" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                            <rect opacity="0.3" x="2" y="13" width="9" height="9" rx="2" fill="currentColor"></rect>
                                        </svg>
                                    </span>
                                    Ürünler İçin Lokasyon Eklentilerini Oluştur
                                </a>
                            </div>
                            <div class="separator separator-dashed my-5"></div>
                            <div class="mb-3">Artık ürünleri oluştururken <code>Modül</code> kısmından Hetzner Cloud sunucunuzu ve modülünü seçtikten sonra aşağıdaki doğru ürünü seçip <code>Yapılandırma</code> sekmesi üzerinden İşletim Sistemi(CPX) ve ürünüze ait lokasyon seçeneğini seçmeniz yeterlidir.</div>
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
$(".beCreateAddon").on("click",function(){
    var addontype = $(this).data("addontype");
    $.ajax({
        url: "{{ beGetRoute('hetznercloud.addon.add.post') }}",
        type: "post",
        data: {addontype:addontype},
        dataType: "json",
        crossDomain: true,
        success: function(response){
            if(response.status){
                Swal.fire("Başarılı",response.message,"success");
            }
            else{
                Swal.fire("Bir Hata Oluştu",response.message,"error");
            }
        }
    });	
    return false;
});
</script>
@endsection