<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_ban') }}</span>
                </div>
                <div>
                    <a href="#" class="btn btn-danger btn-sm ml-2 beCallRequestx" data-method="unban_all">
                        <i class="ri-forbid-line"></i>
                        {{ __('teamspeak_ban_unban_all') }}
                    </a>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('teamspeak_ban_ip') }}</th>
                            <th>{{ __('teamspeak_ban_name') }}</th>
                            <th>{{ __('teamspeak_ban_duration') }}</th>
                            <th>{{ __('teamspeak_ban_reason') }}</th>
                            <th>{{ __('teamspeak_ban_invokername') }}</th>
                            <th>{{ __('teamspeak_ban_date') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($banlist)
                        @foreach($banlist as $ban)
                        <tr id="ban{{ $ban['banid'] }}">
                            <td>{{ $ban['banid'] }}</td>
                            <td>{{ $ban['ip'] }}</td>
                            <td>{{ $ban['name'] }}</td>
                            <td>{{ beConvertTime($ban['duration']) }}</td>
                            <td>{{ $ban['reason'] }}</td>
                            <td>{{ $ban['invokername'] }}</td>
                            <td>{{ beSpecialTime($ban['created']) }}</td>
                            <td class="row-flex">
                                <a href="#" class="btn btn-danger btn-sm ml-2 beCallRequestx" data-method="unban" data-data="banid={{ $ban['banid'] }}" data-banid="{{ $ban['banid'] }}">
                                    <i class="ri-forbid-line"></i>
                                    {{ __('teamspeak_ban_unban') }}
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="7">
                                <div class="beempty">
                                    <div>{{ __('teamspeak_ban_empty') }}</div>
                                </div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        if(method == "unban"){
                            $("#ban"+item.data("banid")).remove();
                        }
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>