<style>
    .be_container {
        width: 100%;
        text-align: start;
        color: #fff;
    }
    .be_serverusage_realtime {
        width: 100%;
        display: flex;
        justify-content: center;
    }
    .be_serverusage_realtime_item {
        position: relative;
        width: 25%;
        margin: 0px 5px;
        min-height: 300px;
    }
    .besr_header > span {
        font-size: 14px;
        font-weight: bold;
    }
    .besr_percent {
        margin: 30px 0px 20px 0px;
    }
    .besr_usage_text {
        position: absolute;
        right: 20px;
        bottom: 14px;
        font-size: 12px;
        color: #fff;
    }
    .besr_usage_buttons {
        display: flex;
        justify-content: center;
        margin-bottom: 30px;
    }
    .be_server_process {
        margin-top: 30px;
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
    }
    .be_server_process > a {
        margin: 10px 30px 10px 30px;
    }
    .be_server_info {
        margin-top: 30px;
    }
    .be_server_info_table {
        margin-top: 10px;
    }
    .be_server_info_table {
        display: flex;
        flex-wrap: wrap;
    }
    .be_sit_row {
        width: 50%;
        display: flex;
        align-items: center;
        margin: 10px 0px;
        font-size: 13px;
    }
    .be_sit_row > div:first-child{
        width: 40%;
        margin-right:20px;
        font-size: 14px;
    }
    .be_sit_row > div:nth-child(2){
        width: 60%;
        font-size: 14px;
        opacity: .8;
    }
    .be_tabs {
        margin-top: 30px;
    }
    .be_tab {
        display: none;
    }
    .be_tab.active {
        display: block;
    }
    .be_button {
        position: relative;
        width: fit-content;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 10px 10px;
        border-radius: 6px;
        font-size: 12px;
        z-index: 99999;
    }
    .be_button:hover,.be_button:visited {
        color: #fff;
        text-decoration: none;
    }
    .be_button_c1x {
        color: #fff;
        border: 1px solid #009ef7;
    }
    .be_button_c1 {
        color: #fff;
        border: 1px solid #009ef7;
    }
    .be_button_c1 path,.be_button_c1 polygon,.be_button_c1 circle,.be_button_c1 rect {
        fill: #fff;
    }
    .be_button_c1_revese {
        fill: #151b2c!important;
    } 
    .be_button_c2 {
        color: #fff;
        background-color: #f1416c;
    }
    .be_display_center {
        display: flex!important;
        justify-content: center;
        align-items: center;
    }
    .besr_circle_chart {
        display: block;
        margin: 10px auto;
        max-height: 140px;
    }
    .besr_circle_bg {
        fill: none;
        stroke: #eee;
        stroke-width: 3.8;
    }
    .besr_circle {
        fill: none;
        stroke-width: 2.8;
        stroke-linecap: round;
        animation: progress 1s ease-out forwards;
    }
    @keyframes progress {
        0% {
            stroke-dasharray: 0 100;
        }
    }
    .besr_circle_percentage {
        fill: #fff;
        font-family: sans-serif;
        font-size: 7px;
        text-anchor: middle;
    }
    .be_card {
        padding: 10px 20px;
        box-shadow: 0 0 13px #e3e3e3;
        border-radius: 10px;
        background-color: #151b2c;
    }
    .be_card_header {
        min-height: 50px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        border-bottom: 1px solid #2b2b40;
    }
    .be_card_header > div {
        font-size: 16px;
        font-weight: bold;
        color: #fff;
    }
    .besr_header {
        color: #fff;
    }
    .beSpinner {
        display: inline-block;
        width: 15px;
        height: 15px;
        border-radius: 50%;
        animation: 1.3s linear infinite diyovmspin;
        margin-right: 5px;
        vertical-align: middle;
        border: 2px solid currentcolor;
        border-right-color: transparent;
    }
    @keyframes diyovmspin {
        to {
            transform: rotate(360deg);
        }
    }
    .betable thead {
        background: #fff;
        border-bottom: 1px solid #0000000a;
        ertical-align: bottom;
    }
    .betable th {
        padding: 12px 20px;
        font-weight: normal;
        font-size: 15px;
        text-align: center;
        color: #424c55;
    }
    .betable td {
        padding: 10px;
        font-weight: normal;
        font-size: 13px;
        text-align: center;
        color: #4d5e6e;
    }
    .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 20px;
        background-color: transparent;
        border-collapse: collapse;
        border-spacing: 0;
    }
    .hizmetblok tr:nth-child(1) td {
        color: #3b6b91;
        background: #fff;
    }
    .mpanelrightcon table th {
        font-size: 16px;
        font-weight: bold;
        color: #3b6b91;
    }
    .beempty {
        padding: 10px;
    }
    .beempty > div {
        display: flex;
        justify-content: center;
        margin-bottom: 10px;
    }
    .beempty span {
        color: var(--main-color);
    }
    #clean-theme-client .hesapbilgisi:last-child {
        border-bottom: none;
    }
    .betable {
        overflow: auto;
    }
    .yuzde25 {
        display: inline-block;
        width: 35%;
        float: left;
        line-height: 37px;
    }
    .yuzde75 {
        width: 64%;
    }
   .hesapbilgisi {
        display: inline-block;
        margin: 3px;
        width: 100%;
        padding: 7px 0px;
        border-bottom: 1px solid #eee;
    }
    .hesapbilgititle {
        font-weight: 600;
        font-size: 13px;
    }
    .hesapbilgisi input, select, textarea {
        border-radius: 5px;
        width: 100%;
        background: transparent;
        border-bottom-width: 2px;
        border-bottom-color: #ccc;
        padding: 10px 0;
        border-style: none none solid;
        -webkit-transition: all .3s ease-in-out;
        -moz-transition: all .3s ease-in-out;
        -ms-transition: all .3s ease-in-out;
        -o-transition: all .3s ease-in-out;
        outline: none;
        font-size: 13px;
        color: #3b6b91;
    }
    .hesapbilgisi input[type='checkbox'] {
        width: fit-content;
    }
    .hesapbilgisi label {
        margin: 0!important;
    }
    .be-animated::before {
        content: "";
        position: absolute;
        left: 0;
        width: 0%;
        height: 100%;
        border-radius: 4px;
        background-color: #009ef7;
        z-index: -1;
        transition: 0.3s;
    }
    .be-animated:hover::before {
        width: 100%;
    }
    @media screen and (max-width: 992px) {
        .be_serverusage_realtime {
            flex-direction: column;
            padding: 0;
        }
        .be_serverusage_realtime_item {
            width: 80%;
            margin: 0px auto 15px auto;
        }
        .be_sit_row {
            width: 100%;
        }
        .be_server_process {
            flex-wrap: wrap;
        }
        .be_server_process > a {
            margin: 10px 10px;
        }
    }
</style>
<div class="be_container">
    <div class="be_serverusage_realtime">
        <div class="be_serverusage_realtime_item be_card">
            <div class="besr_header">
                <span>{{ __('stats_cpu') }}</span>
                <div>
                    <span class="text-sm">{{ __('stats_cpu_desc') }}</span>
                </div>
            </div>
            <div class="besr_percent">
                <svg viewBox="0 0 36 36" class="besr_circle_chart">
                    <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                    <path class="besr_circle" id="cpuPercentPath" stroke-dasharray="{{ $usageinfo['cpu_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['cpu_percent_color'] }}"/>
                    <text class="besr_circle_percentage" x="18" y="20.35" id="cpuPercent">{{ $usageinfo['cpu_percent'] }}%</text>
                </svg>
            </div>
            <div class="besr_usage_buttons">
                <a href="#" class="be_button be_button_c1x be-animated" data-tab="beUpgradeCPU">
                    <i class="ri-arrow-up-line"></i> Yükselt
                </a>
            </div>
            <div class="besr_usage_text" id="cpuPercentText">
                {{ $usageinfo['cpu_usage'] }} {{ $usageinfo['cpu_type'] }} / {{ $usageinfo['cpu_max'] }} MHZ
            </div>
        </div>
        <div class="be_serverusage_realtime_item be_card">
            <div class="besr_header">
                <span>{{ __('stats_ram') }}</span>
                <div>
                    <span class="text-sm">{{ __('stats_ram_desc') }}</span>
                </div>
            </div>
            <div class="besr_percent">
                <svg viewBox="0 0 36 36" class="besr_circle_chart">
                    <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                    <path class="besr_circle" id="ramPercentPath" stroke-dasharray="{{ $usageinfo['ram_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['ram_percent_color'] }}"/>
                    <text class="besr_circle_percentage" x="18" y="20.35" id="ramPercent">{{ $usageinfo['ram_percent'] }}%</text>
                </svg>
            </div>
            <div class="besr_usage_buttons">
                <a href="#" class="be_button be_button_c1x be-animated" data-tab="beUpgradeRAM">
                    <i class="ri-arrow-up-line"></i> Yükselt
                </a>
            </div>
            <div class="besr_usage_text" id="ramPercentText">
                {{ $usageinfo['ram_usage'] }} {{ $usageinfo['ram_type'] }} / {{ $usageinfo['ram_max'] }} MB
            </div>
        </div>
        <div class="be_serverusage_realtime_item be_card">
            <div class="besr_header">
                <span>{{ __('stats_disc') }}</span>
                <div>
                    <span class="text-sm">{{ __('stats_disc_desc') }}</span>
                </div>
            </div>
            <div class="besr_percent">
                <svg viewBox="0 0 36 36" class="besr_circle_chart">
                    <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                    <path class="besr_circle" id="discPercentPath" stroke-dasharray="{{ $usageinfo['disk_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['disc_percent_color'] }}"/>
                    <text class="besr_circle_percentage" x="18" y="20.35" id="discPercent">{{ $usageinfo['disk_percent'] }}%</text>
                </svg>
            </div>
            <div class="besr_usage_buttons">
                <a href="#" class="be_button be_button_c1x be-animated" data-tab="beUpgradeDISK">
                    <i class="ri-arrow-up-line"></i> Yükselt
                </a>
            </div>
            <div class="besr_usage_text" id="discPercentText">
                {{ $usageinfo['disk_usage'] }} GB / {{ $usageinfo['disk_max'] }} GB
            </div>
        </div>
        <div class="be_serverusage_realtime_item be_card">
            <div class="besr_header">
                <span>{{ __('stats_network') }}</span>
                <div>
                    <span class="text-sm">{{ __('stats_network_desc') }}</span>
                </div>
            </div>
            <div class="besr_percent">
                <svg viewBox="0 0 36 36" class="besr_circle_chart">
                    <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                    <path class="besr_circle" id="netPercentPath" stroke-dasharray="0, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: #009ef7"/>
                    <text class="besr_circle_percentage" x="18" y="20.35" id="netPercent">{{ $usageinfo['network_usage'].' '.$usageinfo['network_type'] }}</text>
                </svg>
            </div>
            <div class="besr_usage_text" id="netPercentText">
                {{ $usageinfo['network_usage'].' '.$usageinfo['network_type'] }}
            </div>
        </div>
    </div>
    <div class="be_card be_server_process">
        @if($vminfo['power'] == 1)
        <a href="#" class="be_button be_button_c1 beCallRequestx" data-method="power_action" data-data="process=stop">
            <svg width="30" height="20" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                <g>
                    <path d="M256,512C128.502,512,24.774,408.272,24.774,280.774c0-84.49,46.065-162.23,120.216-202.879 c12.006-6.577,27.057-2.18,33.633,9.816c6.577,11.997,2.182,27.055-9.814,33.633c-58.282,31.949-94.487,93.039-94.487,159.43 c0,100.177,81.5,181.677,181.677,181.677s181.677-81.5,181.677-181.677c0-66.682-36.44-127.899-95.097-159.764   c-12.022-6.532-16.475-21.573-9.943-33.595s21.572-16.475,33.595-9.944c74.631,40.542,120.992,118.444,120.992,203.304   C487.226,408.272,383.498,512,256,512z"></path>
                    <path d="M256,214.71c-13.682,0-24.774-11.092-24.774-24.774V24.774C231.226,11.092,242.318,0,256,0 c13.682,0,24.774,11.092,24.774,24.774v165.161C280.774,203.617,269.682,214.71,256,214.71z"></path>
                </g>
            </svg>
            {{ __('manage_stop') }}
        </a>
        <a href="#" class="be_button be_button_c1 beCallRequestx" data-method="power_action" data-data="process=restart">
            <svg width="30" height="20" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                <path class="be_button_c1_revese" d="M256.001,8.297C119.198,8.297,8.298,119.198,8.298,256.001s110.901,247.703,247.703,247.703  s247.704-110.901,247.704-247.703C503.703,119.198,392.804,8.297,256.001,8.297z"></path>
                <path d="M256.001,426.265c-93.884,0-170.264-76.379-170.264-170.264c0-27.739,6.786-54.819,19.502-79.03  l-24.329-16.1L184.715,108.4L177,224.456l-25.265-16.719c-6.97,15.014-10.683,31.457-10.683,48.262  c0,63.384,51.567,114.951,114.951,114.951s114.951-51.567,114.951-114.951s-51.568-114.95-114.952-114.95V85.736  c93.884,0,170.264,76.379,170.264,170.264S349.885,426.265,256.001,426.265z"></path>
                <path d="M256,512c-51.694,0-101.514-15.345-144.074-44.375c-3.786-2.582-4.761-7.744-2.179-11.53  c2.582-3.786,7.741-4.764,11.531-2.179c39.794,27.142,86.38,41.489,134.723,41.489c63.948,0,124.068-24.902,169.285-70.12  s70.121-105.338,70.121-169.285c0-62.914-24.228-122.343-68.222-167.34c-3.204-3.277-3.145-8.529,0.132-11.733  c3.278-3.204,8.53-3.144,11.732,0.133c47.043,48.117,72.951,111.666,72.951,178.941c0,68.38-26.628,132.668-74.981,181.02  C388.668,485.372,324.381,512,256,512z M90.313,448.419c-1.979,0-3.964-0.704-5.55-2.132  C30.895,397.783,0.001,328.425,0.001,256.001c0-68.381,26.628-132.668,74.98-181.02S187.62,0,256,0  c57.663,0,112.113,18.725,157.461,54.149c3.611,2.821,4.251,8.036,1.43,11.647c-2.82,3.612-8.036,4.25-11.646,1.43  C360.844,34.102,309.925,16.594,256,16.594c-63.948,0-124.067,24.902-169.285,70.12s-70.12,105.338-70.12,169.286  c0,67.73,28.894,132.592,79.272,177.956c3.405,3.065,3.679,8.313,0.614,11.718C94.842,447.493,92.582,448.419,90.313,448.419z   M256,434.561c-98.459,0-178.561-80.102-178.561-178.561c0-26.244,5.894-52.416,17.102-76.16l-18.21-12.051  c-2.466-1.632-3.876-4.451-3.705-7.402c0.171-2.95,1.902-5.588,4.54-6.921l103.805-52.471c2.661-1.345,5.838-1.158,8.321,0.486  c2.486,1.644,3.897,4.496,3.7,7.47l-7.715,116.056c-0.196,2.95-1.947,5.572-4.595,6.884c-2.651,1.313-5.796,1.115-8.262-0.516  l-16.856-11.155c-4.13,11.492-6.217,23.486-6.217,35.779c0,58.808,47.844,106.654,106.654,106.654s106.654-47.845,106.654-106.654  S314.809,149.347,256,149.347c-4.583,0-8.297-3.715-8.297-8.297V85.736c0-4.582,3.714-8.297,8.297-8.297  c98.459,0,178.561,80.102,178.561,178.561S354.459,434.561,256,434.561z M97.398,161.832l12.419,8.219  c3.551,2.35,4.747,7.007,2.767,10.777c-12.136,23.108-18.551,49.102-18.551,75.172c0,89.308,72.659,161.967,161.967,161.967  s161.967-72.658,161.967-161.967c0-86.528-68.197-157.427-153.67-161.757v38.786C328.403,137.311,379.248,190.83,379.248,256  c0,67.958-55.289,123.248-123.248,123.248S132.752,323.959,132.752,256c0-17.969,3.854-35.382,11.455-51.757  c1.018-2.192,2.94-3.831,5.267-4.49c2.325-0.658,4.822-0.27,6.838,1.064l13.355,8.837l5.802-87.286L97.398,161.832z"></path>
            </svg>
            {{ __('manage_restart') }}
        </a>
        @else
        <a href="#" class="be_button be_button_c1 beCallRequestx" data-method="power_action" data-data="process=start">
            <svg width="30" height="20" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                <g>
                    <path d="M256,512C128.502,512,24.774,408.272,24.774,280.774c0-84.49,46.065-162.23,120.216-202.879 c12.006-6.577,27.057-2.18,33.633,9.816c6.577,11.997,2.182,27.055-9.814,33.633c-58.282,31.949-94.487,93.039-94.487,159.43 c0,100.177,81.5,181.677,181.677,181.677s181.677-81.5,181.677-181.677c0-66.682-36.44-127.899-95.097-159.764   c-12.022-6.532-16.475-21.573-9.943-33.595s21.572-16.475,33.595-9.944c74.631,40.542,120.992,118.444,120.992,203.304   C487.226,408.272,383.498,512,256,512z"></path>
                    <path d="M256,214.71c-13.682,0-24.774-11.092-24.774-24.774V24.774C231.226,11.092,242.318,0,256,0 c13.682,0,24.774,11.092,24.774,24.774v165.161C280.774,203.617,269.682,214.71,256,214.71z"></path>
                </g>
            </svg>
            {{ __('manage_start') }}
        </a>
        @endif
        <a href="#" class="be_button be_button_c1" data-tab="Password">
            <svg width="30" height="20" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                <path d="M297.646,297.89l-83.538-83.538L13.812,414.65l-3.654,65.995  c-0.663,11.971,9.226,21.86,21.197,21.197l65.994-3.655l31.896-31.896v-32.649h32.649l36.391-36.391v-32.649h32.649L297.646,297.89z  "></path>
                <path style="opacity:0.1;enable-background:new;" d="M201.105,310.894c14.301,14.301,30.011,26.666,46.64,36.898l49.901-49.901  l-83.538-83.538l-49.956,49.956C174.386,280.885,186.763,296.552,201.105,310.894z"></path>
                <path d="M229.729,282.271c-70.682-70.682-79.294-172.804-19.608-232.491S371.93-1.293,442.612,69.388  s79.295,172.804,19.608,232.491S300.411,352.953,229.729,282.271z"></path>
                <path d="M258.352,253.648c-54.632-54.632-63.244-131.609-19.608-175.245s120.614-35.024,175.245,19.608  s63.244,131.609,19.608,175.245S312.983,308.28,258.352,253.648z"></path>
                <path style="opacity:0.1;enable-background:new;" d="M265.73,105.389c39.97-39.97,107.902-36.073,161.022,6.845  c-3.937-4.872-8.173-9.633-12.763-14.223C359.357,43.379,282.38,34.767,238.744,78.403s-35.024,120.614,19.608,175.245  c4.59,4.59,9.349,8.827,14.223,12.763C229.656,213.291,225.759,145.359,265.73,105.389z"></path>
                <polygon class="be_button_c1_revese" points="392.003,119.998 374.909,170.403 406.743,213.059 353.522,212.379 322.79,255.836   306.991,205.009 256.164,189.21 299.621,158.478 298.941,105.258 341.598,137.091 "></polygon>
                <path d="M326.787,41.767c-37.259-5.127-71.067,5.346-95.206,29.485c-47.648,47.649-39.035,130.913,19.608,189.556  c33.202,33.202,74.288,50.367,112.341,50.364c29.16-0.001,56.544-10.085,77.218-30.756c47.648-47.649,39.035-130.913-19.609-189.557  c-15.432-15.431-32.791-27.666-51.59-36.364c-5.076-2.348-11.087-0.136-13.434,4.936c-2.346,5.073-0.138,11.087,4.934,13.434  c16.634,7.695,32.036,18.565,45.779,32.306c50.62,50.62,59.231,121.31,19.609,160.935c-39.623,39.622-110.314,31.011-160.933-19.608  s-59.234-121.31-19.611-160.933c19.553-19.554,47.309-27.987,78.134-23.746c5.547,0.765,10.643-3.109,11.404-8.646  C336.193,47.634,332.323,42.528,326.787,41.767z"></path>
                <path d="M399.152,112.845c-2.726-2.723-6.76-3.666-10.406-2.429l-45.369,15.385l-38.393-28.65  c-3.087-2.303-7.212-2.655-10.647-0.907c-3.431,1.749-5.574,5.295-5.524,9.147l0.613,47.901l-39.112,27.661  c-3.145,2.224-4.755,6.041-4.152,9.846c0.602,3.805,3.313,6.937,6.991,8.081l45.747,14.22l14.219,45.745  c1.144,3.68,4.276,6.389,8.081,6.992c0.529,0.084,1.058,0.124,1.584,0.124c3.252,0,6.346-1.569,8.26-4.276l27.661-39.112  l47.901,0.613c3.831,0.078,7.397-2.093,9.146-5.525c1.749-3.431,1.397-7.56-0.907-10.646l-28.65-38.394l15.383-45.367  C402.817,119.604,401.876,115.569,399.152,112.845z M386.362,202.683l-32.718-0.418c-3.302-0.07-6.47,1.556-8.391,4.276  l-18.893,26.715l-9.712-31.246c-0.988-3.18-3.48-5.671-6.66-6.66l-31.246-9.712l26.715-18.893c2.72-1.923,4.319-5.061,4.276-8.393  l-0.418-32.718l26.224,19.569c2.669,1.992,6.145,2.545,9.302,1.473l30.988-10.508l-10.507,30.987  c-1.07,3.155-0.52,6.633,1.473,9.302L386.362,202.683z"></path>
                <path d="M449.76,62.237C413.888,26.365,368.901,4.48,323.085,0.617C276.643-3.304,233.969,11.62,202.958,42.63  c-31.01,31.01-45.93,73.672-42.013,120.128c2.024,23.996,9,47.762,20.331,70.115L87.94,326.209c-3.952,3.952-3.952,10.36,0,14.311  c3.953,3.952,10.36,3.952,14.312,0c0,0,89.425-89.425,89.429-89.43c-2.131,2.187,19.188,25.796,21.892,28.824  c0.352,0.394,0.708,0.784,1.062,1.175c0.31,0.343,0.618,0.688,0.931,1.03L54.159,443.527c-3.952,3.952-3.952,10.36,0,14.311  c1.977,1.977,4.566,2.964,7.157,2.964c2.589,0,5.18-0.988,7.157-2.964l161.403-161.403c0.425,0.391,0.858,0.769,1.286,1.156  c0.297,0.269,0.595,0.537,0.893,0.803c9.168,8.21,18.808,15.555,28.818,21.958l-34.137,34.136h-28.458  c-5.59,0-10.12,4.531-10.12,10.12v28.457l-30.462,30.462h-28.457c-5.59,0-10.12,4.531-10.12,10.12v28.457L92.922,488.3  l-62.134,3.441c-2.871,0.167-5.583-0.874-7.619-2.912c-2.039-2.037-3.072-4.744-2.913-7.621l3.441-62.134l49.935-49.935  c3.952-3.952,3.952-10.36,0-14.311c-3.953-3.952-10.36-3.952-14.312,0l-52.671,52.67c-1.761,1.761-2.811,4.11-2.948,6.597  l-3.654,65.995c-0.476,8.576,2.735,16.978,8.808,23.051c5.681,5.679,13.396,8.855,21.386,8.855c0.555,0,1.109-0.015,1.666-0.046  l65.994-3.654c2.487-0.138,4.835-1.187,6.597-2.948l31.896-31.896c1.897-1.898,2.963-4.472,2.963-7.155V443.77h22.528  c2.684,0,5.257-1.066,7.157-2.964l36.391-36.391c1.897-1.897,2.963-4.472,2.963-7.155V374.73h22.529  c2.684,0,5.257-1.066,7.157-2.964l41.004-41.002c24.71,12.542,51.115,19.693,77.767,20.756c0.138,0.005,0.274,0.008,0.41,0.008  c5.404,0,9.888-4.269,10.105-9.716c0.223-5.585-4.125-10.292-9.708-10.515c-25.554-1.019-50.933-8.363-74.528-21.269  c-0.309-0.22-0.629-0.424-0.965-0.61c-24.965-13.813-46.984-33.244-64.197-55.969c-20.26-26.757-34.02-58.782-36.853-92.39  c-3.408-40.417,9.432-77.392,36.157-104.116c26.724-26.724,63.704-39.567,104.116-36.156c41.058,3.462,81.565,23.266,114.061,55.764  c66.67,66.67,75.283,162.505,19.608,218.18c-16.915,16.915-37.537,28.167-61.296,33.44c-5.457,1.21-8.899,6.616-7.687,12.072  c1.21,5.457,6.621,8.901,12.072,7.687c27.188-6.035,51.817-19.481,71.223-38.887C533.067,245.341,524.454,136.931,449.76,62.237z"></path>
            </svg>
            {{ __('manage_password') }}
        </a>
        <a href="#" class="be_button be_button_c1" data-tab="Network">
            <svg width="30" height="20" viewBox="0 0 392.598 392.598" xmlns="http://www.w3.org/2000/svg">
                <path d="M196.299,115.006c-44.8,0-81.261,36.461-81.261,81.261s36.461,81.261,81.261,81.261  s81.261-36.461,81.261-81.261S241.099,115.006,196.299,115.006z"></path>
                <path class="be_button_c1_revese" d="M295.079,59.669c0,20.881,17.002,37.883,37.883,37.883s37.883-17.002,37.883-37.883  s-17.002-37.883-37.883-37.883C312.081,21.786,295.079,38.788,295.079,59.669z"></path>
                <g>
                    <path class="be_button_c1_revese" d="M332.897,295.046c-20.881,0-37.883,17.002-37.883,37.883s17.002,37.883,37.883,37.883   c20.881,0,37.883-17.002,37.883-37.883S353.778,295.046,332.897,295.046z"></path>
                    <path class="be_button_c1_revese" d="M46.836,21.786c-13.834,0-25.018,11.184-25.018,25.018s11.313,25.018,25.018,25.018   s25.018-11.184,25.018-25.018S60.671,21.786,46.836,21.786z"></path>
                </g>
                <path class="be_button_c1_revese" d="M68.622,298.861c-13.834,0-25.018,11.184-25.018,25.018c0,13.834,11.184,25.018,25.018,25.018  s25.018-11.184,25.018-25.018C93.705,310.109,82.457,298.861,68.622,298.861z"></path>
                <path d="M332.897,273.261c-12.541,0-24.113,3.879-33.745,10.537l-22.82-22.885  c14.287-17.713,22.949-40.21,22.949-64.646s-8.663-46.998-22.949-64.646l22.82-22.82c9.568,6.659,21.269,10.537,33.745,10.537  c32.905,0,59.669-26.764,59.669-59.669S365.802,0,332.897,0s-59.669,26.764-59.669,59.669c0,12.541,3.879,24.113,10.537,33.745  l-22.82,22.82c-17.713-14.287-40.21-22.949-64.646-22.949s-46.998,8.663-64.646,22.949L86.788,71.37  c4.396-7.111,6.982-15.451,6.982-24.436C93.77,21.075,72.76,0,46.966,0S0.032,21.01,0.032,46.804s21.01,46.804,46.804,46.804  c8.986,0,17.325-2.521,24.436-6.982l44.865,44.994c-14.287,17.713-22.95,40.21-22.95,64.646c0,25.018,9.051,48.032,23.984,65.939  l-23.273,22.303c-7.24-4.719-15.903-7.499-25.277-7.499c-25.794,0-46.804,21.01-46.804,46.804s21.01,46.804,46.804,46.804  s46.804-21.01,46.804-46.804c0-8.663-2.392-16.679-6.465-23.661l23.855-22.885c17.519,13.77,39.499,22.044,63.418,22.044  c24.501,0,46.998-8.663,64.646-22.949l22.82,22.82c-6.659,9.568-10.537,21.269-10.537,33.745c0,32.905,26.764,59.669,59.669,59.669  s59.669-26.764,59.669-59.669C392.566,299.96,365.867,273.261,332.897,273.261z M370.78,59.669  c0,20.881-17.002,37.883-37.883,37.883s-37.883-17.002-37.883-37.883s17.002-37.883,37.883-37.883  C353.778,21.786,370.78,38.788,370.78,59.669z M46.836,71.887c-13.834,0-25.018-11.184-25.018-25.018s11.184-25.018,25.018-25.018  s25.018,11.313,25.018,25.018S60.671,71.887,46.836,71.887z M68.622,348.962c-13.834,0-25.018-11.184-25.018-25.018  c0-13.834,11.184-25.018,25.018-25.018s25.018,11.184,25.018,25.018C93.705,337.778,82.457,348.962,68.622,348.962z   M196.299,277.527c-44.8,0-81.261-36.461-81.261-81.261s36.461-81.261,81.261-81.261s81.261,36.461,81.261,81.261  S241.099,277.527,196.299,277.527z M332.897,370.747c-20.881,0-37.883-17.002-37.883-37.883s17.002-37.883,37.883-37.883  c20.881,0,37.883,17.002,37.883,37.883S353.778,370.747,332.897,370.747z"></path>
                <path class="be_button_c1_revese" d="M196.299,255.677c-32.776,0-59.41-26.634-59.41-59.41s26.634-59.41,59.41-59.41  s59.41,26.634,59.41,59.41S229.075,255.677,196.299,255.677z"></path>
            </svg>
            {{ __('manage_ip') }}
        </a>
        <a href="#" class="be_button be_button_c1" data-tab="Snapshot">
            <svg width="30" height="20" viewBox="0 -4.29 70 70" xmlns="http://www.w3.org/2000/svg">
                <path d="m -108.53016,532.97394 c -5.32197,-0.83886 -9.58346,-4.77549 -10.93852,-10.10465 -0.39406,-1.54976 -0.36729,-4.76371 0.0519,-6.22711 0.9639,-3.3653 2.98461,-5.91567 6.01087,-7.58639 l 0.68749,-0.37955 -0.0446,-1.18778 c -0.11958,-3.18107 1.08589,-6.90628 3.08708,-9.5399 1.87354,-2.46562 4.70362,-4.47264 7.59022,-5.38279 4.637359,-1.46217 9.363209,-0.81206 13.498389,1.85689 0.49155,0.31726 1.57472,1.26541 2.40703,2.107 l 1.51329,1.53016 0.75544,-0.38282 c 3.10468,-1.57331 6.99572,-1.66495 10.14094,-0.23885 4.146842,1.88027 6.908112,6.04621 6.908112,10.42231 l 0,1.09011 0.93429,0.55505 c 4.02201,2.38944 6.2783,7.10788 5.66711,11.85127 -0.40088,3.11104 -1.64386,5.65068 -3.84098,7.8478 -1.76977,1.76977 -3.6389,2.84066 -6.18155,3.54162 l -1.322582,0.36461 -17.87485,0.024 c -14.399069,0.0194 -18.103159,-0.0119 -19.048999,-0.16103 z m 19.135679,-6.04905 c 3.47903,-0.70207 6.64772,-3.28215 8.21571,-6.68959 0.9022,-1.96061 1.04429,-2.65543 1.03598,-5.06594 -0.007,-1.95288 -0.0395,-2.22904 -0.39217,-3.29997 -0.75638,-2.29714 -1.77044,-3.91495 -3.3991,-5.42283 -2.28863,-2.11893 -4.91971,-3.12636 -8.15957,-3.12429 -4.72476,0.003 -8.767029,2.59616 -10.785049,6.91865 -0.74563,1.59709 -0.97102,2.53923 -1.06482,4.45085 -0.16647,3.39283 0.93789,6.38263 3.2421,8.77722 3.002649,3.12044 6.966149,4.33186 11.306919,3.4559 z m -3.18808,-1.55919 c -0.66458,-0.53814 -0.23984,-1.67141 0.62643,-1.67141 0.55019,0 0.93957,0.40849 0.93957,0.98569 0,0.49491 -0.44451,0.93929 -0.93957,0.93929 -0.17231,0 -0.4542,-0.11411 -0.62643,-0.25357 z m 3.6436,-4.98083 c -0.25846,-0.0751 -1.25117,-0.92214 -2.5781,-2.19977 l -2.15781,-2.07763 0,-3.12631 c 0,-3.06457 0.006,-3.13204 0.30937,-3.41612 0.49087,-0.45983 1.01767,-0.60664 1.60718,-0.4479 1.0017,0.26973 1.03446,0.37537 1.08182,3.4882 l 0.0421,2.77027 1.63127,1.65117 c 1.69872,1.71944 1.96573,2.16476 1.65083,2.75316 -0.14253,0.26631 -0.93133,0.78784 -1.11844,0.73947 -0.0264,-0.007 -0.2371,-0.0674 -0.46826,-0.13454 z m -13.193689,-4.52979 c -0.35481,-0.39206 -0.32382,-1.08168 0.0627,-1.39464 0.4305,-0.3486 0.91868,-0.31757 1.32017,0.0839 0.41231,0.4123 0.42676,0.74942 0.0525,1.22519 -0.35656,0.4533 -1.06436,0.49547 -1.43536,0.0855 z m 18.917669,-0.0855 c -0.15674,-0.19926 -0.28498,-0.46935 -0.28498,-0.6002 0,-0.13085 0.12824,-0.40094 0.28498,-0.6002 0.54568,-0.69372 1.68584,-0.30349 1.68584,0.577 0,0.94618 -1.10928,1.35638 -1.68584,0.6234 z m -9.43025,-9.4019 c -0.35481,-0.39205 -0.32382,-1.08168 0.0627,-1.39464 0.64492,-0.52222 1.566,-0.1189 1.566,0.68572 0,0.5772 -0.38938,0.98569 -0.93957,0.98569 -0.26494,0 -0.53781,-0.10959 -0.6891,-0.27677 z m 32.743632,4.22285 c -0.75557,-1.20405 -2.34881,-3.01397 -3.42243,-3.88789 -0.43596,-0.35486 -0.81729,-0.77609 -0.84742,-0.93606 -0.78009,-4.14208 -2.34071,-7.1868 -4.98118,-9.71804 -2.953742,-2.83155 -6.266872,-4.31745 -10.454042,-4.68851 l -1.81291,-0.16065 0.3885,-0.56177 c 0.55447,-0.80175 2.13804,-2.28993 3.07344,-2.8883 1.70981,-1.09375 4.12144,-1.88459 6.36766,-2.08814 l 1.008562,-0.0914 0.0376,2.47928 0.0376,2.47928 4.43618,-3.76279 4.43616,-3.7628 -4.43616,-3.80691 -4.43618,-3.80691 -0.0688,2.531 -0.0688,2.531 -1.306242,0.10746 c -4.601,0.37852 -9.07733,2.34697 -12.10639,5.32374 -1.22023,1.19917 -1.99268,2.21909 -2.76479,3.65053 -0.30392,0.56344 -0.5936,1.02311 -0.64375,1.02149 -0.0502,-0.002 -0.5243,-0.28469 -1.05367,-0.62906 -1.93748,-1.26035 -4.61163,-2.35304 -7.08119,-2.89346 -0.93421,-0.20443 -1.75222,-0.25575 -4.07639,-0.25575 l -2.907659,0 0.0671,-0.48125 c 0.45171,-3.23763 2.530899,-6.43984 5.299379,-8.16172 3.52782,-2.19415 7.81844,-2.44275 11.3995,-0.66048 l 1.05081,0.52298 1.06192,-1.15099 c 1.40417,-1.52195 2.60401,-2.47034 4.19265,-3.31399 1.46927,-0.78026 2.98243,-1.32285 4.52541,-1.62274 1.36711,-0.2657 4.175482,-0.25875 5.595892,0.0139 4.72201,0.90623 8.7259,3.85671 10.87875,8.01661 1.21319,2.34421 1.68365,4.18401 1.76604,6.90647 l 0.052,1.71874 0.882,0.49597 c 2.78512,1.56614 4.62484,3.72529 5.61103,6.58522 0.43494,1.26139 0.45051,1.38177 0.45327,3.50622 0.003,2.59915 -0.16806,3.41541 -1.15528,5.49995 -1.44703,3.05545 -4.06688,5.4044 -7.30619,6.5507 l -1.07089,0.37896 -0.62115,-0.98985 z" fill="#00bcf2" transform="translate(119.748 -471.713)"></path>
            </svg>
            {{ __('manage_snapshot') }}
        </a>
        <a href="#" class="be_button be_button_c1" data-tab="Format">
            <svg width="30" height="20" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                <path class="be_button_c1_revese" d="M256.001,8.297C119.198,8.297,8.298,119.198,8.298,256.001s110.901,247.703,247.703,247.703  s247.704-110.901,247.704-247.703C503.703,119.198,392.804,8.297,256.001,8.297z"></path>
                <path d="M256.001,426.265c-93.884,0-170.264-76.379-170.264-170.264c0-27.739,6.786-54.819,19.502-79.03  l-24.329-16.1L184.715,108.4L177,224.456l-25.265-16.719c-6.97,15.014-10.683,31.457-10.683,48.262  c0,63.384,51.567,114.951,114.951,114.951s114.951-51.567,114.951-114.951s-51.568-114.95-114.952-114.95V85.736  c93.884,0,170.264,76.379,170.264,170.264S349.885,426.265,256.001,426.265z"></path>
                <path d="M256,512c-51.694,0-101.514-15.345-144.074-44.375c-3.786-2.582-4.761-7.744-2.179-11.53  c2.582-3.786,7.741-4.764,11.531-2.179c39.794,27.142,86.38,41.489,134.723,41.489c63.948,0,124.068-24.902,169.285-70.12  s70.121-105.338,70.121-169.285c0-62.914-24.228-122.343-68.222-167.34c-3.204-3.277-3.145-8.529,0.132-11.733  c3.278-3.204,8.53-3.144,11.732,0.133c47.043,48.117,72.951,111.666,72.951,178.941c0,68.38-26.628,132.668-74.981,181.02  C388.668,485.372,324.381,512,256,512z M90.313,448.419c-1.979,0-3.964-0.704-5.55-2.132  C30.895,397.783,0.001,328.425,0.001,256.001c0-68.381,26.628-132.668,74.98-181.02S187.62,0,256,0  c57.663,0,112.113,18.725,157.461,54.149c3.611,2.821,4.251,8.036,1.43,11.647c-2.82,3.612-8.036,4.25-11.646,1.43  C360.844,34.102,309.925,16.594,256,16.594c-63.948,0-124.067,24.902-169.285,70.12s-70.12,105.338-70.12,169.286  c0,67.73,28.894,132.592,79.272,177.956c3.405,3.065,3.679,8.313,0.614,11.718C94.842,447.493,92.582,448.419,90.313,448.419z   M256,434.561c-98.459,0-178.561-80.102-178.561-178.561c0-26.244,5.894-52.416,17.102-76.16l-18.21-12.051  c-2.466-1.632-3.876-4.451-3.705-7.402c0.171-2.95,1.902-5.588,4.54-6.921l103.805-52.471c2.661-1.345,5.838-1.158,8.321,0.486  c2.486,1.644,3.897,4.496,3.7,7.47l-7.715,116.056c-0.196,2.95-1.947,5.572-4.595,6.884c-2.651,1.313-5.796,1.115-8.262-0.516  l-16.856-11.155c-4.13,11.492-6.217,23.486-6.217,35.779c0,58.808,47.844,106.654,106.654,106.654s106.654-47.845,106.654-106.654  S314.809,149.347,256,149.347c-4.583,0-8.297-3.715-8.297-8.297V85.736c0-4.582,3.714-8.297,8.297-8.297  c98.459,0,178.561,80.102,178.561,178.561S354.459,434.561,256,434.561z M97.398,161.832l12.419,8.219  c3.551,2.35,4.747,7.007,2.767,10.777c-12.136,23.108-18.551,49.102-18.551,75.172c0,89.308,72.659,161.967,161.967,161.967  s161.967-72.658,161.967-161.967c0-86.528-68.197-157.427-153.67-161.757v38.786C328.403,137.311,379.248,190.83,379.248,256  c0,67.958-55.289,123.248-123.248,123.248S132.752,323.959,132.752,256c0-17.969,3.854-35.382,11.455-51.757  c1.018-2.192,2.94-3.831,5.267-4.49c2.325-0.658,4.822-0.27,6.838,1.064l13.355,8.837l5.802-87.286L97.398,161.832z"></path>
            </svg>
            {{ __('manage_format') }}
        </a>
        <a href="#" class="be_button be_button_c1" data-tab="Logs">
            <svg width="30" height="20" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg">
                <path d="M7.8125 3C7.335938 3.089844 6.992188 3.511719 7 4L7 31L3 31C2.96875 31 2.9375 31 2.90625 31C2.390625 31.046875 1.996094 31.480469 2 32L2 36C2 36.550781 2.449219 37 3 37L6 37L6 44.5C6 45.867188 7.132813 47 8.5 47C9.867188 47 11 45.867188 11 44.5L11 37L39 37L39 44.5C39 45.867188 40.132813 47 41.5 47C42.867188 47 44 45.867188 44 44.5L44 37L47 37C47.550781 37 48 36.550781 48 36L48 32C48 31.449219 47.550781 31 47 31L43.875 31C43.902344 30.867188 43.902344 30.726563 43.875 30.59375L38.8125 9.1875C38.703125 8.671875 38.210938 8.328125 37.6875 8.40625C37.667969 8.414063 37.644531 8.425781 37.625 8.4375L32.75 9.59375C32.378906 9.679688 32.085938 9.972656 32 10.34375L32 10C32 9.449219 31.550781 9 31 9L25 9L25 4C25 3.449219 24.550781 3 24 3L16.0625 3C16.042969 3 16.019531 3 16 3L8 3C7.96875 3 7.9375 3 7.90625 3C7.875 3 7.84375 3 7.8125 3 Z M 9 5L15 5L15 31L9 31 Z M 17 5L23 5L23 9.90625C23 9.9375 23 9.96875 23 10L23 31L17 31 Z M 10.71875 7C10.167969 7.078125 9.78125 7.589844 9.859375 8.140625C9.9375 8.691406 10.449219 9.078125 11 9L13 9C13.359375 9.003906 13.695313 8.816406 13.878906 8.503906C14.058594 8.191406 14.058594 7.808594 13.878906 7.496094C13.695313 7.183594 13.359375 6.996094 13 7L11 7C10.96875 7 10.9375 7 10.90625 7C10.875 7 10.84375 7 10.8125 7C10.78125 7 10.75 7 10.71875 7 Z M 18.71875 7C18.167969 7.078125 17.78125 7.589844 17.859375 8.140625C17.9375 8.691406 18.449219 9.078125 19 9L21 9C21.359375 9.003906 21.695313 8.816406 21.878906 8.503906C22.058594 8.191406 22.058594 7.808594 21.878906 7.496094C21.695313 7.183594 21.359375 6.996094 21 7L19 7C18.96875 7 18.9375 7 18.90625 7C18.875 7 18.84375 7 18.8125 7C18.78125 7 18.75 7 18.71875 7 Z M 37.09375 10.59375L37.71875 13.28125C37.507813 12.902344 37.082031 12.703125 36.65625 12.78125C36.625 12.789063 36.59375 12.800781 36.5625 12.8125L35.59375 13.03125C35.1875 13.101563 34.867188 13.410156 34.78125 13.8125L34.1875 11.28125 Z M 32 10.78125L36.78125 31L32 31 Z M 25 11L30 11L30 31L25 31 Z M 26.71875 13C26.167969 13.078125 25.78125 13.589844 25.859375 14.140625C25.9375 14.691406 26.449219 15.078125 27 15L28 15C28.359375 15.003906 28.695313 14.816406 28.878906 14.503906C29.058594 14.191406 29.058594 13.808594 28.878906 13.496094C28.695313 13.183594 28.359375 12.996094 28 13L27 13C26.96875 13 26.9375 13 26.90625 13C26.875 13 26.84375 13 26.8125 13C26.78125 13 26.75 13 26.71875 13 Z M 37.84375 13.84375L40.875 26.6875C40.652344 26.445313 40.324219 26.332031 40 26.375C39.945313 26.382813 39.894531 26.390625 39.84375 26.40625C39.824219 26.414063 39.800781 26.425781 39.78125 26.4375L38.8125 26.65625C38.40625 26.726563 38.085938 27.035156 38 27.4375L35 14.6875C35.265625 14.984375 35.683594 15.09375 36.0625 14.96875L37.03125 14.75C37.476563 14.664063 37.808594 14.292969 37.84375 13.84375 Z M 10.71875 27C10.167969 27.078125 9.78125 27.589844 9.859375 28.140625C9.9375 28.691406 10.449219 29.078125 11 29L13 29C13.359375 29.003906 13.695313 28.816406 13.878906 28.503906C14.058594 28.191406 14.058594 27.808594 13.878906 27.496094C13.695313 27.183594 13.359375 26.996094 13 27L11 27C10.96875 27 10.9375 27 10.90625 27C10.875 27 10.84375 27 10.8125 27C10.78125 27 10.75 27 10.71875 27 Z M 18.71875 27C18.167969 27.078125 17.78125 27.589844 17.859375 28.140625C17.9375 28.691406 18.449219 29.078125 19 29L21 29C21.359375 29.003906 21.695313 28.816406 21.878906 28.503906C22.058594 28.191406 22.058594 27.808594 21.878906 27.496094C21.695313 27.183594 21.359375 26.996094 21 27L19 27C18.96875 27 18.9375 27 18.90625 27C18.875 27 18.84375 27 18.8125 27C18.78125 27 18.75 27 18.71875 27 Z M 26.71875 27C26.167969 27.078125 25.78125 27.589844 25.859375 28.140625C25.9375 28.691406 26.449219 29.078125 27 29L28 29C28.359375 29.003906 28.695313 28.816406 28.878906 28.503906C29.058594 28.191406 29.058594 27.808594 28.878906 27.496094C28.695313 27.183594 28.359375 26.996094 28 27L27 27C26.96875 27 26.9375 27 26.90625 27C26.875 27 26.84375 27 26.8125 27C26.78125 27 26.75 27 26.71875 27 Z M 41.09375 27.625L41.6875 30.0625L38.78125 30.75L38.21875 28.3125C38.484375 28.609375 38.902344 28.71875 39.28125 28.59375L40.25 28.375C40.65625 28.320313 40.992188 28.023438 41.09375 27.625 Z M 4 33L46 33L46 35L4 35 Z M 8 37L9 37L9 44.5C9 44.785156 8.785156 45 8.5 45C8.214844 45 8 44.785156 8 44.5 Z M 41 37L42 37L42 44.5C42 44.785156 41.785156 45 41.5 45C41.214844 45 41 44.785156 41 44.5Z"></path>
            </svg>
            {{ __('manage_logs') }}
        </a>
    </div>
    <div class="be_tabs">
        <div class="be_tab" id="beTabPassword">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('passwordpage_name') }}</span>
                    </div>
                </div>
                <div class="card-content">
                    <form id="password_changeForm">
                        <div class="row my-3">
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password">{{ __('passwordpage_serverpass') }}</label>
                                    <div class="form-input-area">
                                        <input type="text" class="form-control set-password" name="password" id="Password">
                                        <button class="btn beCreatePassword btn-primary" data-area=".set-password">{{ __('passwordpage_randompass') }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label class="text-sm"><span class="text-danger">*</span>{{ __('passwordpage_infotext') }}</label>
                                </div>
                            </div>
                            <div class="col-12 row-center row-flex">
                                <a href="#" class="btn btn-primary beCallRequestx" data-method="password_change" data-form="password_change">
                                    {{ __('passwordpage_updatebutton') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="be_tab" id="beTabNetwork">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_ip') }}</span>
                    </div>
                    <div>
                        <a href="#" class="btn btn-primary btn-sm be_button" data-alt-tab="AddrDns"><i class="ri-add-line"></i> {{ __('ippage_create_rdns') }}</a>
                    </div>
                </div>
                <div class="card-content">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th>IPv4</th> 
                                <th>Gateway</th> 
                                <th>Netmask</th>
                                <th>Mac</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($iplist as $ip)
                            <tr>
                                <td>{{ $ip['iaddress'] }}</td>
                                <td>{{ $ip['igateway'] }}</td>
                                <td>{{ $ip['inetmask'] }}</td>
                                <td>{{ $ip['imac'] }}</td>
                                <td>
                                    @if($rdnsiplist[$ip['iid']] == 1)
                                    <a href="#" class="btn btn-primary be_button" data-alt-tab="ShowrDns{{ $ip['iid'] }}">{{ __('ippage_rdns_managament') }}</a>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="be_tab" id="beTabAddrDns">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('ippage_rdns_create_name') }}</span>
                    </div>
                    <div>
                        <a href="#" class="btn btn-primary btn-sm be_button" data-alt-tab="Network"><i class="ri-add-line"></i> {{ __('global_return_back') }}</a>
                    </div>
                </div>
                <div class="card-content">
                    <form id="rnds_createForm">
                        <div class="row my-3">
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('passwordpage_serverpass') }}</label>
                                    <select class="form-control" name="iid">
                                        @foreach($iplist as $ip)
                                        <option value="{{ $ip['iid'] }}">{{ $ip['iaddress'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_type') }}</label>
                                    <select class="form-control" name="type">
                                    <option value="PTR">PTR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_content') }}</label>
                                    <input type="text" class="form-control set-password" name="dns" required="required">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_priority') }}</label>
                                    <input type="number" class="form-control set-password" name="priority" required="required" value="0">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_ttl') }}</label>
                                    <input type="number" class="form-control set-password" name="ttl" required="required" value="3600">
                                </div>
                            </div>
                            <div class="col-12 row-center row-flex">
                                <a href="#" class="btn btn-primary beCallRequestx" data-method="rnds_create" data-form="rnds_create">
                                    {{ __('global_create') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @foreach($iplist as $ip)
        <div class="be_tab" id="beTabShowrDns{{ $ip['iid'] }}">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_ip') }}</span>
                    </div>
                    <div>
                        <a href="#" class="btn btn-primary btn-sm be_button" data-alt-tab="Network"><i class="ri-add-line"></i> {{ __('global_return_back') }}</a>
                    </div>
                </div>
                <div class="card-content">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th>Süreç</th>
                                <th>{{ __('ippage_rdns_ip') }}</th>
                                <th>{{ __('ippage_rdns_type') }}</th>
                                <th>{{ __('ippage_rdns_content') }}</th>
                                <th>{{ __('ippage_rdns_priority') }}</th>
                                <th>{{ __('ippage_rdns_ttl') }}</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rdnslist as $rdns)
                            @if($rdns['iid'] == $ip['iid'])
                            <tr>
                                <td>
                                    <div class="row-flex row-center">
                                        <a href="#" class="btn btn-sm btn-primary {{ $rdnsstatuslist[$rdns['rstatus']]['color'] }}">{{ $rdnsstatuslist[$rdns['rstatus']]['name'] }}</a>
                                    </div>
                                </td>
                                <td>{{ $ip['iaddress'] }}</td>
                                <td>{{ $rdns['rtype'] }}</td>
                                <td>{{ $rdns['rdns'] }}</td>
                                <td>{{ $rdns['rpriority'] }}</td>
                                <td>{{ $rdns['rttl'] }}</td>
                                <td>
                                    <div class="row-flex row-end row-align">
                                        <a href="#" class="btn btn-primary btn-sm be_button" data-tab="EditrDns{{ $rdns['rid'] }}">{{ __('global_edit') }}</a>
                                        <a href="#" class="btn btn-warning btn-sm ml-1 beCallRequestx" data-method="rnds_delete" data-data="rid={{ $rdns['rid'] }}">{{ __('global_delete') }}</a>
                                    </div>
                                </td>
                            </tr>
                            @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endforeach
        @foreach($rdnslist as $rdns)
         <div class="be_tab" id="beTabEditrDns{{ $rdns['rid'] }}">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('ippage_rdns_create_name') }}</span>
                    </div>
                    <div>
                        <a href="#" class="btn btn-primary btn-sm be_button" data-alt-tab="Network"><i class="ri-add-line"></i> {{ __('global_return_back') }}</a>
                    </div>
                </div>
                <div class="card-content">
                    <form id="rnds_edit{{ $rdns['rid'] }}Form">
                        <input type="hidden" name="rid" value="{{ $rdns['rid'] }}">
                        <div class="row my-3">
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_ip') }}</label>
                                    <select class="form-control" name="iid">
                                    @foreach($iplist as $ip)
                                        @if($rdns['iid'] == $ip['iid'])
                                        <option value="{{ $ip['iid'] }}" selected>{{ $ip['iaddress'] }}</option>
                                        @else
                                        <option value="{{ $ip['iid'] }}">{{ $ip['iaddress'] }}</option>
                                        @endif
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_type') }}</label>
                                    <select class="form-control" name="type">
                                        @if($rdns['rtype'] == 'PTR')
                                        <option value="PTR" selected>PTR</option>
                                        @else
                                        <option value="PTR">PTR</option>
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_content') }}</label>
                                    <input type="text" class="form-control set-password" name="dns" required="required" value="{{ $rdns['rdns'] }}">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_priority') }}</label>
                                    <input type="number" class="form-control set-password" name="priority" required="required" value="{{ $rdns['rpriority'] }}">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('ippage_rdns_ttl') }}</label>
                                    <input type="number" class="form-control set-password" name="ttl" required="required" value="{{ $rdns['rttl'] }}">
                                </div>
                            </div>
                            <div class="col-12 row-center row-flex">
                                <a href="#" class="btn btn-primary beCallRequestx" data-method="rnds_edit" data-form="rnds_edit{{ $rdns['rid'] }}">
                                    {{ __('global_update') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @endforeach
        <div class="be_tab" id="beTabSnapshot">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_snapshot') }}</span>
                    </div>
                    <div>
                        <a href="#" class="btn btn-primary btn-sm beCallRequestx" data-method="snapshot_create"><i class="ri-add-line"></i> {{ __('snapshotpage_takesnapshot') }}</a>
                    </div>
                </div>
                <div class="card-content">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th>{{ __('snapshotpage_snapname') }}</th>
                                <th>{{ __('snapshotpage_snapdate') }}</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($snapshotlist)
                            @foreach($snapshotlist as $snapshot)
                            <tr id="snapshot{{ $snapshot["ssid"] }}">
                                <td>{{ $snapshot["sname"] }}</td>
                                <td>{{ date("d.m.Y H:i",$snapshot["sdateline"]) }}</td>
                                <td style="display:flex;justift-content:center;align-items:center">
                                    <a href="#" class="btn btn-primary btn-sm beCallRequestx" data-method="snapshot_deploy" data-data="ssid={{ $snapshot['ssid'] }}">
                                        <i class="ri-upload-line"></i>
                                        {{ __('snapshotpage_deploy') }}
                                    </a>
                                    <a href="#" class="btn btn-transparent btn-sm ml-2 beCallRequestx" data-method="snapshot_delete" data-data="ssid={{ $snapshot['ssid'] }}">
                                        <i class="ri-delete-bin-line"></i>
                                        {{ __('snapshotpage_delete') }}
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="3">
                                    <div class="beempty">
                                        <div>{{ __('snapshotpage_empty') }}</div>
                                        <div><a href="#" class="btn btn-primary beCallRequestx" data-method="snapshot_create"><i class="ri-add-line"></i> {{ __('snapshotpage_takesnapshot') }}</a></div>
                                    </div>
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="be_tab" id="beTabFormat">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('formatpage_name') }}</span>
                    </div>
                </div>
                <div class="card-content">
                    <form id="formatForm">
                        <div class="row my-3">
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password1">{{ __('formatpage_os') }}</label>
                                    <select class="form-control" name="tid">
                                        @foreach($templatelist as $template)
                                        <option value="{{ $template['tid'] }}">{{ $template['tname'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password2">{{ __('formatpage_serverpass') }}</label>
                                    <div class="form-input-area">
                                        <input type="text" class="form-control set-password2" name="password" id="Password2">
                                        <button class="btn beCreatePassword btn-primary" data-area=".set-password2">{{ __('formatpage_randompass') }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input type="hidden" name="approval" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" name="approval" id="approval" checked="">
                                    <label class="form-check-label" for="approval">
                                        {{ __('formatpage_approve') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="Password2">{{ str_replace("{formatcount}",($vminfo['format']['subtotal']-$vminfo['format']['total']),__('formatpage_formatcount' )) }}</label>
                                </div>
                            </div>
                            <div class="col-12 row-center row-flex">
                                <a href="#" class="btn btn-primary beCallRequestx" data-method="format" data-form="format">
                                    {{ __('formatpage_format') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="be_tab" id="beTabLogs">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_logs') }}</span>
                    </div>
                </div>
                <div class="card-content">
                    <table class="btable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ __('logspage_process') }}</th>
                                <th>{{ __('logspage_date') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($logs)
                            @foreach($logs as $log)
                            <tr>
                                <td>{{ $log["lid"] }}</td>
                                <td>{{ $log["ldescription"] }}</td>
                                <td>{{ date("d.m.Y H:i",$log["ldateline"]) }}</td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="4">
                                    <div class="beempty">
                                        <div>Hiç bir işlem kaydınız bulunmuyo</div>
                                    </div>
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="be_server_info be_card">
        <div class="be_card_header">
            <div>{{ __('server_info') }}</div>
        </div>
        <div class="be_server_info_table">
            <div class="be_sit_row">
                <div>{{ __('server_info_productname') }}:</div>
                <div>{{ $orderinfo['product'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_ipaddress') }}:</div>
                <div>{{ $vminfo['ipaddres'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_buydate') }}:</div>
                <div>{{ $orderinfo['regdate'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_user') }}:</div>
                <div>{{ $vminfo['username'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_nexduedate') }}:</div>
                <div>{{ $orderinfo['nextduedate'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_password') }}:</div>
                <div>{{ $vminfo['password'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_price') }}:</div>
                <div>{{ $orderinfo['amount'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_uptime') }}:</div>
                <div>{{ $vminfo['uptime'] }} Dakika</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_basicprice') }}:</div>
                <div>{{ $orderinfo['billingprice'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_os') }}:</div>
                <div>{{ $vminfo['templatename'] }}</div>
            </div>
            <div class="be_sit_row">
                <div>{{ __('server_info_status') }}:</div>
                <div>{{ $vminfo['power'] == 1 ? "Açık":"Kapalı" }}</div>
            </div>
        </div>
    </div>  
</div>
<script>
    $(".be_button").on("click",function(){
        var tab = $(this).data("tab");
        if(tab){
            $(".be_button.active").removeClass("active");
            $(this).addClass("active");
            $(".be_tab.active").removeClass("active");
            $("#beTab"+tab).addClass("active");
            return false;
        }
        var tab = $(this).data("alt-tab");
        if(tab){
            $(".be_tab.active").removeClass("active");
            $("#beTab"+tab).addClass("active");
            return false;
        }
    });
    $(".be_button_alt").on("click",function(){
        var tab = $(this).data("tab");
        $(".be_tab.active").removeClass("active");
        $("#beTab"+tab).addClass("active");
        return false;
    });
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
    var more = true;
    setInterval(function(){ 
        if(more){
            more = false;
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: {action:"check_stat",upid:{{ $userproduct['upid'] }}},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $("#cpuPercentPath").get(0).setAttribute('stroke-dasharray',response.cpu_percent+", 100");
                    $("#cpuPercentPath").css("stroke",response.cpu_percent_color);
                    $("#cpuPercentText").html(response.cpu_usage+" "+response.cpu_type+" / "+response.cpu_max+" MHZ");
                    $("#cpuPercent").html(response.cpu_percent+"%");
                    $("#ramPercentPath").get(0).setAttribute('stroke-dasharray',response.ram_percent+", 100");
                    $("#ramPercentPath").css("stroke",response.ram_percent_color);
                    $("#ramPercentText").html(response.ram_usage+" "+response.ram_type+" / "+response.ram_max+"  MB");
                    $("#ramPercent").html(response.ram_percent+"%");
                    $("#discPercentPath").get(0).setAttribute('stroke-dasharray',response.disk_percent+", 100");
                    $("#discPercentPath").css("stroke",response.disc_percent_color);
                    $("#discPercentText").html(response.disk_usage+" GB / "+response.disk_max+" GB");
                    $("#discPercent").html(response.disk_percent+"%");
                    $("#netPercent").html(response.network_usage+" "+response.network_type);
                    $("#netPercentText").html(response.network_usage+" "+response.network_type);
                    more = true;
                }
            });	
        }	
    },10000);
    setTimeout(function(){
        location.reload();
    },300000)
</script>