@extend('clientarea.layout')
@section('title')Hizmetlerim - {{ beGetConfig('sitename') }}@endsection
@section('headerinclude')
<style>
.beSetMethod.selected {
    border: 2px solid #009ef7;
}
</style>
@endsection
@section('content')
<div class="card mb-4">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-shopping-cart-line"></i> Hizmetlerim</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Hizmet No</th>
                    <th>Hizmet</th>
                    <th>Ücret</th>
                    <th>Sonraki Ödeme Tarihi</th>
                    <th>Durum</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($userproducts)
                @foreach($userproducts as $userproduct)
                <tr>
                    <td>
                        <input class="form-check-input checkExtend" type="checkbox" data-upid="1">
                        <span>#{{ $userproduct['upid'] }}</span>
                        <span class="beShowExtra text-primary" data-upid="{{ $userproduct['upid'] }}"><i class="ri-arrow-down-double-fill"></i></span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $userproduct['upname'] }}</span>
                            <span class="second-row text-sm">{{ $userproduct['uptag'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beMoneyFormat($userproduct['upprice']).' '.$currencies[$userproduct['cid']]['cicon'] }}</span>
                    </td>
                    <td>
                        <span class="first-row">{{ $userproduct['enddate'] }}</span>
                        <span class="second-row {{ $userproduct['endclass'] }}">{{ $userproduct['endtext'] }}</span>
                    </td>
                    <td>
                        <span class="btn btn-{{ $userproductstatus[$userproduct['upstatus']][1] }}">
                            {{ $userproductstatus[$userproduct['upstatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <div class="buttons">
                            <a href="#" class="btn btn-primary beCallRequest" data-url="{{ beGetRoute('client.userproduct.process') }}" data-data="action=manage&upid={{ $userproduct['upid'] }}">
                                <i class="ri-terminal-box-line"></i>
                                Yönet
                            </a>
                            @if($userproduct['pextend'] == '1')
                                <a href="#" class="btn btn-warning beCallRequest ml-2" data-url="{{ beGetRoute('client.userproduct.process') }}" data-data="action=extend&upid={{ $userproduct['upid'] }}">
                                    <i class="ri-timer-flash-line"></i>
                                    Uzat
                                </a>
                            @endif
                        </div>
                    </td>
                </tr>
                <tr class="no-border row-none beExtraOptions{{ $userproduct['upid'] }}">
                    <td colspan="6">
                        <form id="beExtraOptions{{ $userproduct['upid'] }}Form">
                            <input type="hidden" name="upid" value="{{ $userproduct['upid'] }}">
                            <div class="row">
                                @if($userproduct['pextendauto'] == 1)
                                <div class="col-12 mb-2">
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input type="hidden" name="upextendauto" value="0">
                                        <input class="form-check-input beSetAutoPay" type="checkbox" value="1" name="upextendauto" data-upid="{{ $userproduct['upid'] }}" id="upextendauto{{ $userproduct['upid'] }}"{{ $userproduct['upextendauto'] == 1 ? ' checked':'' }}>
                                        <label class="form-check-label" for="upextendauto{{ $userproduct['upid'] }}">
                                            Bu ürünü bakiyem ile otomatik olarak uzat
                                        </label>
                                    </div>
                                </div>
                                @endif
                                <div class="col-12 row-center row-flex">
                                    <a href="#" class="btn btn-special beCallRequest" data-form="beExtraOptions{{ $userproduct['upid'] }}" data-url="{{ beGetRoute('client.userproduct.options') }}">Kaydet</a>
                                </div>
                            </div>
                        </form>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
        <div class="card-info">
            <div>
                <span><b>{{ $product_count }}</b> adet hizmetiniz bulunuyor!</span>
            </div>
        </div>
    </div>
</div>
@if($userproductcancellations)
<div class="card mb-4">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-close-circle-line"></i> İptal Taleplerim</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr style="background:#d9214e">
                    <th style="color:#fff">İptal Talep No</th>
                    <th style="color:#fff">Hizmet</th>
                    <th style="color:#fff">Tür</th>
                    <th style="color:#fff">Durum</th>
                    <th style="color:#fff">Açılış Tarihi</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach($userproductcancellations as $userproductcancellation)
                <tr>
                    <td>
                        <span>#{{ $userproductcancellation['upcid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $userproductcancellation['userproduct']['upname'] }}</span>
                            <span class="second-row text-sm">{{ $userproductcancellation['userproduct']['uptag'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span>{{ $cancellationtypes[$userproductcancellation['upctype']] }}</span>
                    </td>
                    <td>
                        <span class="btn btn-{{ $cancellationstatus[$userproductcancellation['upcstatus']][1] }}">
                            {{ $cancellationstatus[$userproductcancellation['upcstatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <span>{{ beSpecialTime($userproductcancellation['upcdateline']) }}</span>
                    </td>
                    <td>
                        @if(($userproductcancellation['upctype'] == 'now' && $userproductcancellation['upcstatus'] == '0') || ($userproductcancellation['upctype'] != 'now' && $userproductcancellation['upcstatus'] != '-1'))
                        <div class="buttons">
                            <a href="#" class="btn btn-primary beCallRequest" data-url="{{ beGetRoute('client.userproduct.cancel.delete.post') }}" data-data="upcid={{ $userproductcancellation['upcid'] }}">
                                <i class="ri-close-line"></i>
                                Talebi İptal Et
                            </a>
                        </div>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif
@endsection
@section('js')
<script>
$(".beShowExtra").on("click",function(){
    var upid = $(this).data("upid");
    var item = $(".beExtraOptions"+upid);
    if(item.css("display") == "none"){
        $(this).html('<i class="ri-arrow-up-double-fill"></i>');
        item.show("slow");
    }
    else{
        $(this).html('<i class="ri-arrow-down-double-fill"></i>');
        item.hide();
    }
});
$(".beSetMethod").on("click",function(){
    $(".beSetMethod.selected").removeClass("selected");
    $(".beSetMethod").addClass("selected");
});
</script>
@endsection