<!DOCTYPE html>
<html xml:lang="tr" lang="tr" xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta charset="UTF-8">
        <title>Hizmet İptali - {{ beGetConfig('sitename') }}</title>
        {{ $headerinclude }}
        <link href="assets/betheme/css/clientarea.css?ver=24" rel="stylesheet">
        <link href="assets/betheme/css/card.css?ver=22" rel="stylesheet">
        <link href="assets/betheme/css/col.css?ver=16" rel="stylesheet">
        <link href="assets/betheme/css/forms.css?ver=21" rel="stylesheet">
    </head>
    <body>
        <main>
            {{ $header }}
            <div class="content">
                <div class="container-xxl bclientarea">
                    <div class="col-3 col-md-12">
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Hızlı Erişim</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li data-page="client.dashboard.alternative">
                                        <a href="{{ beGetRoute('client.dashboard.alternative') }}">
                                            <div>
                                                <i class="ri-service-line"></i>
                                                <span>Ana Sayfa</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.userproduct.userproducts">
                                        <a href="{{ beGetRoute('client.userproduct.userproducts') }}">
                                            <div>
                                                <i class="ri-shopping-cart-line"></i>
                                                <span>Hizmetlerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.tickets" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.tickets') }}">
                                            <div>
                                                <i class="ri-ticket-line"></i>
                                                <span>Destek Taleplerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.newticket" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.newticket') }}">
                                            <div>
                                                <i class="ri-coupon-3-line"></i>
                                                <span>Yeni Destek Talebi</span>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-9 col-md-12">
                        <div class="bcontent">
                            <div class="card mb-3">
                                <div class="card-header">
                                    <div>
                                        <span class="card-title"><i class="ri-git-repository-private-line"></i> Hizmetimi İptal Et</span>
                                    </div>
                                </div>
                                <div class="card-content">
                                    <form id="beCancelForm">
                                        <input type="hidden" name="upid" value="{{ $userproduct['upid'] }}">
                                        <div class="row">
                                            <div class="col-6 mb-3">
                                                <div class="form-group">
                                                    <label for="#">İptal Edilecek Hizmet</label>
                                                    <select class="form-control" name="upid" disabled>
                                                        <option value="{{ $userproduct['upid'] }}">{{ $userproduct['upid'].' # '.$userproduct['upname'].($userproduct['uptag'] ? '('.$userproduct['uptag'].')':'') }}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-6 mb-3">
                                                <div class="form-group">
                                                    <label for="#">İptal Türü</label>
                                                    <select class="form-control" name="type">
                                                        @foreach($cancellationtypes as $key => $value)
                                                        <option value="{{ $key }}">{{ $value }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-3">
                                                <div class="form-group">
                                                    <label for="#">İptal Sebebi</label>
                                                    <textarea class="form-control" name="reason" required rows="5"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-12 row-center row-flex">
                                                <a href="#" class="btn btn-special beCallRequest" data-url="{{ beGetRoute('client.userproduct.cancel.post') }}" data-form="beCancel">Onaylıyorum</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{ $footer }}
        </main>
    </body>
</html>