@extend('layout')
@section('title')Kayıt Ol - {{ beGetConfig('sitename') }}@endsection
@section('headerinclude')
<link href="assets/betheme/css/clientarea.css?ver=19" rel="stylesheet">
<link href="assets/betheme/css/card.css?ver=12" rel="stylesheet">
<link href="assets/betheme/css/col.css?ver=30" rel="stylesheet">
<link href="assets/betheme/css/forms.css?ver=26" rel="stylesheet">
<link href="assets/betheme/css/index.css?ver=11" rel="stylesheet">
@endsection
@section('content')
<div class="container">
    <div class="heading">
        <div class="mission">Sende Harika Hizmetlerden Yararlanmaya Hazır Mısın?</div>
        <div class="vision">Avantajlı fiyatlarla yüzlerce özelliğe sahip özel ürünlerle kalitenize kalite katın!</div>
    </div>
</div>
<div class="container bclientarea">
    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-header">
                    <div>
                        <span class="card-title"><i class="ri-logout-box-line"></i> Kayıt Formu</span>
                    </div>
                </div>
                <div class="card-content">
                    <form id="beRegisterForm">
                        <div class="row">
                            <div class="col-6 mb-3">
                                <div class="form-group">
                                    <label for="#">İsim<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="name" required="required">
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-group">
                                    <label for="#">Soy İsim<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="surname" required="required">
                                </div>
                            </div>
                            <div class="col-6 mb-5">
                                <div class="form-group">
                                    <label for="#">E-Posta Adresiniz<span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" required="required" placeholder="isim@alanadi.com">
                                </div>
                            </div>
                            <div class="col-6 mb-5">
                                <div class="form-group">
                                    <label for="#">Telefon Numaranız<span class="text-danger">*</span></label>
                                    <div class="row-flex">
                                        <input type="text" class="form-control" name="dial" required="required" value="+90" style="width:16%;border-top-right-radius:0px;border-bottom-right-radius:0px;">
                                        <input type="text" class="form-control" name="phone" required="required" placeholder="{{ substr(str_replace(' ','',beGetConfig('company_phone_text')),1) }}" style="width:84%;border-top-left-radius:0px;border-bottom-left-radius:0px;">
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 my-2">
                                <div class="row-flex row-center">
                                    <span class="text-normal">Konum Bilgileri</span>
                                </div>
                                <hr>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-group">
                                    <label for="#">Ülke<span class="text-danger">*</span></label>
                                    <select class="form-control" name="country">
                                        @foreach($countries as $country)
                                        <option value="{{ $country['acid'] }}"{{ $system_country == $country['acid'] ? ' selected':'' }}>{{ $country['acname'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-group">
                                    <label for="#">Şehir<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="district" required="required">
                                </div>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-group">
                                    <label for="#">İlçe<span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="province" required="required">
                                </div>
                            </div>
                            <div class="col-12 mb-5">
                                <div class="form-group">
                                    <label for="#">Adres</label>
                                    <input type="text" class="form-control" name="address" required="required" placeholder="Adresinizin devamını giriniz">
                                </div>
                            </div>
                            <div class="col-12 my-3">
                                <div class="row-flex row-center">
                                    <span class="text-normal">Hesap Güvenliği</span>
                                </div>
                                <hr>
                            </div>
                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label for="#">Şifre<span class="text-danger">*</span></label>
                                    <div class="form-input-area">
                                        <input type="text" class="form-control set-password" name="password1"  required="required">
                                        <button class="btn btn-special beCreatePassword" data-area=".set-password">Şifre Üret</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mb-5">
                                <div class="form-group">
                                    <label for="#">Şifre Tekrar<span class="text-danger">*</span></label>
                                    <input type="password" class="form-control set-password" name="password2" required="required">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input type="hidden" name="agreement" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" name="agreement" id="agreement">
                                    <label class="form-check-label" for="agreement">
                                        <a href="{{ beGetRoute('contracts_product') }}" target="_blank">Hizmet Sözleşmesi</a>'ni ve diğer sözleşmeleri okudum, anladım ve kabul ediyorum.
                                        <span class="text-danger">*</span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input type="hidden" name="invoiceinfo" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" name="invoiceinfo" id="invoiceinfo">
                                    <label class="form-check-label" for="invoiceinfo">
                                        Siparişlerim hakkında olan bilgilendirmeleri, ödeme zamanı yaklaşan faturalarımın tarafıma mail ve sms olarak iletilmesini istiyorum.
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input type="hidden" name="productinfo" value="0">
                                    <input class="form-check-input" type="checkbox" value="1" name="productinfo" id="productinfo">
                                    <label class="form-check-label" for="productinfo">
                                        <a href="{{ beGetRoute('contracts_kvkk') }}" target="_blank">Kişisel verilerimin</a>  reklam, promosyon, tanıtım vb. ticari elektronik ileti gönderilmek üzere işlenmesini, bu amaçla kullanılmasını, saklanmasını ve tarafıma ticari elektronik ileti gönderilmesini istiyorum.
                                    </label>
                                </div>
                            </div>
                            <div class="col-12 row-center row-flex">
                                <a href="#" class="btn btn-special beCallRequest" data-form="beRegister" data-url="{{ beGetRoute('auth.register.post') }}">Kayıt Ol</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-3">
            <div class="card">
                <div class="card-content">
                    <div class="col-12 my-3 mb-5">
                        <div class="row-flex row-center">
                            <span class="text-normal">Hesap oluşturmak konusunda karasız mı kaldınız?</span>
                        </div>
                    </div>
                <div class="col-12 row-flex row-center">
                        <a class="btn btn-special" title="İletişim" alt="İletişim" rel="nofollow noreferrer" href="{{ beGetRoute('contact_info') }}">
                            <i class="ri-customer-service-2-line"></i>İletişim
                        </a>
                </div>
                <div class="image" style="height: 250px;background: url(assets/betheme/img/usercomputer.png?v=2);background-size:contain;background-position:center;background-repeat:no-repeat;"></div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
$("input[name='surname']").on("input",function() {
    var value = $(this).val().replace(/ /g,"");
    $(this).val(value);
});
$("input[name='dial']").on("input",function() {
    var number = $(this).val();
    var length = number.length;
    if(length == 0){
      number = "+";
    } 
    $(this).val(number)
});
$("input[name='phone']").on("input",function() {
    var number = $(this).val().replace(/[^\d]/g,"");
    var length = number.length;
    if(length < 7){
      number = number.replace(/(\d{0,3})(\d{0,3})/,"($1) $2");
    } 
    else if(length <= 10){
        number = number.replace(/(\d{3})(\d{3})(\d{1,4})/,"($1) $2-$3");
    } 
    else{
        number = number.replace(/(\d{3})(\d{1,3})(\d{1,4})(\d.*)/,"($1) $2-$3");
    }
    $(this).val(number)
});
</script>
@endsection