@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Destek İmzası Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="signatureForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Aralık</label>
                            <select class="form-control form-control-select" name="type">
                                @foreach($signaturestypes as $key => $signaturestype)
                                <option value="{{ $key }}"{{ $signature['tastime'] == $key ? ' selected':'' }}>{{ $signaturestype[0] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}"{{ $signature['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Mesaj</label>
                            <textarea class="form-control form-control-flush mb-3" rows="5" placeholder="Lütfen mesajınızı yazınız" id="messageArea">{{ $signature['tasmessage'] }}</textarea>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editSignature">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script>
    $(document).ready(function(){
        $(".form-control-select").select2();
        var options = {selector:"#messageArea",height:"480",entity_encoding:"raw",verify_html:false,plugins:'code searchreplace autolink directionality visualblocks visualchars image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons autosave fullscreen',toolbar: "undo redo print spellcheckdialog formatpainter | blocks fontfamily fontsize | bold italic underline forecolor backcolor | link image | alignleft aligncenter alignright alignjustify | code"};
        if(KTThemeMode.getMode() === "dark"){
            options["skin"] = "oxide-dark";
            options["content_css"] = "dark";
        }
        tinymce.init(options);
    });
    var wait = false;
    $(".editSignature").on("click",function(){
        if(!wait){
            $(".editSignature").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            var message = tinymce.activeEditor.getContent();
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.adminsignature.edit.post') }}",
                type: "post",
                async: true,
                data: {type:$("select[name='type']").val(),language:$("select[name='language']").val(),message:message,tasid:{{ $signature['tasid'] }}},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".editSignature").html('Kaydet');
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection