@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Hazır Cevap Kategori Oluştur
                </div>
            </div>
            <div class="card-body">
                <form id="addCategoryForm">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Adı</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addCategory">Oluştur</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var wait = false;
    $(".form-control-select").select2();
    $(".addCategory").on("click",function(){
        if(!wait){
            $(".addCategory").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.predefined.category.add.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#addCategoryForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    $(".addCategory").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection