@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Talep Oluştur
                </div>
            </div>
            <div class="card-body">
                <form id="ticketForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kullanıcı</label>
                            <select class="form-control form-control-select-user" name="user">

                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Talep Başlığı</label>
                            <input type="text" class="form-control" name="subject">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Departman</label>
                            <select class="form-control form-control-select" name="depertment">
                                @foreach($depertments as $depertment)
                                    <option value="{{ $depertment['tdid'] }}">{{ $depertment['tdname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İlişkili Hizmet</label>
                            <select class="form-control form-control-select" name="userproduct">
                                <option value="0">Seçiniz</option>
                            </select>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İçerik</label>
                            <textarea class="form-control form-control-flush mb-3" rows="5" placeholder="Lütfen mesajınızı yazınız" id="messageArea" name="message"></textarea>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addTicket">Oluştur</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script>
    $(".form-control-select").select2();
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    $(".form-control-select-user").change(function(){
        var uid = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('admin.user.orders.search.post') }}",
            type: "post",
            async: true,
            data: {uid:uid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var text = '<option value="0">Seçiniz</option>';
                    $.each(response.items,function(id,item){
                        text += '<option value="'+item.upid+'">'+item.upname+' # '+item.uptag+'</option>'
                    });
                    console.log(text);
                    $("select[name='userproduct']").html(text);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
    $(document).ready(function(){
        var options = {selector:"#messageArea",height:"480",entity_encoding:"raw",verify_html:false,plugins:'code searchreplace autolink directionality visualblocks visualchars image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons autosave fullscreen',toolbar: "undo redo print spellcheckdialog formatpainter | blocks fontfamily fontsize | bold italic underline forecolor backcolor | link image | alignleft aligncenter alignright alignjustify | code"};
        if(KTThemeMode.getMode() === "dark"){
            options["skin"] = "oxide-dark";
            options["content_css"] = "dark";
        }
        tinymce.init(options);
    });
    var wait = false;
    $(".addTicket").on("click",function(){
        if(!wait){
            wait = true;
            $(".addTicket").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            tinymce.triggerSave();
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.add.post') }}",
                type: "post",
                async: true,
                data: $("#ticketForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addTicket").html("Oluştur");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000)
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection