@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-4">
            <div class="row p-3">
                @foreach($themes as $theme)
                <div class="col-xl-4">
                    <div class="card bg-light card-custom gutter-b card-stretch">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 mr-4 symbol symbol-90 symbol-circle">
                                    <img src="{{ $theme['timage'] }}" alt="image" style="width:100px;height:100px">
                                </div>
                                <div class="d-flex flex-column mx-5">
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-3 ml-3">
                                        {{ $theme['tname'] }}
                                    </span>
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-5 ml-3">
                                        {{ $theme['tdescription'] }}
                                    </span>
                                    <div class="d-flex align-items-center">
                                        @if($theme['tcode'] == $themecode)
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto" disabled>Aktif</button>
                                        @else
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto beSelectTheme" data-tid="{{ $theme['tid'] }}">Temayı Kullan</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>                   
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".beSelectTheme").on("click",function(){
        var tid = $(this).data("tid");
        Swal.fire({
            html: "Bu işlem sonucunda temanız değişecektir onaylıyor musunuz?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.theme.select.post') }}",
                    type: "post",
                    data: {tid:tid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>

@endsection
