@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-4">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bold text-gray-800">SMS Modülü</span>
                </h3>
                <div class="card-toolbar">
                    <button type="button" class="btn btn-danger btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto beSelectModule" data-module="" data-type="sms">Modül Kullanmak İstemiyorum</button>
                </div>
            </div>
            <div class="row p-3">
                @foreach($modules['sms'] as $code => $module)
                <div class="col-xl-4">
                    <div class="card bg-light card-custom gutter-b card-stretch">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                @if($module['info']['iamge'])
                                <div class="flex-shrink-0 mr-4 symbol symbol-90 symbol-circle">
                                    <img src="{{ $module['info']['iamge'] }}" alt="image" style="width:100px;height:100px">
                                </div>
                                @endif
                                <div class="d-flex flex-column mx-5">
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-3 ml-3">
                                        {{ $module['info']['name'] }}
                                    </span>
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-5 ml-3">
                                        {{ $module['info']['description'] }}
                                    </span>
                                    <div class="d-flex align-items-center">
                                        @if($code == $settings['system_sms_module'])
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto" disabled>Aktif</button>
                                        @else
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto beSelectModule" data-module="{{ $code }}" data-type="sms">Modülü Kullan</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>                   
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bold text-gray-800">Fatura Modülü</span>
                </h3>
                <div class="card-toolbar">
                    <button type="button" class="btn btn-danger btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto beSelectModule" data-module="" data-type="invoice">Modül Kullanmak İstemiyorum</button>
                </div>
            </div>
            <div class="row p-3">
                @foreach($modules['invoice'] as $code => $module)
                <div class="col-xl-4">
                    <div class="card bg-light card-custom gutter-b card-stretch">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                @if($module['info']['iamge'])
                                <div class="flex-shrink-0 mr-4 symbol symbol-90 symbol-circle">
                                    <img src="{{ $module['info']['iamge'] }}" alt="image" style="width:100px;height:100px">
                                </div>
                                @endif
                                <div class="d-flex flex-column mx-5">
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-3 ml-3">
                                        {{ $module['info']['name'] }}
                                    </span>
                                    <span class="card-title text-hover-primary font-weight-bolder font-size-h5 text-dark mb-5 ml-3">
                                        {{ $module['info']['description'] }}
                                    </span>
                                    <div class="d-flex align-items-center">
                                        @if($code == $settings['system_invoice_module'])
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto" disabled>Aktif</button>
                                        @else
                                            <button type="button" class="btn btn-primary btn-sm text-uppercase font-weight-bolder mt-5 mt-sm-0 mr-auto mr-sm-0 ml-sm-auto beSelectModule" data-module="{{ $code }}" data-type="invoice">Modülü Kullan</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>                   
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".beSelectModule").on("click",function(){
        var module = $(this).data("module");
        var type = $(this).data("type");
        Swal.fire({
            html: "Bu işlem kullanılan modül değişecektir onaylıyor musunuz?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.settings.module.set.post') }}",
                    type: "post",
                    data: {module:module,type:type},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            Swal.fire("Başarılı",response.message,"success");
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>

@endsection
