@extend('admin.layout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            Ürün
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Ürün ID</td>
                                            <td class="text-gray-800"># {{ $product['pid'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Eklenme:</td>
                                            <td class="text-gray-800">{{ date('d.m.Y',$product['pdateline']) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Stok Sayısı:</td>
                                            <td class="text-gray-800">{{ $product['pstock'] }} Adet</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Aktif Ürün:</td>
                                            <td class="text-gray-800">{{ $product['pactive'] }} Adet</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Toplam Satış:</td>
                                            <td class="text-gray-800">{{ $product['psold'] }} Adet</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5 active" href="#" data-tab="Global">Genel</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5" href="#" data-tab="Module">Modül</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5" href="#" data-tab="Addons">Yapılandırma</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5" href="#" data-tab="Pricing">Fiyatlandırma</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5" href="#" data-tab="Upgrade">Yükseltim</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link nav-tab text-active-primary ms-0 me-10 py-5" href="#" data-tab="Logs">Kayıtlar</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="tabs">
            <div class="tab active" id="tabGlobal">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title mt-5 d-block mb-0">
                                    <div class="d-block">
                                        Ürün Bilgileri
                                    </div>
                                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                        @foreach($languages as $language)
                                        <li class="nav-item mt-2">
                                            <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="infoForm">
                                    @foreach($languages as $language)
                                    @php $productlantranslation = []; @endphp
                                    @foreach($producttranslations as $producttranslation)
                                        @php
                                            if($producttranslation['lid'] != $language['lid']){
                                                continue;
                                            }
                                            $productlantranslation = $producttranslation;
                                        @endphp
                                    @endforeach
                                    <div class="row languageTab {{ $language['lid'] == $systemlid ? 'd-flex':'d-none' }} languageTab{{ $language['lid'] }}">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Ürün Adı</label>
                                            <input type="text" class="form-control" name="pname[{{ $language['lid'] }}]" value="{{ $productlantranslation['pname'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Açıklama</label>
                                            <textarea class="form-control" name="pdescription[{{ $language['lid'] }}]" rows="3">{{ $productlantranslation['pdescription'] }}</textarea>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Meta Açıklama</label>
                                            <textarea class="form-control" name="pmetadescription[{{ $language['lid'] }}]" rows="3">{{ $productlantranslation['pmetadescription'] }}</textarea>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Meta Keyword</label>
                                            <input type="text" class="form-control" name="pmetakeywords[{{ $language['lid'] }}]" value="{{ $productlantranslation['pmetakeywords'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Özellikler</label>
                                            <textarea class="form-control" name="pfeatures[{{ $language['lid'] }}]" rows="5">{{ $productlantranslation['pfeatures'] }}</textarea>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Link</label>
                                            <input type="text" class="form-control" name="pslug[{{ $language['lid'] }}]" value="{{ $productlantranslation['pslug'] }}">
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto infoSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                    @endforeach
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürün Ayarları
                                </div>
                            </div>
                            <form id="optionForm" class="card-body">
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Ürün Uzatımı</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Panel üstünden kullanıcı istediği an fatura oluşturup ürünün süresini uzatabilir.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="pextend" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="pextend" value="1"{{ $product['pextend'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Ürün Manuel Uzatım</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu ürünün müşteri tarafından manuel olarak uzatılabilmesini sağlar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="pextendmanuel" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="pextendmanuel" value="1"{{ $product['pextendmanuel'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Ürün Otomatik Uzatım</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu ürünün otomatik olarak uzatılabilmesini sağlar.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="pextendauto" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="pextendauto" value="1"{{ $product['pextendauto'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Ürün Gizliliği</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu ürünü sadece erişim linkini bilen kullanıcılar satın alabilir.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="psecret" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="psecret" value="1"{{ $product['psecret'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Zaman Aşım Ücretlendirmesi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Ürünün süresi dolduğunda faturanın ödenmediği her gün için aşım bedeli ekle.</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="poverageinvoice" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="poverageinvoice" value="1"{{ $product['poverageinvoice'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Stok Sayısı</label>
                                        <input type="text" class="form-control" name="pstock" value="{{ $product['pstock'] }}">
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Stok Türü</label>
                                        <select class="form-control form-control-select" name="pstocktype">
                                            <option value="unlimited"{{ $product['pstocktype'] == 'unlimited' ? ' selected':'' }}>İstediği Kadar Alabilir</option>
                                            <option value="activeone"{{ $product['pstocktype'] == 'activeone' ? ' selected':'' }}>Aktif Bir Tanesine Sahip Olabilir</option>
                                            <option value="onetime"{{ $product['pstocktype'] == 'onetime' ? ' selected':'' }}>Bir Kere Sahip Olabilir</option>
                                        </select>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Kategori</label>
                                        <select class="form-control form-control-select" name="categories[]" multiple>
                                            <option value="0">Yok</option>
                                            @foreach($categories as $category)
                                            @php if(!$category['pcid']) $category['pcid'] = 0 @endphp
                                            @php if(!$product['pcids']) $product['pcids'] = [] @endphp
                                            <option value="{{ $category['pcid'] }}"{{ in_array($category['pcid'],$product['pcids']) ? ' selected':'' }}>{{ $category['pcname'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto optionSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabModule">
                <div class="row g-5 g-xl-12 mb-7">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürün Modülü
                                </div>
                                <div>
                                    @if($product['pmodule'])
                                    <a href="#" class="btn btn-primary moduleDelete">Modülü Kaldır</a>
                                    @endif
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="moduleForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Sunucu Seçin</label>
                                            <select class="form-control form-control-select" name="server">
                                                <option value="">Seçiniz</option>
                                                @foreach($servers as $server)
                                                <option value="{{ $server['sid'] }}"{{ $product['sid'] == $server['sid'] ? ' selected':'' }}>{{ $server['sname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Modül Seçiniz</label>
                                            <select class="form-control form-control-select" name="module">
                                                <option value="">Seçiniz</option>
                                                @foreach($modules as $module => $data)
                                                <option value="{{ $module }}"{{ $product['pmodule'] == $module ? ' selected':'' }}>{{ $data['info']['name'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <div class="row" id="moduleContent">

                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto moduleSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabAddons">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürün Yapılandırması
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="addonForm">
                                    <div class="row">
                                        @foreach($productaddongroups as $productaddongroup)
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">{{ $productaddongroup['pagname'] }}</label>
                                            <div class="row p-3">
                                                @foreach($productaddons as $productaddon)
                                                @if($productaddon['pagid'] != $productaddongroup['pagid'] || $productaddon['lid'] != $systemlid)
                                                @php continue; @endphp
                                                @endif
                                                <div class="col-12 mb-9 mx-5">
                                                    @php $selected = ''; @endphp
                                                    @foreach($product['paddons'] as $paid)
                                                        @if($paid == $productaddon['paid'])
                                                            @php $selected = ' checked';break; @endphp
                                                        @endif
                                                    @endforeach
                                                    <input type="checkbox" class="form-check-input" id="selectAddon{{ $productaddon['paid'] }}" name="productaddons[]" value="{{ $productaddon['paid'] }}"{{ $selected }}>
                                                    <span for="selectAddon{{ $productaddon['paid'] }}">
                                                        {{ $productaddon['paname'] }}
                                                        <a href="{{ beGetRoute('admin.addon.show',['paid' => $productaddon['paid']]) }}">
                                                            <span class="svg-icon svg-icon-2 text-warning">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                                    <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                                    <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    </span>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        @endforeach
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Gruplandırılmamış</label>
                                            <div class="row p-3">
                                                @foreach($productaddons as $productaddon)
                                                @if($productaddon['pagid'] != 0 || $productaddon['lid'] != $systemlid)
                                                @php continue; @endphp
                                                @endif
                                                <div class="col-12 mb-9 mx-5">
                                                    @php $selected = ''; @endphp
                                                    @foreach($product['paddons'] as $paid)
                                                        @if($paid == $productaddon['paid'])
                                                            @php $selected = ' checked';break; @endphp
                                                        @endif
                                                    @endforeach
                                                    <input type="checkbox" class="form-check-input" id="selectAddon{{ $productaddon['paid'] }}" name="productaddons[]" value="{{ $productaddon['paid'] }}"{{ $selected }}>
                                                    <span for="selectAddon{{ $productaddon['paid'] }}">
                                                        {{ $productaddon['paname'] }}
                                                        <a href="{{ beGetRoute('admin.addon.show',['paid' => $productaddon['paid']]) }}">
                                                            <span class="svg-icon svg-icon-2 text-warning">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                                    <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                                    <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    </span>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Siparişlerde Güncelle</label>
                                            <div class="form-check form-check-custom form-check-solid">
                                                <input type="hidden" value="0" name="updateorders">
                                                <input class="form-check-input" type="checkbox" value="1" name="updateorders" id="updateorders">
                                                <label class="form-check-label" for="upbill">
                                                    Bu sipariş için satın alım, uzatma gibi işlemler için yapılan ödemeler için resmi fatura oluştur.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto addonSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabPricing">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title mt-5 d-block mb-0">
                                    <div class="d-block">
                                        Ürün Fiyatlandırması
                                    </div>
                                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                        @foreach($languages as $language)
                                        <li class="nav-item mt-2">
                                            <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="priceForm">
                                    @foreach($languages as $language)
                                        @php $pperiods = $product['pperiods'][$language['lid']]; @endphp
                                        <div class="row languageTab  {{ $language['lid'] == $systemlid ? 'd-flex':'d-none' }} languageTab{{ $language['lid'] }}">
                                            <div class="pricerow priceLang{{ $language['lid'] }}">
                                                @foreach($pperiods as $key => $period)
                                                <div class="row mb-9 pricearea-{{ $language['lid'] }}-{{ $key }}">
                                                    <div class="col-2">
                                                        <label class="fs-6 fw-semibold mb-2">Fiyat</label>
                                                        <input type="text" class="form-control" name="productprices[{{ $language['lid'] }}][{{ $key }}][price]" value="{{ $period['oprice'] }}">
                                                    </div>
                                                    <div class="col-3">
                                                        <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                                        <select class="form-control form-control-select" name="productprices[{{ $language['lid'] }}][{{ $key }}][currency]">
                                                            @foreach($currencies as $currency)
                                                            <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $period['ocid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-2">
                                                        <label class="fs-6 fw-semibold mb-2">İndirim(%)</label>
                                                        <input type="text" class="form-control" name="productprices[{{ $language['lid'] }}][{{ $key }}][discount]" value="{{ $period['odiscount'] }}">
                                                    </div>
                                                    <div class="col-2">
                                                        <label class="fs-6 fw-semibold mb-2">Zaman</label>
                                                        <input type="text" class="form-control" name="productprices[{{ $language['lid'] }}][{{ $key }}][time]" value="{{ $period['operiodtime'] }}">
                                                    </div>
                                                    <div class="col-2">
                                                        <label class="fs-6 fw-semibold mb-2">Periyot</label>
                                                        <select class="form-control form-control-select" name="productprices[{{ $language['lid'] }}][{{ $key }}][period]">
                                                            <option value="none"{{ $period['operiod'] == 'none' ? ' selected':'' }}>Tek Seferlik</option>
                                                            <option value="hour"{{ $period['operiod'] == 'hour' ? ' selected':'' }}>Saat</option>
                                                            <option value="day"{{ $period['operiod'] == 'day' ? ' selected':'' }}>Gün</option>
                                                            <option value="month"{{ $period['operiod'] == 'month' ? ' selected':'' }}>Ay</option>
                                                            <option value="year"{{ $period['operiod'] == 'year' ? ' selected':'' }}>Yıl</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-1 d-flex flex-center">
                                                        <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnPriceDelete" data-area=".pricearea-{{ $language['lid'] }}-{{ $key }}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                                                        </a>
                                                    </div>
                                                </div>
                                                @endforeach
                                                @php
                                                    if(!$key){
                                                        $key = 0;
                                                    }
                                                @endphp
                                            </div>
                                            <div class="row d-flex flex-center">
                                                <div class="col-4">
                                                    <button class="btn btn-success d-block m-auto priceAddNewLine" data-lang="{{ $language['lid'] }}" data-area=".priceLang{{ $language['lid'] }}" data-key="{{ $key+1 }}">Yeni Satır Ekle</button>
                                                </div>
                                                <div class="col-4">
                                                    <button class="btn btn-success d-block m-auto priceSaveForm">Kaydet</button>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Fiyatlandırma Kayıtları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Kullanıcı</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        @if($userproductlog['ltype'] != 'price_edit')
                                            @continue
                                        @endif
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabUpgrade">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürün Yükseltimi
                                </div>
                            </div>
                            <form id="upgradeForm" class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-9">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                <label class="fs-6 fw-semibold mb-2 d-block">Ürün Yükseltimi</label>
                                                <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Bu ürün alta seçilen ürünlere aradaki tutar ödenerek yükseltilebilir</label>
                                                <div class="form-check form-switch">
                                                    <input type="hidden" name="pupgrade" value="0">
                                                    <input class="form-check-input" type="checkbox" role="switch" name="pupgrade" value="1"{{ $product['pupgrade'] == 1 ? ' checked':'' }}>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Yükseltilebilecek Ürünleri Seçin</label>
                                        <select class="form-control form-control-select" name="products[]" multiple>
                                            <option value="">Seçiniz</option>
                                            @foreach($products as $upgradeproduct)
                                            @if($upgradeproduct['pid'] == $product['pid'])
                                            @php continue; @endphp
                                            @endif
                                            @php if(!$upgradeproduct['pid']) $upgradeproduct['pid'] = 0 @endphp
                                            @php if(!$product['pupgradeproducts']) $product['pupgradeproducts'] = [] @endphp
                                            <option value="{{ $upgradeproduct['pid'] }}"{{ in_array($upgradeproduct['pid'],$product['pupgradeproducts']) ? ' selected':'' }}>{{ $upgradeproduct['pname'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto upgradeSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabTransfer">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Ürünü Transfer Et
                                </div>
                            </div>
                            <div class="card-body mb-3">
                                <form id="transferForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Kullanıcı</label>
                                            <select class="form-control form-control-select-user" name="user">
                                                <option value="{{ $order['uid'] }}">{{ $order['name'].' '.$order['surname'] }}</option>
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto transferSaveForm">Taşı</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>          
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Sipariş Transfer Kayıtları
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">Kullanıcı</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        @if($userproductlog['ltype'] != 'transfer')
                                            @continue
                                        @endif
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>                         
                </div>
            </div>
            <div class="tab" id="tabLogs">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Kayıtlar
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table w-100 table-rounded table-striped gy-7 gs-7 mb-0">
                                    <thead>
                                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                            <th class="text-center align-middle">#</th>
                                            <th class="text-center align-middle">İşlemi Yapan</th>
                                            <th class="text-center align-middle">İşlem</th>
                                            <th class="text-center align-middle">IP Adresi</th>
                                            <th class="text-center align-middle">Tarih</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userproductlogs as $userproductlog)
                                        <tr>
                                            <td class="text-center align-middle">{{ $userproductlog['lid'] }}</td>
                                            <td class="text-center align-middle">
                                                {{ $userproductlog['name'].' '.$userproductlog['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $userproductlog['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>  
                                            </td>
                                            <td class="text-center align-middle">{{ $userproductlog['lmessage'] }}</td>
                                            <td class="text-center align-middle">{{ $userproductlog['lipaddress'] }}</td>
                                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$userproductlog['ldateline']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabCancel">
                <div class="row g-5 g-xl-8 mb-7">
                
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
    var module = "{{ $product['pmodule'] }}";
    $(document).ready(function(){
        if(module){
            beLoadModule();
        }
    });
    $(".form-control-select").select2();
    $(".nav-tab").on("click",function(){
        var tab = $(this).data("tab");
        $(".nav-tab.active").removeClass("active");
        $(this).addClass("active");
        $(".tab.active").removeClass("active");
        $("#tab"+tab).addClass("active");
        return false;
    });
    $(".nav-language").on("click",function(){
        var lang = $(this).data("lang");
        $(".nav-language.active").removeClass("active");
        $(this).addClass("active");
        $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
        $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
        return false;
    });
    $("select[name='module']").on("change",function(){
        var value = $(this).val();
        if(value != ""){
            module = value;
            beLoadModule();
        }
    });
    var wait = false;
    $(".moduleSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".moduleSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.automation.save.post') }}",
                type: "post",
                async: true,
                data: $("#moduleForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".moduleSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".moduleDelete").on("click",function(){
        if(!wait){
            wait = true;
            $(".moduleDelete").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.automation.delete.post') }}",
                type: "post",
                async: true,
                data: "pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".moduleDelete").html("Modülü Kaldır");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".infoSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".infoSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.info.save.post') }}",
                type: "post",
                async: true,
                data: $("#infoForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".infoSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                    loadModule(module);
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".optionSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".optionSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.option.save.post') }}",
                type: "post",
                async: true,
                data: $("#optionForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".optionSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".upgradeSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".upgradeSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.upgrade.save.post') }}",
                type: "post",
                async: true,
                data: $("#upgradeForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".upgradeSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".addonSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".addonSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.addon.save.post') }}",
                type: "post",
                async: true,
                data: $("#addonForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".addonSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".priceSaveForm").on("click",function(){
        if(!wait){
            wait = true;
            $(".priceSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.product.price.save.post') }}",
                type: "post",
                async: true,
                data: $("#priceForm").serialize()+"&pid={{ $product['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".priceSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".priceAddNewLine").on("click",function(){
        var lang = $(this).data("lang");
        var key = parseInt($(this).attr("data-key"));
        $(this).attr("data-key",key+1);
        var area = $(this).data("area");
        var newline = '<div class="row mb-9 pricearea-'+lang+'-'+key+'">\
            <div class="col-2">\
                <label class="fs-6 fw-semibold mb-2">Fiyat</label>\
                <input type="text" class="form-control" name="productprices['+lang+']['+key+'][price]">\
            </div>\
            <div class="col-3">\
                <label class="fs-6 fw-semibold mb-2">Para Birimi</label>\
                <select class="form-control form-control-select" name="productprices['+lang+']['+key+'][currency]">\
                    @foreach($currencies as $currency)
                    <option value="{{ $currency['cid'] }}">{{ $currency['cname'] }}</option>\
                    @endforeach
                </select>\
            </div>\
            <div class="col-2">\
                <label class="fs-6 fw-semibold mb-2">İndirim(%)</label>\
                <input type="text" class="form-control" name="productprices['+lang+']['+key+'][discount]">\
            </div>\
            <div class="col-2">\
                <label class="fs-6 fw-semibold mb-2">Zaman</label>\
                <input type="text" class="form-control" name="productprices['+lang+']['+key+'][time]">\
            </div>\
            <div class="col-2">\
                <label class="fs-6 fw-semibold mb-2">Periyot</label>\
                <select class="form-control form-control-select" name="productprices['+lang+']['+key+'][period]">\
                    <option value="none">Tek Seferlik</option>\
                    <option value="hour">Saat</option>\
                    <option value="day">Gün</option>\
                    <option value="month">Ay</option>\
                    <option value="year">Yıl</option>\
                </select>\
            </div>\
            <div class="col-1 d-flex flex-center">\
                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnPriceDelete" data-area=".pricearea-'+lang+'-'+key+'">\
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>\
                </a>\
            </div>\
        </div>';
        $(area).append(newline);
        $(".form-control-select").select2();
        return false;
    });
    $(".pricerow").on("click",".btnPriceDelete",function(){
        var area = $(this).attr("data-area");
        $(area).remove();
    });
    function beLoadModule(){
        $.ajax({
            url: "{{ beGetRoute('admin.product.automation.module.post') }}",
            type: "post",
            async: true,
            data: {module:module,pid:{{ $product['pid'] }}},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#moduleContent").empty().append(response.automation);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
</script>
@endsection