@extend('admin.layout')
@section('headerinclude')
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
.accordpool.active {
    display: flex;
    flex-shrink: 0;
    transition: all 0.2s ease-in-out;
    transform: rotate(90deg);
    align-items: center;
    justify-content: center;
    color: var(--kt-primary);
}
.accordpool.active > span {
    color: var(--kt-primary);
}
</style>
@endsection
@section('content')
<link href="assets/plugins/codemirror/codemirror.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material-darker.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/plugins/codemirror/codemirror.js"></script>
<script src="assets/plugins/codemirror/active-line.js"></script>
<script src="assets/plugins/codemirror/matchbrackets.js"></script>
<script src="assets/plugins/codemirror/xml.js"></script>
<script src="assets/plugins/codemirror/css.js"></script>
<script src="assets/plugins/codemirror/htmlmixed.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card mb-7">
                    <div class="card-header">
                        <div class="card-title mt-5 d-block mb-0">
                            <div class="d-block">
                                Sayfa Bilgileri
                            </div>
                            <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                @foreach($languages as $language)
                                <li class="nav-item mt-2">
                                    <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <form id="pageForm">
                            @foreach($languages as $language)
                            <div class="row languageTab languageTab{{ $language['lid'] }}">
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Kodu</label>
                                    <input type="text" class="form-control" name="ptcode[{{ $language['lid'] }}]">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Adı</label>
                                    <input type="text" class="form-control" name="ptname[{{ $language['lid'] }}]">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Başlığı(Title)</label>
                                    <input type="text" class="form-control" name="pttitle[{{ $language['lid'] }}]">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Link</label>
                                    <input type="text" class="form-control" name="ptslug[{{ $language['lid'] }}]">
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Açıklama</label>
                                    <input type="text" class="form-control" name="ptdescription[{{ $language['lid'] }}]">
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa İçerik(HTML)<span class="text-danger">*</span></label>
                                    <textarea class="form-control editor-code" name="ptcontent[{{ $language['lid'] }}]" rows="5"></textarea>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Kodu(PHP)<span class="text-danger">*</span></label>
                                    <textarea class="form-control php-code" name="pteval[{{ $language['lid'] }}]" rows="5"></textarea>
                                </div>    
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Başlık(HTML)<span class="text-danger">*</span></label>
                                    <textarea class="form-control html-code" name="ptheader[{{ $language['lid'] }}]" rows="5"></textarea>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Slider(HTML)<span class="text-danger">*</span></label>
                                    <textarea class="form-control html-code" name="ptcontentup[{{ $language['lid'] }}]" rows="5"></textarea>
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Kodu(JavaScript)<span class="text-danger">*</span></label>
                                    <textarea class="form-control html-code" name="ptjavascript[{{ $language['lid'] }}]" rows="5"></textarea>
                                </div>
                                <div class="col-12">
                                    <button class="btn btn-success d-block m-auto pageSaveForm">Kaydet</button>
                                </div>
                            </div>
                            @endforeach
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script>
    var codemirrorInstance = [];
    var length = 0;
    var options = {selector: ".editor-code", height : "480",entity_encoding: "raw"};
    if(KTThemeMode.getMode() === "dark"){
        options["skin"] = "oxide-dark";
        options["content_css"] = "dark";
    }
    tinymce.init(options);
    $(document).ready(function(){
        var foundtextareasarr = document.getElementsByClassName("php-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: "php",
                theme: "material-darker"   
            });
            length += 1;
        }
        var foundtextareasarr = document.getElementsByClassName("html-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[length+i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: "htmlmixed",
                theme: "material-darker"   
            });
        }
        length = codemirrorInstance.length;
        $(".languageTab").addClass("d-none");
        $(".languageTab{{ $systemlid }}").removeClass("d-none").addClass("d-flex");
    });
    $(".form-control-select").select2();
    $(".nav-language").on("click",function(){
        var lang = $(this).data("lang");
        $(".nav-language.active").removeClass("active");
        $(this).addClass("active");
        $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
        $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
        return false;
    });
    var wait1 = false;
    $(".pageSaveForm").on("click",function(){
        if(!wait1){
            for(var i = 0; i < length; ++i) { 
                codemirrorInstance[i].save();
            }
            tinymce.triggerSave();
            wait1 = true;
            $(".pageSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.page.add.post') }}",
                type: "post",
                async: true,
                data: $("#pageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".pageSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection