@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row">
            @foreach($categories as $key => $name)
            <div class="col-md-4">
                <div class="card mb-4">
                    <div class="card-header small">
                        <div class="card-title small">
                            {{ $name }}
                        </div>
                    </div>
                    <div class="card-body">
                        @foreach($messages as $message)
                        @php 
                            if($message['mtcategory'] != $key){
                                continue;
                            }
                        @endphp
                        <div class="row align-items-center mb-5">
                            <div class="col-md-8">
                                <span>
                                    @if($message['mtstatus'] == '1')
                                    <i class="fa-solid text-success fa-check"></i>
                                    @else
                                    <i class="fa-solid text-danger fa-xmark"></i>
                                    @endif
                                </span>
                                <span class="mx-2">{{ $names[$message['mtcode']] }}</span>
                            </div>
                            <div class="col-md-4 text-end">
                                <a data-bs-toggle="tooltip" title="Görüntüle" href="{{ beGetRoute('admin.messagetemplate.edit',['mtid' => $message['mtid']]) }}" class="btn"><i class="far fa-eye"></i></a>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection
@section('js')

@endsection