@extend('admin.layout')
@section('headerinclude')
<link href="assets/plugins/codemirror/codemirror.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material-darker.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/plugins/codemirror/codemirror.js"></script>
<script src="assets/plugins/codemirror/active-line.js"></script>
<script src="assets/plugins/codemirror/matchbrackets.js"></script>
<script src="assets/plugins/codemirror/xml.js"></script>
<script src="assets/plugins/codemirror/css.js"></script>
<script src="assets/plugins/codemirror/htmlmixed.js"></script>
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
.accordpool.active {
    display: flex;
    flex-shrink: 0;
    transition: all 0.2s ease-in-out;
    transform: rotate(90deg);
    align-items: center;
    justify-content: center;
    color: var(--kt-primary);
}
.accordpool.active > span {
    color: var(--kt-primary);
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="tabs">
            <div class="tab active">
                <div class="row g-5 g-xl-12 mb-7">
                    <div class="col-xl-12">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title mt-5 d-block mb-0">
                                    <div class="d-block">
                                        Mesaj Şablonları
                                    </div>
                                    <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                        @foreach($languages as $language)
                                        <li class="nav-item mt-2">
                                            <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="messageForm">
                                    @php $lastkeys = []; @endphp
                                    @foreach($languages as $language)
                                    <div class="row languageTab languageTab{{ $language['lid'] }}">
                                        @foreach(['mail' => 'Mail','alert' => 'Bildirim','sms' => 'Sms'] as $messagetype => $messagename)
                                        <div class="card bg-light p-4 my-3">
                                            <div class="row">
                                                <div class="col-md-12 my-3">
                                                    <div class="d-flex justify-content-between">
                                                        <div class="row">
                                                            <div class="col-md-10">
                                                                <label class="fs-6 fw-semibold">{{ $messagename }}</label>
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <span class="accordion-icon accordpool active" data-areaname="area[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                <span class="svg-icon svg-icon-1">
                                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor"></rect>
                                                                        <path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor"></path>
                                                                    </svg>
                                                                </span>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row p-10 dataContent" id="area[{{ $language['lid'] }}][{{ $messagetype }}]" data-status="1">
                                                    @if($messages[$language['lid']][$messagetype])
                                                    @php $message = $messages[$language['lid']][$messagetype] @endphp
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-6 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Mesaj Adı</label>
                                                                    <input type="text" class="form-control" name="mttsubject[{{ $language['lid'] }}][{{ $messagetype }}]" value="{{ $message['mttsubject'] }}">
                                                                </div>
                                                                <div class="col-6 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Durum</label>
                                                                    <div class="form-check form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="hidden" value="0" name="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                        <input class="form-check-input" type="checkbox" value="1" name="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]" id="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]"{{ $message['mttstatus'] == 1 ? ' checked':'' }}>
                                                                        <label class="form-check-label" for="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                            Bu mesaj türünün aktif olması için seçiniz.
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Mesaj İçeriği</label>
                                                                    <textarea class="form-control html-code" name="mttmessage[{{ $language['lid'] }}][{{ $messagetype }}]" rows="3">{{ $message['mttmessage'] }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @else
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-6 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Mesaj Adı</label>
                                                                    <input type="text" class="form-control" name="mttsubject[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                </div>
                                                                <div class="col-6 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Durum</label>
                                                                    <div class="form-check form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="hidden" value="0" name="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                        <input class="form-check-input" type="checkbox" value="1" name="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]" id="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                        <label class="form-check-label" for="mttstatus[{{ $language['lid'] }}][{{ $messagetype }}]">
                                                                            Bu mesaj türünün aktif olması için seçiniz.
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 mb-9">
                                                                    <label class="fs-6 fw-semibold mb-2">Mesaj İçeriği</label>
                                                                    <textarea class="form-control html-code" name="mttmessage[{{ $language['lid'] }}][{{ $messagetype }}]" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                        <div class="col-12 d-flex align-items-center">
                                            <button class="btn btn-success d-block m-auto messageSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                    @endforeach
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
var codemirrorInstance = [];
$(document).ready(function(){
    var foundtextareasarr = document.getElementsByClassName("html-code");
    for(var i = 0; foundtextareasarr[i]; ++i) { 
        codemirrorInstance[i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
            lineNumbers: true,
            mode: "htmlmixed",
            theme: "material-darker"   
        });
    }
    //$(".dataContent").css("display","none");
    $(".languageTab").addClass("d-none");
    $(".languageTab{{ $systemlid }}").removeClass("d-none").addClass("d-flex");
});
$(".form-control-select").select2();
$(".nav-language").on("click",function(){
    var lang = $(this).data("lang");
    $(".nav-language.active").removeClass("active");
    $(this).addClass("active");
    $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
    $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
    return false;
});
$(".accordpool").on("click",function(){
    var areaname = $(this).attr("data-areaname");
    var content = document.getElementById(areaname);
    if(content.dataset.status == "0"){
        content.dataset.status = "1";
        $(this).addClass("active");
        content.style.display = "block";
    }
    else{
        content.dataset.status = "0";
        $(this).removeClass("active");
        content.style.display = "none";
    }
    return false;
});
var wait = false;
var quequelist = "",counter = 1;
$(".messageSaveForm").on("click",function(){
    if(!wait){
        wait = true;
        for(var i = 0; i < codemirrorInstance.length; i++){
            codemirrorInstance[i].save();
        }
        $(".messageSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
        $.ajax({
            url: "{{ beGetRoute('admin.messagetemplate.edit.post') }}",
            type: "post",
            async: true,
            data: $("#messageForm").serialize()+quequelist+"&mtid={{ $messagetemplate['mtid'] }}",
            dataType: "json",
            crossDomain: true,
            success: function(response){
                wait = false;
                $(".messageSaveForm").html("Kaydet");
                if(response.status){
                    Swal.fire("Başarılı",response.message,"success");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
    else{
        Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
    }
    return false;
});
</script>
@endsection