@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Mesaj Gönder
                </div>
            </div>
            <div class="card-body">
                <form id="messageForm">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Mesaj Başlığı</label>
                            <input type="text" class="form-control" name="subject">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kullanıcı</label>
                            <select class="form-control form-control-select-user" name="users[]" multiple>
                                <option value="0">Belirli kullanıcılara göndermek istiyorsaınz seçiniz</option>
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ürün</label>
                            <select class="form-control form-control-select" name="products[]" multiple>
                                @foreach($products as $product)
                                <option value="{{ $product['pid'] }}">{{ $product['pname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Gönderim Tipi</label>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" name="alert" value="1" id="sendAlert"/>
                                        <label class="form-check-label" for="sendAlert">
                                            Bildirim
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" name="sms" value="1" id="sendSms"/>
                                        <label class="form-check-label" for="sendSms">
                                            SMS
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" name="email" value="1" id="sendEmail"/>
                                        <label class="form-check-label" for="sendEmail">
                                            E-Mail
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="col-4 mb-9">
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" name="onetime" value="1" id="onlyOne"/>
                                <label class="form-check-label" for="onlyOne">
                                    Aynı kullanıcıya birden fazla gönderme!
                                </label>
                            </div>
                        </div>
                        <div class="col-4 mb-9">
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" name="order" value="1" id="activeOrder"/>
                                <label class="form-check-label" for="activeOrder">
                                    Aktif hizmeti olmayanlara gönderme!
                                </label>
                            </div>
                        </div>
                        <div class="col-4 mb-9">
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" name="blocked" value="1" id="blockedMessage"/>
                                <label class="form-check-label" for="blockedMessage">
                                    İletişim engeli olanlara gönderme!
                                </label>
                            </div>
                        </div>
                        <hr>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İçerik</label>
                            <textarea class="form-control form-control-flush mb-3" rows="5" placeholder="Lütfen mesajınızı yazınız" id="messageArea" name="message"></textarea>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto sendMessage">Gönder</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script>
    $(".form-control-select").select2();
    $(".form-control-select-user").select2({
        placeholder: "Lütfen aramak istediğiniz kullanıcının isim yada soyisimini giriniz",
        minimumInputLength: 2,
        tags: false,
        ajax: {
            url: "{{ beGetRoute('admin.user.find.post') }}",
            dataType: "json",
            type: "post",
            quietMillis: 50,
            data: function (term) {
                return term;
            },
            processResults: function (data){
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.namesurname,
                            id: item.uid
                        }
                    })
                };
            },
            cache: true
        }
    });
    $(document).ready(function(){
        var options = {selector:"#messageArea",height:"480",entity_encoding:"raw",verify_html:false,plugins:'code searchreplace autolink directionality visualblocks visualchars image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons autosave fullscreen',toolbar: "undo redo print spellcheckdialog formatpainter | blocks fontfamily fontsize | bold italic underline forecolor backcolor | link image | alignleft aligncenter alignright alignjustify | code"};
        if(KTThemeMode.getMode() === "dark"){
            options["skin"] = "oxide-dark";
            options["content_css"] = "dark";
        }
        tinymce.init(options);
    });
    var wait = false;
    $(".sendMessage").on("click",function(){
        if(!wait){
            wait = true;
            $(".sendMessage").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            tinymce.triggerSave();
            $.ajax({
                url: "{{ beGetRoute('admin.marketing.message.send.post') }}",
                type: "post",
                async: true,
                data: $("#messageForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".sendMessage").html("Gönder");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection