@extend('admin.layout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Genel Ayarlar
                </div>
            </div>
            <div class="card-body">
                <form id="languageForm">
                    <div class="row">
                        @foreach($editdata as $key => $data)
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $key }}</label>
                            <textarea type="text" class="form-control" name="{{ $key }}" rows="5">{{ $data }}</textarea>
                        </div>
                        @endforeach
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editLanguage">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editLanguage").on("click",function(){
        if(!wait){
            $(".editLanguage").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.language.edit.text.post') }}",
                type: "post",
                async: true,
                data: $("#languageForm").serialize()+"&lid={{ $language['lid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".editLanguage").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection