@extend('admin.layout')
@section('content')
<style>
    #beUploadArea {
        width: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 60px;
        border: 1px dotted var(--bs-text-danger);
    }
    #fileForm #beFileInput {
        display: none;
    }   
</style>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Dosya Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="fileForm">
                    <div class="row">
                        <div class="col-12 mb-9" id="beUploadArea">
                            <label class="fs-6 fw-semibold mb-2">Dosyaları Sürükleyin Yada Seçin</label>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dosyaları Gizli Olarak Yükle</label>
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" value="1" name="secret" id="secret">
                                <label class="form-check-label" for="secret">
                                    Dosyalar gizli olarak yüklenirken dosya isimleri değiştirilir ve sadece link ile erişilebilir. Buda yavaş açılmasına sebep olur. Eğer sayfalarda kullanılacaksa dosyaları normal yükleyiniz.
                                    <br>
                                    Dosyalar gizli yüklenirken link: {{ beGetConfig('siteurl') }}/resources/uploads/dosyaadi
                                    <br>
                                    Dosyalar normal yüklenirken link: {{ beGetConfig('siteurl') }}/dosyaadi-dosyaid
                                </label>
                            </div>
                        </div>
                    </div>
                    <input type="file" class="form-control" name="files[]" multiple id="beFileInput">
                </form>
                <div class="table-responsive mt-4">
                    <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                        <thead>
                            <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                <th class="text-center align-middle">#</th>
                                <th class="text-center align-middle">Dosya Adı</th>
                                <th class="text-center align-middle">Boyut</th>
                                <th class="text-center align-middle">Yüklenme</th>
                                <th class="text-center align-middle"></th>
                            </tr>
                        </thead>
                        <tbody id="beFileList">

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var beFileCounter = 0;
    $("#beUploadArea").on("click",function(){
        $("#beFileInput").click();
        return false;
    });
    $(document).ready(function(){
        var beDropArea = document.getElementById("beUploadArea");
        ["dragenter","dragover","dragleave","drop"].forEach(evt => {
            beDropArea.addEventListener(evt,function(e){
                e.preventDefault()
                e.stopPropagation()	
            },false);
        });
        beDropArea.addEventListener("drop",function(e){
            var beFiles = e.dataTransfer.files;
            beUploadFiles(beFiles);
        },false);
        $("#beFileInput").change(function(e){
            var beFiles = e.target.files;
            beUploadFiles(beFiles);
        });
    })
    function beUploadFiles(beFiles){
        var beFormData = null;
        for(var i = 0; i < beFiles.length; i++) {
            beFileCounter += 1;
            beFormData = new FormData();
            beFormData.append("files[]",beFiles[i]);
            beFormData.append("secret",$("#secret").is(":checked") ? 1:0);
            $("#beFileList").prepend('\
                <tr id="beFileRow'+beFileCounter+'">\
                    <td class="text-center align-middle">'+beFileCounter+'</td>\
                    <td class="text-center align-middle">'+beFiles[i]['name']+'</td>\
                    <td class="text-center align-middle">'+beFiles[i]['size']+'</td>\
                    <td class="text-center align-middle">%0</td>\
                    <td class="text-center align-middle"></td>\
                </tr>\
            ');
            $.ajax({
                url : "{{ beGetRoute('admin.file.upload.post') }}",
                type : "post",
                data : beFormData,
                contentType : false,
                processData : false,
                dataType : "json",
                crossDomain: true,
                xhr: function() {
                    var beXHRRequest = new window.XMLHttpRequest();
                    beXHRRequest.upload.addEventListener("progress",function(beEvent){
                        if(beEvent.lengthComputable){
                            var bePercentComplate = (beEvent.loaded/beEvent.total)*100;
                            $("#beFileRow"+beFileCounter+">td:nth-child(3)").html("%"+Number((bePercentComplate).toFixed(1)))
                        }
                    }, false);
                    return beXHRRequest;
                },
                success:function(beResponse){
                    $.each(beResponse.uploads,function(beIndex,beData){
                        if(beData.status){
                            var beExtraText = '<br><br><span>'+beData.fileurl+'</span><br><br><span>'+beData.fileclassicurl+'</span>';
                            $("#beFileRow"+beFileCounter+">td:nth-child(5)").html('<span class="text-success">'+beResponse.message+"</span>"+beExtraText);
                        }
                        else{
                            $("#beFileRow"+beFileCounter+">td:nth-child(5)").html('<span class="text-danger">'+beResponse.message+"</span>");
                        }
                    });
                }
            });
        }	
    }
    $(".addLanguage").on("click",function(){
        if(!wait){
            $(".addLanguage").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.language.add.post') }}",
                type: "post",
                async: true,
                data: $("#botForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addLanguage").html("Ekle");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection