@extend('laylout')
@section('headerinclude')
<title>{{ $application['aname'] }} - Modülü</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
            <div class="container" id="kt_docs_content_container">
                <div class="card card-docs flex-row-fluid mb-2">
                    <div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">
                        <div>
                            <h1 class="anchor fw-bold mb-5" id="gulp-quick-start" data-kt-scroll-offset="50">{{ $application['aname'] }}</h1>
                            {{ $application['acontent'] }}
                            <div class="separator separator-dashed my-5"></div>
                            <div class="m-0">
                                <div class="d-flex align-items-center collapsible py-3 toggle mb-0 collapsed" data-bs-toggle="collapse" data-bs-target="#kt_job_1_1">
                                    <div class="btn btn-sm btn-icon mw-20px btn-active-color-primary me-5">
                                        <span class="svg-icon toggle-on svg-icon-primary svg-icon-1">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                <rect x="6.0104" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                            </svg>
                                        </span>
                                        <span class="svg-icon toggle-off svg-icon-1">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect>
                                                <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                            </svg>
                                        </span>
                                    </div>
                                    <h4 class="text-gray-700 fw-bold cursor-pointer mb-0">{{ $application['aname'] }} Modülü Faydaları</h4>
                                </div>
                                <div id="kt_job_1_1" class="collapse fs-6 ms-1">
                                    @php $aaddons = json_decode($application['aaddons'],true) @endphp
                                    @foreach($aaddons as $addons)
                                    <div class="mb-4">
                                        <div class="d-flex align-items-center ps-10 mb-n1">
                                            <span class="bullet me-3"></span>
                                            <div class="text-gray-600 fw-semibold fs-6">{{ $addons }}</div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="m-0">
                                <div class="d-flex align-items-center collapsible py-3 toggle mb-0 collapsed" data-bs-toggle="collapse" data-bs-target="#kt_job_1_2">
                                    <div class="btn btn-sm btn-icon mw-20px btn-active-color-primary me-5">
                                        <span class="svg-icon toggle-on svg-icon-primary svg-icon-1">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                <rect x="6.0104" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                            </svg>
                                        </span>
                                        <span class="svg-icon toggle-off svg-icon-1">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect>
                                                <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                            </svg>
                                        </span>
                                    </div>
                                    <h4 class="text-gray-700 fw-bold cursor-pointer mb-0">{{ $application['aname'] }} Modülü İçin Gereksinimler</h4>
                                </div>
                                <div id="kt_job_1_2" class="collapse fs-6 ms-1">
                                    @php $arequirements = json_decode($application['arequirements'],true) @endphp
                                    @foreach($arequirements as $requirement)
                                    <div class="mb-4">
                                        <div class="d-flex align-items-center ps-10 mb-n1">
                                            <span class="bullet me-3"></span>
                                            <div class="text-gray-600 fw-semibold fs-6">{{ $requirement }}</div>
                                        </div>
                                    </div>
                                    @endforeach
                                    <div class="mb-4">
                                        <div class="d-flex align-items-center ps-10">
                                            <span class="bullet me-3"></span>
                                            <div class="text-gray-600 fw-semibold fs-6">Minimum Sistem Versiyonu: {{ $application['aminversion'] }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>    
                        <div class="d-flex align-items-center rounded py-5 px-4 bg-light-info">
                            <div class="d-flex h-80px w-80px flex-shrink-0 flex-center position-relative ms-3 me-6">
                                <span class="svg-icon svg-icon-info position-absolute opacity-10">
                                    <svg class=". w-80px h-80px ." xmlns="http://www.w3.org/2000/svg" width="70px" height="70px" viewBox="0 0 70 70" fill="none">
                                        <path d="M28 4.04145C32.3316 1.54059 37.6684 1.54059 42 4.04145L58.3109 13.4585C62.6425 15.9594 65.3109 20.5812 65.3109 25.5829V44.4171C65.3109 49.4188 62.6425 54.0406 58.3109 56.5415L42 65.9585C37.6684 68.4594 32.3316 68.4594 28 65.9585L11.6891 56.5415C7.3575 54.0406 4.68911 49.4188 4.68911 44.4171V25.5829C4.68911 20.5812 7.3575 15.9594 11.6891 13.4585L28 4.04145Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                                <span class="svg-icon svg-icon-3x svg-icon-info position-absolute">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M22 19V17C22 16.4 21.6 16 21 16H8V3C8 2.4 7.6 2 7 2H5C4.4 2 4 2.4 4 3V19C4 19.6 4.4 20 5 20H21C21.6 20 22 19.6 22 19Z" fill="currentColor"></path>
                                        <path d="M20 5V21C20 21.6 19.6 22 19 22H17C16.4 22 16 21.6 16 21V8H8V4H19C19.6 4 20 4.4 20 5ZM3 8H4V4H3C2.4 4 2 4.4 2 5V7C2 7.6 2.4 8 3 8Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                            </div>
                            <div class="text-gray-700 fw-bold fs-6 lh-lg">
                                <span class="d-block">Sistem Versiyonu: v{{ $version }}</span>
                                <span class="d-block">Sistem Versiyonu(Build): {{ $build }}</span>
                                <span class="d-block {{ $build >= $application['aminversion'] ? 'text-success':'text-danger'}}">Gerekli Minimum Versiyonu(Build): {{ $application['aminversion'] }}</span>
                            </div>
                        </div>
                        @if(in_array($application['aid'],$hasapplications))
                        @if(!$applicationexits)
                        <div class="rounded border p-10 d-flex align-items-center p-5 mt-10">
                            <div class="d-flex flex-column">
                                <span class="d-block text-white">
                                    {{ $application['aname'] }} Modülünü Yüklemek İçin Yükle Butonuna Basınız
                                </span>
                                <a href="#" class="btn btn-info mt-10 btnUpdate"><i class="bi bi-vector-pen fs-4 me-2"></i> Yükle</a>
                            </div>
                        </div>
                        @else
                        <div class="rounded border p-10 d-flex align-items-center p-5 mt-10">
                            <div class="d-flex flex-column">
                                <span class="d-block text-success">
                                    {{ $application['aname'] }} Modülünü Kurulmuş Durumda
                                </span>
                            </div>
                        </div>
                        @endif
                        @else
                        <div class="rounded border p-10 d-flex align-items-center p-5 mt-10">
                            <div class="d-flex flex-column">
                                <span class="d-block text-white">
                                    {{ $application['aname'] }} modülü siparişinizde bulunmadığı için onu kullanamazsınız.
                                </span>
                                <span class="d-block text-white">
                                    {{ $application['aname'] }} modülünü satın almak için Satın Al butonuna basınız.
                                </span>
                                <a href="https://www.diyosoftware.com/musteri-paneli/hizmet/{{ $userproduct['upid'] }}" class="btn btn-info mt-10"><i class="bi bi-vector-pen fs-4 me-2"></i> Satın Al</a>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                <div class="card mt-10">
                    <div class="card-body d-flex align-items-center p-5 p-lg-8">
                        <div class="d-flex h-50px w-50px h-lg-80px w-lg-80px flex-shrink-0 flex-center position-relative align-self-start align-self-lg-center mt-3 mt-lg-0">
                            <span class="svg-icon svg-icon-primary position-absolute opacity-15">
                                <svg class=". h-50px w-50px h-lg-80px w-lg-80px ." xmlns="http://www.w3.org/2000/svg" width="70px" height="70px" viewBox="0 0 70 70" fill="none">
                                    <path d="M28 4.04145C32.3316 1.54059 37.6684 1.54059 42 4.04145L58.3109 13.4585C62.6425 15.9594 65.3109 20.5812 65.3109 25.5829V44.4171C65.3109 49.4188 62.6425 54.0406 58.3109 56.5415L42 65.9585C37.6684 68.4594 32.3316 68.4594 28 65.9585L11.6891 56.5415C7.3575 54.0406 4.68911 49.4188 4.68911 44.4171V25.5829C4.68911 20.5812 7.3575 15.9594 11.6891 13.4585L28 4.04145Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <span class="svg-icon svg-icon-2x svg-icon-lg-3x svg-icon-primary position-absolute">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.3" d="M22.0318 8.59998C22.0318 10.4 21.4318 12.2 20.0318 13.5C18.4318 15.1 16.3318 15.7 14.2318 15.4C13.3318 15.3 12.3318 15.6 11.7318 16.3L6.93177 21.1C5.73177 22.3 3.83179 22.2 2.73179 21C1.63179 19.8 1.83177 18 2.93177 16.9L7.53178 12.3C8.23178 11.6 8.53177 10.7 8.43177 9.80005C8.13177 7.80005 8.73176 5.6 10.3318 4C11.7318 2.6 13.5318 2 15.2318 2C16.1318 2 16.6318 3.20005 15.9318 3.80005L13.0318 6.70007C12.5318 7.20007 12.4318 7.9 12.7318 8.5C13.3318 9.7 14.2318 10.6001 15.4318 11.2001C16.0318 11.5001 16.7318 11.3 17.2318 10.9L20.1318 8C20.8318 7.2 22.0318 7.59998 22.0318 8.59998Z" fill="currentColor"></path>
                                    <path d="M4.23179 19.7C3.83179 19.3 3.83179 18.7 4.23179 18.3L9.73179 12.8C10.1318 12.4 10.7318 12.4 11.1318 12.8C11.5318 13.2 11.5318 13.8 11.1318 14.2L5.63179 19.7C5.23179 20.1 4.53179 20.1 4.23179 19.7Z" fill="currentColor"></path>
                                </svg>
                            </span>
                        </div>
                        <div class="ms-6">
                            <p class="list-unstyled text-gray-600 fw-semibold fs-6 p-0 m-0">Belirtilen modülü yükleyebilmek için <a href="https://www.diyosoftware.com" target="_blank">DiyoSoftware.COM</a> üzerinden {{ $application['aname'] }} modülünü satın almanız gerekmektedir! Aksi taktitde yükleme işlemi başarısız olacaktır eğer sonradan {{ $application['aname'] }} modülünü almak isterseniz lütfen <a href="https://www.teamdiyo.com" target="_blank">TeamDiyo.COM</a> üzerinden ürününüzü güncelleyin.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".btnUpdate").on("click",function(){
        if(!wait){
            $(".btnUpdate").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('client.application.installfiles.post') }}",
                type: "post",
                async: true,
                data: {slug:"{{ $application['aslug'] }}"},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".btnUpdate").html('<i class="bi bi-vector-pen fs-4 me-2"></i> Güncelle');
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },3000);
                    }
                    else{
                        $(".btnUpdate").html('<i class="bi bi-vector-pen fs-4 me-2"></i> Güncelle');
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection