<?php

    namespace App\System\Plugin;

    use App\System\Model\SettingGroupsModel;
    use App\System\Vendor\bePlugin;
    use App\System\Model\SettingModel;

    class netgsm_helper {
        public function plugin_info(){
            return [
                "name" => "NetGsm Sms Modülü",
                "description" => "SMS'leri netgsm ile göndermenizi sağlar",
                "version" => "1.2",
                "vercode" => 12,
                "author" => "ITenGriTR",
            ];
        }
        public function plugin_hooks(){
            return [];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","netgsm")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("netgsm","NetGsm Ayarları","Sms gönderimleri için NetGsm ayarlarını içerinin");
            bePlugin::beCreateSetting($sgid,"netgsm_usercode","Kullanıcı Kodu","Netgsm tarafından sağlanan usercode değerini girin","str","");
            bePlugin::beCreateSetting($sgid,"netgsm_password","Kullanıcı Şifrei","Netgsm tarafından sağlanan password değerini girin","str","");
            bePlugin::beCreateSetting($sgid,"netgsm_header","Mesaj Başlığı","Netgsm tarafından sağlanan telefon numarası değerini girin(8503083156)","str","");
            return [
                "status" => true,
                "message" => "Başarılı bir şekilde eklenti kuruldu!",
                "data" => [
                    "sgid" => $sgid
                ]
            ];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","netgsm")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
    }
?>